/*
 * mpeg2decoder.h: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id: mpeg2decoder.h,v 1.4 2004/01/24 16:57:23 dom Exp $
 */
#ifndef MPEG2DECODER_H
#define MPEG2DECODER_H

#include <vdr/plugin.h>
#include <vdr/ringbuffer.h>
#define MAX_HDR_LEN 0xFF




class cMpeg2Decoder {
private:
    uint8_t * audiosamples;
    int  state, payload, streamtype;
    unsigned char header[6];     
    unsigned int syncword;
    int  ofd;   
    uint64_t commonPTS;
    cRingBufferLinear *m_RingBuffer;
    bool running;
    bool decoding;
    bool sent_header;
public:
    cMpeg2Decoder(int fd);
    ~cMpeg2Decoder();
    void Clear(void);
    int Decode(const uchar *Data, int Length);
    void Start(void);
    void Stop(void);
    void GetVidInfo(uint8_t *mbuf, int count);

};

#endif // MPEG2DECODER_H
