/*
 * mpeg2decoder.c: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id: mpeg2decoder.c,v 1.4 2004/01/24 16:57:23 dom Exp $
 */

#include <vdr/plugin.h>
#include <sys/ioctl.h>
#include "ivtv-ext-api.h"
#include "mpeg2decoder.h"
#include "demux.h"

#define UNSYNCED 0
#define PAYLOAD 100
#define PAYLOADDATA 200
#define HEADER 300
#define OPTHEADER 400
#define STREAM 500



cMpeg2Decoder::cMpeg2Decoder(int fd) 
{

    printf("cMpeg2Decoder created. ready to decode.\n");
    state=UNSYNCED;
    ofd = fd;  
    running=false;
    decoding=false;
    sent_header = false;
    m_RingBuffer = new cRingBufferLinear(3000 * 1024, 0, true);
    new cPvr350Demux(m_RingBuffer,fd);


}

cMpeg2Decoder::~cMpeg2Decoder() {
    printf("Shutting down MPEG Decoder ...\n");
  
}

void cMpeg2Decoder::Start(void)
{   
    running=true;
}

void cMpeg2Decoder::Stop(void)
{
    
    if (running) {
        running=false;
        printf("Halte Klassen an\n");
        while (decoding) {
            usleep(1);
        }
    }

}

void cMpeg2Decoder::Clear(void)
{
    m_RingBuffer->Clear();
}
    
void cMpeg2Decoder::GetVidInfo(uint8_t *mbuf, int count)
{
	uint8_t *headr;
	int found = 0;
        int sw;
	int form = -1;
	int c = 0;
    struct ivtv_ioctl_fwapi   fwcall;
    int   ret;

    fwcall.cmd = 0x56;
    fwcall.result = 0x00;
    fwcall.args = 4;
    fwcall.data[2] = fwcall.data[3] = 0;

	while (found < 4 && c+4 < count){
		uint8_t *b;

		b = mbuf+c;
		if ( b[0] == 0x00 && b[1] == 0x00 && b[2] == 0x01
		     && b[3] == 0xb3) found = 4;
		else {
			c++;
		}
	}

	if (! found) return;
	c += 4;
	if (c+12 >= count) return;
	headr = mbuf+c;


    int horizontal_size	= ((headr[1] &0xF0) >> 4) | (headr[0] << 4);
    int vertical_size	= ((headr[1] &0x0F) << 8) | (headr[2]);
    sw = (int)((headr[3]&0xF0) >> 4) ;
    
    
    switch ( sw ) {
    case 1:
        fprintf(stderr,"Videostream: ASPECT: 1:1");        
        break;
    case 2:
        fprintf(stderr,"Videostream: ASPECT: 4:3");
        if ( horizontal_size < vertical_size) {
            fwcall.data[0] = 720;
            fwcall.data[1] = 576;
            fwcall.data[2] = 0;
            fwcall.data[3] = 0;
        } else {
            fwcall.data[0] = horizontal_size;
            fwcall.data[1] = vertical_size;
            fwcall.data[2] = (720 - fwcall.data[0]) / 2;
            fwcall.data[3] = (576 - fwcall.data[1]) / 2;
        }
        if ( ( ret = ioctl(ofd,IVTV_IOC_FWAPI,&fwcall) ) < 0 ) {
            printf("size set\n");
        }
        break;
    case 3:
        fprintf(stderr,"Videostream: ASPECT: 16:9");
        if ( horizontal_size < vertical_size) {
            fwcall.data[0] = 720;
            fwcall.data[1] = (720 / 16) * 9;
            fwcall.data[2] = (720 - fwcall.data[0]) / 2;
            fwcall.data[3] = (576 - fwcall.data[1]) / 2;
        } else {
            fwcall.data[0] = horizontal_size;
            fwcall.data[1] = ( fwcall.data[0] ) / 16 * 9;
            fwcall.data[2] = (720 - fwcall.data[0]) / 2;
            fwcall.data[3] = (576 - fwcall.data[1]) / 2;
        }

        if ( ( ret = ioctl(ofd,IVTV_IOC_FWAPI,&fwcall) ) < 0 ) {
            printf("size set\n");
        }
        break;
    case 4:
        fprintf(stderr,"Videostream: ASPECT: 2.21:1");
        break;                    
    case 5 ... 15:
        fprintf(stderr,"Videostream: ASPECT: reserved");
        break;
    default:
        printf("Unknown aspect\n");
        break;
    }
    printf("Size is %d x %d\n",horizontal_size,vertical_size);
}

int cMpeg2Decoder::Decode(const uchar *Data, int Length) 
{
    int len, streamlen;
    uint8_t *inbuf_ptr;                                 
    inbuf_ptr = (uint8_t *)Data;
    int size=Length;
    decoding=true;
  
    while (size > 0) {
        len=1;
        switch (state) {
	    case UNSYNCED:
            syncword = (syncword << 8) | *inbuf_ptr;
	    	if ( (syncword >= 0x000001E0) && (syncword <= 0x000001EF) ) {
                //    printf("Sync word is %x\n",syncword);
                state=PAYLOAD;
                streamtype= 0xe0;
                GetVidInfo(inbuf_ptr,size);
            } else if ( (syncword == 0x000001C0)  && (syncword <= 0x000001CF) ) {
                state=PAYLOAD;
                streamtype= syncword- 0x00000100;
            } else if ( ( syncword == 0x000001b3) ) {
               
            }
            break;
	    case PAYLOAD:		//Payload length(hi)
            payload = *inbuf_ptr << 8;
            state++;
            break;
	    case PAYLOAD+1:		//Payload length(lo)
            payload += *inbuf_ptr;
            header[0]=0;
            header[1]=0;
            header[2]=1;
            header[3]=streamtype;
            header[4]=payload >> 8;
            header[5]=payload & 0xFF;
            m_RingBuffer->Put(header,6);           
            sent_header = false;
            state=PAYLOADDATA;
            break;
	    case PAYLOADDATA:

            streamlen =min(payload,size);
#if 0
            if ( sent_header == false ) {
//                unsigned char *buf = (unsigned char *)malloc(streamlen+6);
                write(ofd,header,6);
                write(ofd,inbuf_ptr,streamlen);
                //              memcpy(buf,header,6);
//                memcpy(buf+6,inbuf_ptr,streamlen);
//                printf("Writing %d\n",streamlen+6);
//                write(ofd,buf,streamlen+6);
//                free(buf);
//                sent_header = true;
            } else {
                printf("Writing2 %d\n",streamlen);

                write(ofd,inbuf_ptr,streamlen);
            }
#else

            m_RingBuffer->Put(inbuf_ptr,streamlen);           
#endif

            payload-=streamlen; 
            len = streamlen;
            if ( payload <= 0 ) {
                state = UNSYNCED;
                syncword = 0;
            }
            break;
        }
    	size -= len;
        inbuf_ptr += len;
    }
    decoding=false;
    //printf ("v-a: %llu \ta-v: %llu \tvpts %llu\tapts %llu\n",(vpts-apts), (apts-vpts),vpts,apts);
    return Length;
}


