

#include "demux.h"

#include <unistd.h>
#include <fcntl.h>


cPvr350Demux::cPvr350Demux(cRingBufferLinear *ring, int fd)
{
    output = fd;

    m_RingBuffer = ring;

    Start();
}



cPvr350Demux::~cPvr350Demux()
{
    Cancel();
}



void cPvr350Demux::Action()
{ 
    unsigned char *buf;
    int length;
    int payload;
    printf("Demux started pid %d\n",getpid());
	while(1) {
        if ( (buf = m_RingBuffer->Get(length) ) != NULL ) {
#if 0
            if ( length > 6 && buf[0] == 0x00 && buf[1] == 0x00 && buf[2] == 0x01 && 
                 (buf[3] == 0xc0 || buf[3] == 0xE0) ) {
                payload = buf[4] << 8 | buf[5];
                printf("%d %02x %02x %02x %02x %02x %02x load %d\n",length,buf[0],buf[1],buf[2],buf[3],buf[4],buf[5],payload);

                if ( length >= payload + 6 ) {
                    safe_write(output,buf,payload+6);                           
                    m_RingBuffer->Del(payload+6);       
                }
            }
#else
            if ( length >= 4000 ) {
                length = 4000;
                safe_write(output,buf,length);                           
                m_RingBuffer->Del(length);  
            } else {
                usleep(1);
            }
#endif
        } else {
            usleep(1);
        }
                         
    }       
}

