/*
 *  MediaMVP Output Device for VDR
 *
 *  $Id: mvpwrap.c,v 1.2 2004/05/22 16:41:27 dom Exp $ 
 *  $Date: 2004/05/22 16:41:27 $
 *
 *  This wraps up the real device in a redirecting layer
 *
 *  The main action takes place in a thread.
 *
 */


#include "mvpwrap.h"


cMvpWrap::cMvpWrap()
{

}

cMvpWrap::~cMvpWrap()
{

}

void cMvpWrap::MakePrimaryDevice(bool On)
{
#if VDRVERSNUM >= 10307
    Program.NewOsdProvider();
#endif
}

int cMvpWrap::ProvidesCa(int Ca)
{
    return 0;
}

bool cMvpWrap::HasDecoder(void) const
{
    return true;
}


bool cMvpWrap::CanReplay(void) const
{
    return true;
}


bool cMvpWrap::SetPlayMode(ePlayMode PlayMode)
{
    return Program.SetPlayMode(PlayMode);
}

void cMvpWrap::TrickSpeed(int Speed)
{

    return;
}

void cMvpWrap::Clear(void)
{
    return;
}

void cMvpWrap::Play(void)
{
    Program.SendEvent(MEVT_PLAY);
}

void cMvpWrap::Freeze(void)
{
    Program.SendEvent(MEVT_PAUSE);
}

void cMvpWrap::Mute(void)
{
    Program.SendEvent(MEVT_MUTE);
}



void cMvpWrap::StillPicture(const uchar *Data, int Length)
{

}

int cMvpWrap::PlayVideo(const uchar *Data, int Length)
{
    Program.PlayVideo(Data,Length);
    return Length;
}

void cMvpWrap::SetVideoFormat(bool VideoFormat16_9)
{

}

void cMvpWrap::SetVolumeDevice(int Volume)
{
//    Program.SendEvent(MEVT_VOLUME, (Volume / 100 ) * 14 );
}

bool cMvpWrap::Poll(cPoller &Poller, int TimeoutMs)
{
    Program.Poll(Poller,TimeoutMs);
    return true;
}

#if VDRVERSNUM < 10307
cOsdBase *cMvpWrap::NewOsd(int x, int y)
{
    return Program.NewOsd(x,y);
}
#endif
