/*
 *   MediaMVP Server Font Library
 *
 *   (C) 2004 Dave Kelly
 *
 *   $Id: mvpfont.h,v 1.3 2004/05/02 21:09:30 ravelox Exp $
 *   $Date: 2004/05/02 21:09:30 $
 *
 */


#ifndef MVPFONT_H
#define MVPFONT_H

#ifdef __cplusplus
extern "C" {
#endif

#include "libmvp.h"

typedef struct _glyph          glyph_t;
typedef struct _font           font_t;

#define MVPFONT_MAGIC  "mvpfont-"


extern void           delete_glyph(glyph_t *glyph);
extern void           glyph_add_bitmap(glyph_t *glyph, int bitmap);
extern int           *glyph_get_bitmap(glyph_t *glyph);
extern void           glyph_set_height(glyph_t *glyph, int height);
extern int            glyph_get_height(glyph_t *glyph);
extern void           glyph_set_width(glyph_t *glyph, int width);
extern int            glyph_get_width(glyph_t *glyph);
extern font_t        *new_font();
extern int            font_is_defined(font_t *font, int glyph_id);
extern font_t        *font_load(char *font_name);
extern void           font_set_name(font_t *font, char *display_name);
extern int            font_get_height(font_t *font);
extern int            font_get_width(font_t *font);
extern int            font_get_glyph_max(font_t *font);
extern int            font_get_glyph_num(font_t *font);
extern glyph_t       *font_get_glyph(font_t *font, int glyph_id);
extern void           delete_font(font_t *font);
extern font_t        *font_read(char *data);
extern int			  font_get_textwidth(font_t *font, char *text);

extern unsigned char default_font[];

#ifdef __cplusplus
}
#endif


#endif /* MVPFONT_H */
