/*
 *   MediaMVP Server
 *
 *   (C) 2004 Dominic Morris
 *
 *   $Id: dialoglive.c,v 1.1 2004/08/30 08:55:24 ravelox Exp $
 *   $Date: 2004/08/30 08:55:24 $
 *
 *
 *   Implements the skeleton application
 * 
 */

#include "mvpwindow.h"

typedef struct {
    dongle_t     *dongle;


    window_t     *root;
    window_t     *sub;

} program_t;;


window_t *box, *label;

int zorder = 0;

mvpinit_t          init = MVPINIT_INITIALISER;

static int         c_gui_width       = 640;   
static int         c_gui_depth       = 480;   
static int         c_screen_width    = 720;   
static int         c_screen_depth    = 576;  

static int      program_open(dongle_t *dongle, application_t *application);
static void     program_close(application_t *application);
static uint8_t *program_get_surface(application_t *application, int *size);
static void     program_keypress(application_t *application, int keycode);
static void     program_ack(application_t *application, int ackcode, unsigned char *buf, int buflen);
static int      program_authorise(char *mac_address, uint32_t ipaddr, int connected);


static void yes_callback(window_t *window, event_t event, void *cb_ptr, void *param)
{
	fprintf(stderr, "YES PRESSED\n");
}
static void no_callback(window_t *window, event_t event, void *cb_ptr, void *param)
{
	fprintf(stderr, "NO PRESSED\n");
}
static void cancel_callback(window_t *window, event_t event, void *cb_ptr, void *param)
{
	fprintf(stderr, "CANCEL PRESSED\n");
}

void program_init(mvpinit_t *init)
{
    /* Set up the initial callbacks */
    init->open = program_open;
    init->authorise = program_authorise;

}

/** \brief Populate the provide application with our callbacks
 *
 *  \param dongle The dongle this is being setup for
 *  \param application Parameter block to populate
 *
 *  \return 0 on success, -1 on failure
 *
 *  This function is called via a callback from the library.
 *  We allocate our surface here and startup our menu system here.
 */
static int program_open(dongle_t *dongle, application_t *application)
{
    program_t   *program = (program_t *) calloc(1,sizeof(*program));

    /* We should pick up appropriate parameters for the dongle here, or
       alternatively refuse the connection?
    */

    program->dongle = dongle;

  

    application->data = (void *) program;

    /* Set up the appropriate callback functions */
    application->close = program_close;
    application->get_yvuy_surface = program_get_surface;
    application->keypress = program_keypress;
    application->ack = program_ack;

    application->gui_width = c_gui_width;
    application->gui_depth = c_gui_depth;
    application->screen_width = c_screen_width;
    application->screen_depth = c_screen_depth;


    
    /* Finally, startup our application */
    program->root = new_root(c_gui_width,c_gui_depth,8);    
    window_set_name(program->root,"ROOT");
    surface_clear(window_get_draw_surface(program->root),0x00000000);

	program->sub = new_dialog(program->root, 100, 100, 400,350,"Would you like to quit ?",
			DIALOG_YES | DIALOG_NO | DIALOG_CANCEL );

	window_dump_window(program->sub);

	window_register_callback(program->sub, event_yes, yes_callback, NULL);
	window_register_callback(program->sub, event_no, no_callback, NULL);
	window_register_callback(program->sub, event_cancel, cancel_callback, NULL);
    return 0;
}

/** \brief Delete the application
 *
 *  \param application Application to delete for
 */
static void program_close(application_t *application)
{
    program_t   *program = (program_t *)application->data;

  
    /* Delete the dinwos */


    free(program);
}

/** \brief Return the yvuy surface
 *
 *  \param application
 *  \param size Pointer to place the surface size
 *
 *  \return a rendered surface, or NULL if it's not been updated recently
 */
static uint8_t *program_get_surface(application_t *application, int *size)
{
    program_t  *program = (program_t *)application->data;
    surface_t  *sfc = window_get_draw_surface(program->root);

    if( window_draw(program->root) > 0) {
		return (uint8_t *) surface_map(sfc,MAP_YVU,size);  
	}

	return NULL;
}

/** \brief Handle a keypress
 *
 *  \param application
 *  \param keycode Key code from the MVP
 *
 */
static void program_keypress(application_t *application, int keycode)
{
	program_t *program = (program_t *)application->data;

	window_dispatch_event(program->root, keycode);
}

/** \brief Handle an ack
 *
 *  \param application
 *  \param ackcode Type of ack
 *  \param buf Ack message
 *  \param buflen Length of ack message
 */
static void program_ack(application_t *application, int ackcode, unsigned char *buf, int buflen)
{
    program_t  *program = (program_t *)application->data;
}



/** \brief Check to see whether we should permit this dongle to connect
 *  
 *  \param mac_address The mac address of the dongle trying to connect
 *  \param ipaddr      The ipv4 ip address of the dongle trying to connect
 *  \param connected   Number of dongles already connected
 *
 *  \return 0 do not allow to connect, 1 permit to connect
 *
 *  This is a callback from the library and is called when the service
 *  locator message is received by the server
 */
static int program_authorise(char *mac_address, uint32_t ipaddr, int connected)
{
    /* We always permit dongles to connect */
    return 1;
}










int main(int argc, char *argv[])
{
    char hostbuf[2048];


    if ( gethostname(hostbuf,sizeof(hostbuf)-1) == -1 ) {
        perror("gethostbyname");
        exit(1);
    }
   
    if ( ( init.main_interfaceip = host_resolve(hostbuf) ) == - 1 ) {
        fprintf(stderr,"Cannot resolve host <%s>\n",hostbuf);
        exit(1);
    }

    event_init();
    
    init.logfile = stderr;
    init.dongle_version = 22050;
	init.debug_level = 0;

    program_init(&init);

    if ( mediamvp_server_init(&init) ) {
        exit(1);
    }

   
    event_dispatch();


    return 0;
}




/*
 * Local Variables:
 *  indent-tabs-mode:nil
 *  require-final-newline:t
 *  c-basic-offset: 4
 * End:
 */
