/*
 *   MediaMVP Server Library
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: dongle.c,v 1.15 2004/05/07 19:39:03 dom Exp $
 *   $Date: 2004/05/07 19:39:03 $
 *
 *
 *   Dongle registration - maintains a list of dongles with their subcomponents
 */


#include "libmvp_internal.h"



static dongle_t   dongles[NUM_DONGLES];




dongle_t *dongle_return(char *address)
{
    dongle_t  *dongle;
    int        i;
    int        first = -1;

    for ( i = 0; i < NUM_DONGLES; i++ ) {
        if ( strcmp(dongles[i].address,address) == 0 && dongles[i].inuse ) {
            return &dongles[i];
        }
        if ( dongles[i].inuse == FALSE && first == -1 ) {
            first = i;
        }
    }

    Dprintf(INFO,"Registering new dongle at IP %s\n",address);

    if ( first != -1 ) {
        dongle=&dongles[first];
    } else {
        Dprintf(INFO,"No more dongles available\n");
        return NULL;  /* No more dongles available */
    }


    strcpy(dongle->address,address);
    dongle->inuse = TRUE;
    dongle->gui = NULL;
    dongle->stream = NULL;


    /* Reset to defaults - we ask client for details of these settings */
    dongle->tvmode = 0;
    dongle->videooutput = 0;
    dongle->flickermode = 0;
    dongle->aspectratio = 0;

    return dongle;
}


void dongle_close(dongle_t *dongle)
{

    Dprintf(INFO,"Closing dongle at address %s\n",dongle->address);

    if ( dongle->gui ) {
        delete_gui(dongle->gui);
    }

    if ( dongle->stream ) {
        delete_stream(dongle->stream);
    }
    dongle->stream = NULL;
    dongle->gui    = NULL;
    /* Close gui/stream here */
    dongle->inuse = FALSE;
}

void dongle_closeall()
{
    int          i;

    for ( i = 0; i < NUM_DONGLES; i++ ) {
        dongle_close(&dongles[i]);
    }
}

void dongle_send_play(dongle_t *dongle, char *name)
{
    if ( dongle->gui ) {
        gui_send_play(dongle->gui,name);
    }
}


void dongle_send_message(dongle_t *dongle, int msgtype)
{
    if ( dongle->gui ) {
        gui_send_message(dongle->gui,msgtype);
    }
}

void dongle_send_percent(dongle_t *dongle, int msgtype, int percent)
{
    if ( dongle->gui ) {
        gui_send_percent(dongle->gui,msgtype, percent);
    }
}

void dongle_send_settings(dongle_t *dongle, int subcommand)
{
    if ( dongle->gui ) {
        gui_send_settings(dongle->gui,subcommand);
    }
}

int dongle_get_type(dongle_t *dongle)
{
    if ( dongle->stream ) {
        return stream_get_type(dongle->stream);
    } else {
        return 0;
    }
}

int dongle_get_lasttype(dongle_t *dongle)
{
    if ( dongle->stream ) {
        return stream_get_lasttype(dongle->stream);
    } else {
        return 0;
    }
}

char *dongle_get_streamname(dongle_t *dongle)
{
    if ( dongle->stream ) {
        return stream_get_name(dongle->stream);
    } else {
        return NULL;
    }
}

/* Return the number of dongles currently connected */
int dongle_count()
{
    int    num;
    int    i;

    for ( num = 0,i = 0; i < NUM_DONGLES; i++ ) {
        num += dongles[i].inuse;
    }

    return num;
}

int dongle_authorise(char *mac_addr, uint32_t ipaddr)
{
    if ( initparams->authorise ) {
        return (initparams->authorise)(mac_addr,ipaddr,dongle_count());
    }

    return 1;  /* Always permit a connection */
}

void dongle_update_screen(dongle_t *dongle)
{
    if ( dongle->gui ) {
        gui_send_screen(dongle->gui);
    }
}



/*
 * Local Variables:
 *  indent-tabs-mode:nil
 *  require-final-newline:t
 *  c-basic-offset: 4
 * End:
 */
