/*
 * hello.c: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id: mediamvp.c,v 1.7 2004/05/11 20:02:55 dom Exp $
 */

#include "mediamvp.h"
#include "setup.h"
#include "server.h"
#include "i18n.h"
#include <getopt.h>



const char *cPluginMediamvp::VERSION        = SERVER_VERSION;
const char *cPluginMediamvp::DESCRIPTION    = "Mediamvp Support";


// --- cPluginMediamvp ----------------------------------------------------------

cPluginMediamvp::cPluginMediamvp(void)
{
  // Initialize any member variables here.
  // DON'T DO ANYTHING ELSE THAT MAY HAVE SIDE EFFECTS, REQUIRE GLOBAL
  // VDR OBJECTS TO EXIST OR PRODUCE ANY OUTPUT!
}

cPluginMediamvp::~cPluginMediamvp()
{
  // Clean up after yourself!
}

const char *cPluginMediamvp::CommandLineHelp(void)
{
    return "  -f fontfile,  --aaa=fontfile   Use specified font for menus\n";
}

bool cPluginMediamvp::ProcessArgs(int argc, char *argv[])
{
    static struct option long_options[] = {
        { "font",      required_argument, NULL, 'f' },
        { NULL }
    };
    int c;

    while ((c = getopt_long(argc, argv, "f:", long_options, NULL)) != -1) {
        switch ( c ) {
        case 'f':
            c_font_file = optarg;
            break;
        default:
            return false;
        }
    }


    return true;
}

bool cPluginMediamvp::Start(void)
{
    // Start any background activities the plugin shall perform.

    /* Start up the server here.. */
    RegisterI18n(Phrases);
    cMediamvpServer::Init();
    return true;
}

void cPluginMediamvp::Housekeeping(void)
{

  // Perform any cleanup or other regular tasks.
}


cMenuSetupPage *cPluginMediamvp::SetupMenu(void)
{
    // Return a setup menu in case the plugin supports one.
    return new cMediamvpMenuSetupPage;
}

bool cPluginMediamvp::SetupParse(const char *Name, const char *Value)
{
    if ( strcmp(Name,"stream_port") == 0 ) {
        MediamvpSetup.stream_port = atoi(Value);
    } else if ( strcmp(Name,"gui_port") == 0 ) {
        MediamvpSetup.gui_port = atoi(Value);
    } else if ( strcmp(Name,"dongle_version") == 0 ) {
        MediamvpSetup.dongle_version = atoi(Value);
    } else if ( strcmp(Name,"screen_width") == 0 ) {
        c_screen_width = atoi(Value);
    } else if ( strcmp(Name,"screen_depth") == 0 ) {
        c_screen_depth = atoi(Value);
    } else if ( strcmp(Name,"gui_width") == 0 ) {
        c_gui_width = atoi(Value);
    } else if ( strcmp(Name,"gui_depth") == 0 ) {
        c_gui_depth = atoi(Value);
    } else if ( strcmp(Name,"debug_level") == 0 ) {
        MediamvpSetup.debug_level = atoi(Value);
    } else if ( strcmp(Name,"screensaver") == 0 ) {
        c_screensaver = atoi(Value);
    } else if ( strcmp(Name,"standardswitch") == 0 ) {
        c_standard_switch = atoi(Value);
        return false;
    }

    return true;
}

VDRPLUGINCREATOR(cPluginMediamvp); // Don't touch this!
