/*
 *   MediaMVP Server Library
 *
 *   (C) 2004 Dave Kelly
 *
 *   Use ImageMagick libraries to blit an image to a surface 
 *
 *   $Id: image.c,v 1.3 2004/05/13 12:09:53 ravelox Exp $
 *   $Date: 2004/05/13 12:09:53 $
 *
 */

#include "libmvp.h"

#ifdef HAVE_MAGICK
#include <magick/api.h>

int mvp_image_display(surface_t *surface,char *filename, int x0, int y0, int width, int depth)
{
	ExceptionInfo exception;
	Image *image;
	ImageInfo *image_info;
	int x,y, bpp;
	uint32_t rgb;
	Image *resized_image = NULL;
	int x_offset = 0, y_offset = 0;
	int image_width, image_height;
	const PixelPacket *pixels = NULL;

	InitializeMagick(NULL);
	GetExceptionInfo(&exception);

	image_info = CloneImageInfo((ImageInfo *)NULL);
	(void)strcpy(image_info->filename, filename);
	image = ReadImage(image_info, &exception);

	if ( image == (Image *) NULL ) {
		return -1;
	}

	if ( exception.severity != UndefinedException ) {
#if MAGICK_VERSION >= 6
		CatchException(&exception);
#else
        CatchImageException(image);
#endif
	}


#if 0
	DescribeImage(image, stderr, 1);
#endif

	bpp = GetImageDepth(image, &exception);
	if(exception.severity != UndefinedException) {
#if MAGICK_VERSION >= 6
		CatchException(&exception);
#else
        CatchImageException(image);
#endif
	}

	Dprintf(DEBUG, "Image Depth: %u\n", bpp);

	image_width = image->columns;
	image_height = image->rows;

	if(image->columns > width ) {
		image_width = width;
	}

	if(image->rows > depth ) {
		image_height = depth;
	}

	if ( image->columns != image_width || image->rows != image_height ) {
		resized_image = SampleImage(image, image_width, image_height, &exception);
		if ( exception.severity != UndefinedException ) {
#if MAGICK_VERSION >= 6
            CatchException(&exception);
#else
            CatchImageException(image);
#endif
		}
	}

	/* Centre the image */
	x_offset = (width / 2 ) - (image_width / 2);
	if ( x_offset < 0 ) {
		x_offset = 0;
	}
	y_offset = (depth / 2 ) - (image_height / 2);
	if ( y_offset < 0 ) {
		y_offset = 0;
	}

	if(resized_image) {
		pixels = AcquireImagePixels(resized_image, 0, 0, image_width, image_height, &exception);
	} else {
		pixels = AcquireImagePixels(image, 0, 0, image_width, image_height, &exception);
	}


    if ( exception.severity != UndefinedException ) {
#if MAGICK_VERSION >= 6
        CatchException(&exception);
#else
        CatchImageException(image);
#endif
    }


	for(y = 0 ; y < image_height ; y++ ) {
		for(x = 0 ; x < image_width ; x++ ) {
			switch(bpp) {
            case 8:
                rgb = (( (pixels->red) & 0xFF)<< 16) + ((pixels->green & 0xFF) << 8) + (pixels->blue & 0xFF);
                break;
            default:
                rgb = ( (pixels->red)  << 16) + (pixels->green << 8) + (pixels->blue);
                break;
			}

			surface_set_pixel(surface, x + x_offset, y + y_offset, rgb);
			++pixels;
		}
	}

	if(resized_image) {
		DestroyImage(resized_image);
	}

	DestroyImage(image);
	DestroyImageInfo(image_info);
	DestroyExceptionInfo(&exception);
	DestroyMagick();

    return 0;
}

#endif

/*
 * Local Variables:
 *  indent-tabs-mode:nil
 *  require-final-newline:t
 *  c-basic-offset: 4
 * End:
 */
