/*
 *   MediaMVP Plugin
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: vdrurl.h,v 1.2 2004/01/19 21:52:00 dom Exp $
 *   $Date: 2004/01/19 21:52:00 $
 *
 *
 *   Handle the vdr:// URL type
 */


#ifndef VDRURL_H
#define VDRURL_H

#include "transceiver.h"

class cMediamvpVdrURL  {
private:
    cMediamvpTransceiver *m_Transceiver;
    int                   transfer_pipe[2];
    char                 *name;

    /* Event so that we can read things */
    struct event         *event;

    /* Callbacks into the library */
    readready_cb          cb;
    void                 *cb_ptr;


    cDevice *GetDevice(const cChannel *Channel, int prio);

public:
    cMediamvpVdrURL();
    ~cMediamvpVdrURL();
    static void Init();
    static void *Open(char *name, int *type, fops_t **fops, readready_cb cb, void *cb_ptr);
    static off_t Seek(void *ptr, off_t offset, int whence);
    static void Close(void *ptr);
    static int Read(void *ptr, unsigned char *buf, size_t buflen);
    static void ReadEvent(int fd, short event, void *arg);
};

#endif
