/*
 *   MediaMVP Plugin
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: transceiver.h,v 1.1 2003/12/11 13:52:04 dom Exp $
 *   $Date: 2003/12/11 13:52:04 $
 *
 *
 *   Transceiver stuff, stolen from streamdev again...
 */

#ifndef VDR_MEDIAMVP_TRANSCEIVER_H
#define VDR_MEDIAMVP_TRANSCEIVER_H

#include <vdr/receiver.h>

#include <vdr/thread.h>
#include <vdr/status.h>

class cRingBufferLinear;
class cRemux;
class cTSRemux;
class cServerConnection;
class cChannel;

class cMediamvpTransceiver: public cReceiver, public cThread {
    friend class cMediamvpVdrURL;
private:
	cDevice *m_Device;
	cRingBufferLinear *m_RingBuffer;
	cTSRemux *m_Remux;
    int       m_Socket;

	bool m_Active;

protected:
	virtual void Activate(bool On);
	virtual void Receive(uchar *Data, int Length);
	virtual void Action(void);

public:
	cMediamvpTransceiver(const cChannel *Channel, int Priority, int Socket, cDevice *Device); 
	virtual ~cMediamvpTransceiver(void);

	bool Attach(void) { return m_Device->AttachReceiver(this); }
	void Detach(void) { cReceiver::Detach(); }

	void Stop(void);
};

#endif // VDR_MEDIAMVP_TRANSCEIVER_H
