#include "setup.h"
#include "server.h"

#include <vdr/menuitems.h>


mvpinit_t  MediamvpSetup = MVPINIT_INITIALISER;







cMediamvpMenuSetupPage::cMediamvpMenuSetupPage(void) 
{

    Add(new cMenuEditIntItem(tr("MediaMVP GUI Port"), &MediamvpSetup.gui_port,0,65535));
    Add(new cMenuEditIntItem(tr("MediaMVP Stream Port"), &MediamvpSetup.stream_port,0,65535));
    Add(new cMenuEditIntItem(tr("MediaMVP dongle.bin version"), &MediamvpSetup.dongle_version,21303,65535));
    Add(new cMenuEditIntItem(tr("Total Screen Width"), &MediamvpSetup.screen_width,480,720));
    Add(new cMenuEditIntItem(tr("Total Screen Depth"), &MediamvpSetup.screen_depth,400,576));
    Add(new cMenuEditIntItem(tr("GUI Screen Width"), &MediamvpSetup.gui_width,480,720));
    Add(new cMenuEditIntItem(tr("GUI Screen Depth"), &MediamvpSetup.gui_depth,400,576));
    SetCurrent(Get(1));
}

cMediamvpMenuSetupPage::~cMediamvpMenuSetupPage()
{
}


void cMediamvpMenuSetupPage::Store(void)
{
    cMediamvpServer::Exit();

    SetupStore("gui_port",MediamvpSetup.gui_port);
    SetupStore("streamport",MediamvpSetup.stream_port);
    SetupStore("dongle_version",MediamvpSetup.dongle_version);
    SetupStore("screen_width",MediamvpSetup.screen_width);
    SetupStore("screen_depth",MediamvpSetup.screen_depth);
    SetupStore("gui_width",MediamvpSetup.gui_width);
    SetupStore("gui_depth",MediamvpSetup.gui_depth);   
    cMediamvpServer::Init();
}


