/*
 *   MediaMVP Server Library
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: url_file.c,v 1.2 2004/01/24 18:47:54 dom Exp $
 *   $Date: 2004/01/24 18:47:54 $
 *
 *
 *   Deals with opening a file and fobbing off playlist detection
 *   to a lower level
 */

#include "libmvp_internal.h"

static void           *file_open(char *name, int *type, fops_t **fops_ptr, readready_cb cb, void *cb_ptr );
static void            file_close(void *ptr);
static off_t           file_seek(void *ptr, off_t offset, int whence);
static int             file_read(void *ptr, unsigned char *buf, size_t buflen);

typedef struct { 
    int            fd;
} file_t;

static fops_t          file_fops = { 
    NULL,
    file_open,
    file_close,
    file_seek,
    file_read
};
          
void urlfile_init()
{
    urlhandler_add("file://",&file_fops);
}


static void *file_open(char *name, int *type, fops_t **fops_ptr, readready_cb cb, void *cb_ptr )
{
    file_t  *file;
    char    *filename;
    void    *ret_ptr;
    char    *ptr;
    int      fd;


    /* This shouldn't happen... */
    if ( strncmp(name,"file://",7) ) {
        return NULL;
    }

    filename = name + 7;

    if ( ( ptr = strrchr(filename,'.') ) != NULL ) {
        if ( strcasecmp(ptr,".mp3") == 0 ) {
            *type = MEDIA_MP3;
        } else if ( strcasecmp(ptr,".mpeg") == 0 || strcasecmp(ptr,".vdr") == 0 ||
                    strcasecmp(ptr,".mpg") == 0 || strcasecmp(ptr,".nvu") == 0 ) {
            *type = MEDIA_MPEG;
        }
    } else {
        /* Try and guess the filetype */
        *type = file_get_type(filename);
    }

    if ( *type > 0 ) {
        if ( (fd = open(filename,O_RDONLY) ) < 0 ) {
            return NULL;
        }
        file = calloc(1,sizeof(*file));
        file->fd = fd;

        return file;
    }

    return NULL;   
}
      
static void file_close(void *ptr)
{
    file_t   *file = ptr;
    close(file->fd);
    file->fd = -1;
    free(file);
}

static off_t file_seek(void *ptr, off_t off, int whence)
{
    file_t *file = ptr;

    return lseek(file->fd,off,whence);
}

static int file_read(void *ptr, unsigned char *buf, size_t buflen)
{
    file_t  *file = ptr;

    return read(file->fd,buf,buflen);
}

