/*
 *   MediaMVP Server
 *
 *   (C) 2003 Dominic morris
 *
 *   $Id: gui.h,v 1.2 2004/01/14 20:40:24 dom Exp $
 *   $Date: 2004/01/14 20:40:24 $
 *
 *
 *   RFB definitions
 */

#ifndef __GUI_H__
#define __GUI_H__

#include "keys.h"
#include <zlib.h>

#define RFB_MAJOR   3
#define RFB_MINOR   3

enum {
  VNC_DEALLOCATED,
  VNC_VERSION,
  VNC_VERSION2,
  VNC_AUTH,
  VNC_AUTH2,
  VNC_INIT,
  VNC_INIT2,
  VNC_RUNNING
};


/* send message types */
#define SEND_NONE          0
#define SEND_SCREEN        1
#define SEND_PING          2

#define RFB_WIDTH          720
#define RFB_DEPTH          576

/* RFB authentication constants. */

#define RFB_AUTH_FAILED      0
#define RFB_AUTH_NONE        1
#define RFB_AUTH_VNC         2

#define RFB_VNC_AUTH_OK      0
#define RFB_VNC_AUTH_FAILED  1
#define RFB_VNC_AUTH_TOOMANY 2

/* RFB message types. */

/* From server to client: */
#define RFB_FB_UPDATE            0
#define RFB_SET_COLORMAP_ENTRIES 1
#define RFB_BELL                 2
#define RFB_SERVER_CUT_TEXT      3

/* HP extensions here */
#define RFB_RDC                  4

/* From client to server. */
#define RFB_SET_PIXEL_FORMAT     0
#define RFB_FIX_COLORMAP_ENTRIES 1
#define RFB_SET_ENCODINGS        2
#define RFB_FB_UPDATE_REQ        3
#define RFB_KEY_EVENT            4
#define RFB_POINTER_EVENT        5
#define RFB_CLIENT_CUT_TEXT      6
#define RFB_RDC_ACK            7

/* HP extensions here */
#define RFB_PING                 8

/* Encoding types. */
#define RFB_ENC_RAW      0
#define RFB_ENC_COPYRECT 1
#define RFB_ENC_RRE      2
#define RFB_ENC_CORRE    3
#define RFB_ENC_HEXTILE  4

/* Some stuff for gui */

typedef struct _mvprfbmsg {
    int    len;
    char   msg[50];
} mvprfbmsg_t;
#define MESSAGE(name,len,vals...) mvprfbmsg_t  name = { len,  {vals}  }


MESSAGE(rfb_ping, 2,  0x08,0x00);



/* Special case this one */
MESSAGE(rfb_media_play,      10,  RFB_RDC, RDC_PLAY, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);

MESSAGE(rfb_media_pause,     10,  RFB_RDC, RDC_PAUSE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
MESSAGE(rfb_media_stop,      10,  RFB_RDC, RDC_STOP, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
MESSAGE(rfb_media_rewind,    10,  RFB_RDC, RDC_REWIND, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
MESSAGE(rfb_media_forward,   10,  RFB_RDC, RDC_FORWARD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
MESSAGE(rfb_media_volup,     10,  RFB_RDC, RDC_VOLUP, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
MESSAGE(rfb_media_voldown,   10,  RFB_RDC, RDC_VOLDOWN, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
MESSAGE(rfb_media_menu,      10,  RFB_RDC, RDC_MENU, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00);
MESSAGE(rfb_media_mute,      10,  RFB_RDC, RDC_MUTE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
MESSAGE(rfb_media_settings,  10,  RFB_RDC, RDC_SETTINGS, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00);
MESSAGE(rfb_media_displayoff,12,  RFB_RDC, RDC_MENU, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x01, 0x00);
MESSAGE(rfb_media_displayon, 12,  RFB_RDC, RDC_MENU, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00);


/* Messages for 21365 and above - yup, they changed the fscking protocol */
MESSAGE(rfb_media_play_22012,      34,  RFB_RDC, RDC_PLAY, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00);

MESSAGE(rfb_media_pause_22012,     34,  RFB_RDC, RDC_PAUSE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00);

MESSAGE(rfb_media_stop_22012,      34,  RFB_RDC, RDC_STOP, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00);

MESSAGE(rfb_media_rewind_22012,    34,  RFB_RDC, RDC_REWIND, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00);

MESSAGE(rfb_media_forward_22012,   34,  RFB_RDC, RDC_FORWARD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00);

MESSAGE(rfb_media_volup_22012,     34,  RFB_RDC, RDC_VOLUP, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00);

MESSAGE(rfb_media_voldown_22012,   34,  RFB_RDC, RDC_VOLDOWN, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00);

MESSAGE(rfb_media_menu_22012,      34,  RFB_RDC, RDC_MENU, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00);

MESSAGE(rfb_media_mute_22012,      34,  RFB_RDC, RDC_MUTE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00);

MESSAGE(rfb_media_settings_22012,  34,  RFB_RDC, RDC_SETTINGS, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00);

MESSAGE(rfb_media_displayoff_22012,      36,  RFB_RDC, RDC_MENU, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x01, 0x00);

MESSAGE(rfb_media_displayon_22012,      36,  RFB_RDC, RDC_MENU, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00);

#endif
