/*
 *   MediaMVP Server
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: menu.h,v 1.1 2003/12/11 13:52:03 dom Exp $
 *   $Date: 2003/12/11 13:52:03 $
 *
 *
 *   Details of the menuapp
 */



#ifndef MENU_H
#define MENU_H

#include "libmvp.h"

typedef struct _menu    menu_t;


#define   MENU_NUMBERS   1
#define   MENUOPT_NONE      0
#define   MENUOPT_INT       1



extern menu_t         *new_menu(dongle_t *dongle, render_t *render, void *iapp,menu_t *parent,void *param, int flags);
extern void            delete_menu_tree(menu_t *menu);
extern void            delete_menu(menu_t *menu);
extern void            menu_set_title(menu_t *menu, const char *text);
extern void            menu_add_option(menu_t *menu, const char *name, 
                                       int (callback_func)(menu_t *menu,void *param, int sel),
                                       int type, int num_options, char const **options,void *value_ptr);

extern void            menu_add(menu_t *menu, const char *name, int (*callback_func)(menu_t *menu,void *param, int sel));
extern void            menu_display(menu_t *menu);
extern void            menu_set_param_clearup(menu_t *menu, void (*clearup)(void *ptr));
extern void            menu_set_colour_actions(menu_t *menu,
                                               const char   *red,
                                               const char   *green,
                                               const char   *yellow,
                                               const char   *blue,
                                               int   (*func)(menu_t *menu,void *param, int key, int sel));

extern menu_t        *menu_parent(menu_t *menu);
extern menu_t        *menu_child(menu_t *menu);


#endif
