#include "server.h"
#include "setup.h"
#include "libmvp.h"
#include "app.h"

#include <vdr/tools.h>


cMediamvpServer *cMediamvpServer::m_Instance = NULL;


cMediamvpServer::cMediamvpServer(void)
{
    m_Active = false;
}


cMediamvpServer::~cMediamvpServer()
{
    if ( m_Active ) {
        Stop();
    }
}


void cMediamvpServer::Init(void)
{
    if ( m_Instance == NULL ) {
        app_init(&MediamvpSetup);
        if ( mediamvp_server_init(&MediamvpSetup) == 0 ) {
            m_Instance = new cMediamvpServer;
            m_Instance->Start();
            m_Instance->m_Active = true;
        }
    }
}



void cMediamvpServer::Exit(void)
{
    if ( m_Instance != NULL ) {
        m_Instance->Stop();
        DELETENULL(m_Instance);
    }
}

void cMediamvpServer::Stop(void)
{
    /* Call into the C code and stop all sockets */
    m_Active = false;
    mediamvp_server_stop();
    Cancel(3);
}


void cMediamvpServer::Action(void)
{
    /* Wait till everything is setup for us */
    while ( m_Active == false) {
        sleep(1);
    }
    event_dispatch();

}


