/*
 *   MediaMVP Server
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: dongle.c,v 1.1.1.1 2003/12/04 00:10:13 dom Exp $
 *   $Date: 2003/12/04 00:10:13 $
 *
 *
 *   Dongle registration - maintains a list of dongles with their subcomponents 
 */


#include "mvp_internal.h"


static int        dongles_num   = 0;
static dongle_t  *dongles       = NULL;



dongle_t *dongle_return(char *address)
{
    dongle_t  *dongle;
    int        i;
    int        first = -1;

    for ( i = 0; i < dongles_num; i++ ) {
        if ( strcmp(dongles[i].address,address) == 0 && dongles[i].inuse ) {
            return &dongles[i];
        }
        if ( dongles[i].inuse == FALSE ) {
            first = i;
        }
    }

    if ( first != -1 ) {
        dongle=&dongles[first];
    } else {
        i = dongles_num++;
        dongles = realloc(dongles,dongles_num * sizeof(dongle_t));
        dongle = &dongles[i];
    }


    strcpy(dongle->address,address);
    dongle->inuse = TRUE;
    dongle->gui = NULL;
    dongle->stream = NULL;

    /* Reset to defaults - we ask client for details of these settings */
    dongle->tvmode = 0;
    dongle->videooutput = 0;
    dongle->flickermode = 0;
    dongle->aspectratio = 0;

    return dongle;
}


void dongle_close(dongle_t *dongle)
{
    if ( dongle->gui ) {
        delete_gui(dongle->gui);
    }

    if ( dongle->stream ) {
        delete_stream(dongle->stream);
    }
    dongle->stream = NULL;
    dongle->gui    = NULL;
    /* Close gui/stream here */
    dongle->inuse = FALSE;
}

void dongle_closeall()
{
    int          i;

    for ( i = 0; i < dongles_num; i++ ) {
        dongle_close(&dongles[i]);
    }
}


/*
 * Local Variables:
 *  indent-tabs-mode:nil
 *  require-final-newline:t
 *  c-basic-offset: 4
 * End:
 */
