/*
 *   MediaMVP Server
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: msgs.h,v 1.10 2003/11/27 20:25:13 dom Exp $
 *   $Date: 2003/11/27 20:25:13 $
 *
 *
 *   Definitinons of various set rfb messages
 */


/* Messages */


#ifndef __MSGS_H__
#define __MSGS_H__


#ifdef NEED_MSGS
#define MESSAGE(name,len,vals...) mvprfbmsg_t  name = { len,  {vals}  }
#else
#define MESSAGE(name,len,vals...) extern mvprfbmsg_t  name
#endif

/* Some sub-commands of RFB_MEDIA and RFB_MEDIA_ACK - these are used
 by the ack functions
*/
#define RDC_PLAY            0x01
#define RDC_PAUSE           0x02
#define RDC_STOP            0x03
#define RDC_REWIND          0x04
#define RDC_FORWARD         0x05
#define RDC_VOLUP           0x06
#define RDC_VOLDOWN         0x07
#define RDC_MENU            0x08
#define RDC_MUTE            0x09
#define RDC_SETTINGS        0x0a

#define RDC_SETTINGS_GET    0x00
#define RDC_SETTINGS_TEST   0x01
#define RDC_SETTINGS_CANCEL 0x02
#define RDC_SETTINGS_SAVE   0x03


struct _mvprfbmsg {
    int    len;
    char   msg[24];
};


MESSAGE(rfb_ping, 2,  0x08,0x00);

MESSAGE(rfb_display_off, 2,      0x01, 0x00 );
MESSAGE(rfb_display_on,  2,      0x00, 0x00 );


/* Special case this one */
MESSAGE(rfb_media_play,      10,  RFB_RDC, RDC_PLAY, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);

MESSAGE(rfb_media_pause,     10,  RFB_RDC, RDC_PAUSE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
MESSAGE(rfb_media_stop,      10,  RFB_RDC, RDC_STOP, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
MESSAGE(rfb_media_rewind,    10,  RFB_RDC, RDC_REWIND, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
MESSAGE(rfb_media_forward,   10,  RFB_RDC, RDC_FORWARD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
MESSAGE(rfb_media_volup,     10,  RFB_RDC, RDC_VOLUP, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
MESSAGE(rfb_media_voldown,   10,  RFB_RDC, RDC_VOLDOWN, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
MESSAGE(rfb_media_menu,      10,  RFB_RDC, RDC_MENU, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00);
MESSAGE(rfb_media_mute,      10,  RFB_RDC, RDC_MUTE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
MESSAGE(rfb_media_settings,  10,  RFB_RDC, RDC_SETTINGS, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00);



#endif
