/*
 *   MediaMVP Server
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: msgs.h,v 1.4 2003/11/19 23:48:13 dom Exp $
 *   $Date: 2003/11/19 23:48:13 $
 *
 *
 *   Definitinons of various set rfb messages
 */


/* Messages */


#ifndef __MSGS_H__
#define __MSGS_H__


#ifdef NEED_MSGS
#define MESSAGE(name,len,vals...) mvprfbmsg_t  name = { len,  {vals}  }
#else
#define MESSAGE(name,len,vals...) extern mvprfbmsg_t  name
#endif

struct _mvprfbmsg {
    int    len;
    char   msg[24];
};


MESSAGE(rfb_ping, 2,  0x08,0x00);

MESSAGE(rfb_display_off, 2,      0x01, 0x00 );
MESSAGE(rfb_display_on,  2,      0x00, 0x00 );


/* Special case this one */
MESSAGE(rfb_media_filename,  10,  0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);

MESSAGE(rfb_media_pause,     10,  0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
MESSAGE(rfb_media_stop,      10,  0x04, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
MESSAGE(rfb_media_rewind,    10,  0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
MESSAGE(rfb_media_forward,   10,  0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
MESSAGE(rfb_media_voldown,   10,  0x04, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
MESSAGE(rfb_media_volup,     10,  0x04, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
MESSAGE(rfb_media_mpeg,      10,  0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00);
MESSAGE(rfb_media_mute,      10,  0x04, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
MESSAGE(rfb_media_settings,  10,  0x04, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00);



#endif
