/*
 *   MediaMVP Server
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: transceiver.c,v 1.1 2003/12/11 13:52:04 dom Exp $
 *   $Date: 2003/12/11 13:52:04 $
 *
 *   Transceiver stuff - blatantly stolen from streamdev then changed
 *   a bit..
 */





#include "transceiver.h"
#include "remux/ts2ps.h"
#include "remux/ts2es.h"
#include "setup.h"

#include <vdr/ringbuffer.h>

#include <sys/types.h>
#include <unistd.h>

#include "libmvp.h"

#define VIDEOBUFSIZE MEGABYTE(1)

/* Disable logging if BUFCOUNT buffer overflows occur within BUFOVERTIME
   milliseconds. Enable logging again if there is no error within BUFOVERTIME
   milliseconds. */
#define BUFOVERTIME  5000
#define BUFOVERCOUNT 100

cMediamvpTransceiver::cMediamvpTransceiver(const cChannel *Channel, int Priority, int Socket, cDevice *Device) :
		cReceiver(Channel->Ca(), Priority, 7, Channel->Vpid(), Channel->Ppid(),
				Channel->Apid1(), Channel->Apid2(), Channel->Dpid1(), Channel->Dpid2(), 
				Channel->Tpid()) {
	m_Active = false;
	m_Socket = Socket;
	m_Remux = NULL;
	m_Device = Device;

	m_RingBuffer = new cRingBufferLinear(VIDEOBUFSIZE, TS_SIZE * 2, true);

    /* Select the correct Muxing depending on whether it's video or not */
    if ( Channel->Vpid() == 0 || Channel->Vpid() == 1 || Channel->Vpid() == 0x1FFF ) {
        m_Remux = new cTS2ESRemux(Channel->Apid1());
    } else {
		m_Remux = new cTS2PSRemux(Channel->Vpid(), Channel->Apid1(), 0, 0, 0, 1);
    }
	m_Device->SwitchChannel(Channel, false);
	Attach();
}

cMediamvpTransceiver::~cMediamvpTransceiver(void) 
{
	Detach();
	if (m_Remux) delete m_Remux;
	delete m_RingBuffer;
}

void cMediamvpTransceiver::Activate(bool On) 
{
	if (On)
		Start();
	else if (m_Active)
		Stop();
}

void cMediamvpTransceiver::Stop(void) 
{
	if (m_Active) {
		m_Active = false;
		Cancel(3);
	}
}

void cMediamvpTransceiver::Receive(uchar *Data, int Length) 
{
	static time_t firsterr = 0;
	static int errcnt = 0;
	static bool showerr = true;

	if (m_Active) {
		int p = m_RingBuffer->Put(Data, Length);
		if (p != Length) {
			++errcnt;
			if (showerr) {
				if (firsterr == 0)
					firsterr = time_ms();
				else if (firsterr + BUFOVERTIME > time_ms() && errcnt > BUFOVERCOUNT) {
					esyslog("ERROR: too many buffer overflows, logging stopped");
					showerr = false;
					firsterr = time_ms();
				}
			} else if (firsterr + BUFOVERTIME < time_ms()) {
				showerr = true;
				firsterr = 0;
				errcnt = 0;
			}

			if (showerr)
				esyslog("ERROR: ring buffer overflow (%d bytes dropped)", Length - p);
			else
				firsterr = time_ms();
		}
	}
}

void cMediamvpTransceiver::Action(void) 
{
	int max = 0;


	isyslog("Mediamvp: Transceiver thread started (pid=%d)", getpid());


	m_Active = true;

	while (m_Active) {
		int recvd;
		const uchar *block = m_RingBuffer->Get(recvd);

		if (block && recvd > 0) {
			const uchar *sendBlock;
			int bytes = 0;
			int taken = recvd;

            sendBlock = m_Remux->Process(block, taken, bytes);

			m_RingBuffer->Del(taken);

			if (bytes > max)
				max = bytes;

            write(m_Socket,sendBlock,bytes);

		} else
			usleep(1);
	}

	
	isyslog("Mediamvp: Transceiver thread ended");
}

