/*
 *   MediaMVP Server Library
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: mvp.c,v 1.7 2003/12/13 13:44:35 dom Exp $
 *   $Date: 2003/12/13 13:44:35 $
 *
 *
 *   More wrapping up of the C code, this effectively a version of
 *   the main code.
 *
 */

#include "libmvp_internal.h"


mvpinit_t         initparams = MVPINIT_INITIALISER;


int mediamvp_server_init(mvpinit_t *init)
{

    initparams = *init;

    if ( initparams.logfile == NULL ) {
        initparams.logfile = stderr;
    }
    Dprintf(INFO,"MediaMVP server %s starting\n",SERVER_VERSION);

    if ( initparams.main_interfaceip == -1 ) {
         char hostbuf[1024];
         if ( gethostname(hostbuf,sizeof(hostbuf)-1) == -1 ) {
                 return -1;
         }
         if ( ( initparams.main_interfaceip = host_resolve(hostbuf) ) == - 1 ) {
            return -1;
         }
     }



    event_init();
    udp_init();
    gui_init();
    stream_init();
    urlhandler_init();

    return 0;
}


void mediamvp_server_stop()
{
    udp_exit();
    gui_exit();
    stream_exit();
    dongle_closeall();
}

