/*
 *   MediaMVP Server
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: app.h,v 1.4 2003/12/04 21:03:36 dom Exp $
 *   $Date: 2003/12/04 21:03:36 $
 *
 *
 *   Implements the skeleton application
 * 
 *   This abstracts part of the old interface from gui.c into a separate file for libraryification
 */

#ifndef APP_H
#define APP_H


#ifdef __cplusplus
extern "C" {
#endif

typedef struct _app app_t;


#include "menuapp.h"


#define  REGISTER_MENU  1
#define  REGISTER_MEDIA 2


extern void       app_config();
extern void       app_init(mvpinit_t *);
extern void       app_register_keys(app_t *app,int type, 
                                    int (*key_func)(void *param,int keycode), void *param);
extern void       app_register_ack(app_t *app, int type,
                                   int    (*ack_func)(int acktype, void *param, unsigned char *buf, int len), 
                                   void  *param);


#ifdef __cplusplus
}
#endif



#endif /* APP_H */
