;	title	'Apple II, II+, or //e overlay for MEX'
;	This overlay file is for the Apple ][, ][+, or //e
;	computers. At present it supports either the Microsoft
;	Softcard (not Softcard II or premium Softcard //e), 
;	or the PCPI Appli-Card also known as the MicroPro
;	Star-Card. And supports the Serial Cards listed below.
;
;	As time allows I plan to write the routines for the 
;	Microsoft Softcard II into this overlay file. Also
;	I plan to add the Micromodem //e into this overlay.
;
;				Douglass Laing (KA6BXT)
;				Laing Electronics Inc.
;				GFRN CBBS (714) 534-1547
;
;	SERIAL CARDS NOW SUPPORTED:
;	===========================
;
;	A) CCS 7710 serial interface card
;
;	B) CCS 7711 Super-Serial card, or Apple Super-Serial card
;
;	C) DON SABA'S *RAY KLIEN Z80 SIO CARD* (8/25/85).
;
;       D) Klein-Baker SIO Card (5/30/12)
;           NOTE: SABA Sections modified for Klein/Baker SIO card
;                 which uses a 1.84320 MHz clock
;
;--------------------------------------------------------------------
;
; 04/25/85 - Created this overlay file
;            to work with MEX			- Doug Laing
;
;--------------------------------------------------------------------
;
;
;
;	Credits:
;	========
;
;	MXO-GB10.ASM for the Mexified ideas Ron Fowler
;
;	
;	M7DM## family of overlay files by Irv Hoff
;
;	M7##AP.ASM for many of the basic routines
;			Richard Berg & Doug Laing
;
;
;	Bug Reports:
;	============
;
;	Any problems, additions, or ideas for this overlay
;	Laing Electronics Inc (CBBS  714 534-1547)
;			      (VOICE 714 534-4216)	
;
;
					;
					;
REV	EQU	10			;V 1.0
					;
					;
					;
					; MEX service processor stuff
					;
MEX	EQU	0D00H			;address of the service processor
INMDM	EQU	255			;get char from port to A, CY=no more in 100 ms
TIMER	EQU	254			;delay 100ms * reg B
TMDINP	EQU	253			;B=# secs to wait for char, cy=no char
CHEKCC	EQU	252			;check for ^C from KBD, Z=present
SNDRDY	EQU	251			;test for modem-send ready
RCVRDY	EQU	250			;test for modem-receive ready
SNDCHR	EQU	249			;send a character to the modem (after sndrdy)
RCVCHR	EQU	248			;recv a char from modem (after rcvrdy)
LOOKUP	EQU	247			;table search: see CMDTBL comments for info
PARSFN	EQU	246			;parse filename from input stream
BDPARS	EQU	245			;parse baud-rate from input stream
SBLANK	EQU	244			;scan input stream to next non-blank
EVALA	EQU	243			;evaluate numeric from input stream
LKAHED	EQU	242			;get nxt char w/o removing from input
GNC	EQU	241			;get char from input, cy=1 if none
ILP	EQU	240			;inline print
DECOUT	EQU	239			;decimal output
PRBAUD	EQU	238			;print baud rate
					;
PRINT	EQU	9			;BDOS/MEX print-string function call
					;
TAB	EQU	9			;
					;
BELL:	EQU	07H			;bell	
CR:	EQU	0DH			;carriage return
ESC:	EQU	1BH			;escape
LF:	EQU	0AH			;linefeed
					;
YES:	EQU	0FFH			;
NO:	EQU	0			;
					;
;....................................................................
					;
CCS7710: 	EQU	no		;YES for CCS 7710
SSC:		EQU	no		;YES for Super Serial Card
					;or CCS7711 Super Serial.
SABA:		EQU	yes		;YES for Don Saba's SIO Board
					;
;....................................................................
					;
MICROSOFT:	EQU	NO		;YES if Microsoft type CP/M card
APPLICARD:	EQU	YES		;YES if Appli-Card or Star-Card
					;
;....................................................................
;
;               ( basic setup for microsoft z-80 softcard)
;
;               NOTE: NOT FOR PREMIUM SOFTCARD //E, OR SOFTCARD II
;
					;
	IF 	MICROSOFT		;if Microsoft Softcard
					;
	IF	CCS7710			;if CCS7710
					;
MODDATP:	EQU	0E0AFH		;data port of CCS 7710
MODCTL1:	EQU	0E0AEH		;status port of CCS 7710
		ENDIF			;endif CCS7710
					;
					;	
					;
	IF	SSC			;if Super Serial
					;
MODDATP:	EQU	0E0A8H		;data port of Apple Super Serial Card 
MODCTL1:	EQU	0E0A9H		;modem status port of Super Serial Card
MODRCVB:	EQU	08H     	;bit to test for received data
MODRCVR:	EQU	08H     	;modem receive ready
MODSNDB:	EQU	10H		;bit to test for ready to send
MODSNDR:	EQU	10H		;modem send ready bit
		ENDIF			;END Super Serial
					;
		ENDIF			;END Microsoft
					;
					;
					;
;....................................................................
;
;	(basic setup for PCPI Appli-Card or MicroPro Star-Card)
;		NOTE - also for Franklin CP/M card.
;
					;
	IF	APPLICARD		;if Appli-Card or Star-Card
				
	IF 	SABA
CPORT		EQU	80H		;Aplicard CTC baud rate port
					; USE 80H FOR PRIMARY SERIAL PORT
					; USE 81H FOR SECONDARY SERIAL PORT
PORT:		EQU	0FCH		;Aplicard serial output port
					; USE FCH FOR PRIMARY SERIAL PORT
					; USE FEH FOR SECONDARY SERIAL PORT
MODCTL1:	EQU	PORT+1		;Modem control port
MODDATP:	EQU	PORT		;Modem data port
MODCTL2:	EQU	PORT+1		;Modem control port
MODRCVB:	EQU	01H		;Your bit to test for receive
MODRCVR:	EQU	01H		;Your value when receive ready
MODSNDB:	EQU	04H		;Your bit to test for send
MODSNDR:	EQU	04H		;Your value when send ready	
	ENDIF ;SABA
; 
	IF	CCS7710			;if CCS7710
MODDATP:	EQU	0C0A1H		;data port of CCS 7710
MODCTL1:	EQU	0C0A0H		;status port of CCS 7710
		ENDIF			;END CCS7710
;
	IF	SSC			;if Super Serial
MODDATP:	EQU	0C0A8H		;data port of Apple Super Serial Card 
MODCTL1:	EQU	0C0A9H		;modem status port of Super Serial Card
MODRCVB:	EQU	08H     	;bit to test for received data
MODRCVR:	EQU	08H     	;modem receive ready
MODSNDB:	EQU	10H		;bit to test for ready to send
MODSNDR:	EQU	10H		;modem send ready bit
		ENDIF			;END Super Serial
		ENDIF			;END Appli-Card or Star-Card
					;
;....................................................................
;
; Locations used by the Appli-Card or Star-Card to read or write from
; 6502 memory. Used by the PEEK and POKE modules.
;
		IF	APPLICARD	;if Appli-Card or Star-Card
					;
RDBYTE		EQU	0FFE0H		;READ  1 BYTE  FROM APPLE (A  = BYTE)
WRBYTE		EQU	0FFE3H		;WRITE 1 BYTE  TO APPLE   (C  = BYTE)
REWORD		EQU	0FFE6H		;READ  2 BYTES FROM APPLE (DE = WORD)
WRWORD		EQU	0FFE9H		;WRITE 2 BYTES FROM APPLE (DE = WORD)
RENBYTS		EQU	0FFECH		;READ  N BYTES (DE = COUNT, HL = BUFFER)
WRNBYTS		EQU	0FFEFH		;WRITE N BYTES (DE = COUNT, HL = BUFFER)
PEEK1BYTE	EQU	6		;COMMAND
POKE1BYTE	EQU	7		;COMMAND
					; 
		ENDIF			;END Appli-Card or Star-Card
					;
					;
					;
;....................................................................
;
; Apple status bit equates for CCS7710
;
					;
	IF	CCS7710			;if CCS7710
					;
MODSNDB:	EQU	02H		;bit to test for send
MODSNDR:	EQU	02H		;value when ready
MODRCVB:	EQU	01H		;bit to test for receive
MODRCVR:	EQU	01H		;value when ready
		ENDIF			;END CCS7710
					;		
					;
;....................................................................
					;
	ORG	100H			;	
					;
;
; Change the clock speed to suit your system
;
					;
	DS	3			;(for  "JMP   START" instruction)
					;
	DB	NO			;yes=PMMI S-100 Modem			103H
	DB	NO			;yes=HAYES Smartmodem, no=non-PMMI	104H
	DB	'T'			;T=touch, P=pulse (Smartmodem-only)	105H
CLOCK:	DB	60			;clock speed in MHz x10, 25.5 MHz max.	106H
					;20=2 MHh, 37=3.68 MHz, 40=4 MHz, etc.
MSPEED:	DB	5			;0=110 1=300 2=450 3=600 4=710 5=1200	107H
					;6=2400 7=4800 8=9600 9=19200 default
IF SABA
IMSPEED	EQU	5			; DEFAULT MSPEED
ENDIF ;SABA

BYTDLY:	DB	5			;0=0 delay  1=10ms  5=50 ms - 9=90 ms	108H
					;default time to send character in ter-
					;minal mode file transfer for slow BBS.
CRDLY:	DB	5			;0=0 delay 1=100 ms 5=500 ms - 9=900 ms 109H
					;default time for extra wait after CRLF
					;in terminal mode file transfer
COLUMS:	DB	5			;number of DIR columns shown		10AH
SETFLG:	DB	YES			;yes=user-added Setup routine		10BH
SCRTST:	DB	YES			;Cursor control routine 		10CH
	DB	YES			;yes=resend a record after any non-ACK	10DH
					;no=resend a record after a valid-NAK
BAKFLG:	DB	YES			;yes=change any file same name to .BAK	10EH
CRCDFL:	DB	NO			;yes=default to CRC checking		10FH
TOGCRC:	DB	YES			;yes=allow toggling of CRC to Checksum	110H
CVTBS:	DB	NO			;yes=convert backspace to rub		111H
TOGLBK:	DB	YES			;yes=allow toggling of bksp to rub	112H
ADDLF:	DB	NO			;no=no LF after CR to send file in	113H
					;terminal mode (added by remote echo)
TOGLF:	DB	YES			;yes=allow toggling of LF after CR	114H
	DB	YES			;yes=allow transmission of logon	115H
					;write logon sequence at location LOGON
SAVCCP:	DB	YES			;yes=do not overwrite CCP		116H
	DB	NO			;yes=local command if EXTCHR precedes	117H
					;no=external command if EXTCHR precedes
	DB	YES			;yes=allow toggling of LOCONEXTCHR	118H
LSTTST:	DB	YES			;yes=printer available on printer port	119H
XOFTST:	DB	NO			;yes=checks for XOFF from remote while	11AH
					;sending a file in terminal mode
XONWT:	DB	NO			;yes=wait for XON after CR while	11BH
					;sending a file in terminal mode
TOGXOF:	DB	YES			;yes=allow toggling of XOFF checking	11CH
IGNCTL:	DB	NO			;yes=CTL-chars above ^M not displayed	11DH
EXTRA1:	DB	0			;for future expansion			11EH
EXITCHR	DB	'E'-40H			;^E = Exit to main menu			11FH
BRKCHR:	DB	'@'-40H			;^@ = Send 300 ms. break tone		120H
NOCONN:	DB	'N'-40H			;^N = Disconnect from the phone line	121H
LOGCHR:	DB	'L'-40H			;^L = Send logon			122H
LSTCHR:	DB	'P'-40H			;^P = Toggle printer			123H
UNSAVE:	DB	'R'-40H			;^R = Close input text buffer		124H
TRNCHR:	DB	'T'-40H			;^T = Transmit file to remote		125H
SAVCHR:	DB	'Y'-40H			;^Y = Open input text buffer		126H
EXTCHR:	DB	'^'-40H			;^^ = Send next character		127H
	DS	2			;unused by MEX				128H
;
;....................................................................
					;
		IF	MICROSOFT 	;if Microsoft Softcard
					;
IN$MODCTL1:	LDA	MODCTL1 ! RET	;in modem control port	     		12AH
		DS	6		;
OUT$MODDATP:	STA	MODDATP ! RET	;out modem data port			134H
		DS	6		;
IN$MODDATP:	LDA	MODDATP ! RET	;in modem data port			13EH
		DS	6		;spares if needed
					;
		ENDIF			;END Microsoft
					;
;....................................................................
					;
		IF	APPLICARD AND NOT SABA ;Appli-Card or Star-Card
					;
IN$MODCTL1:	PUSH	D		;					12AH
		LXI	D,MODCTL1	;in modem control port addr 
		CALL	PEEK		;peek from 6502 memory !
		POP	D		;	
		RET			;
		DS	1		;
					;
					;	
OUT$MODDATP:	PUSH	D		;					134H
		LXI	D,MODDATP	;out modem data port addr
		CALL	POKE		;poke into 6502 memory !
		POP	D		;
		RET			;
		DS	1		;
					;
					;
IN$MODDATP:	PUSH	D		;					13EH
		LXI	D,MODDATP	;in modem data port addr
		CALL	PEEK		;peek from 6502 memory !
		POP	D		;
		RET			;
		DS	1		;	
					;
		ENDIF			;END Appli-Card or Star-Card
					;


		IF	APPLICARD AND SABA ;RAY KLEIN SIO CARD
					;
IN$MODCTL1:	IN MODCTL1		; In modem control port		12AH
		RET
	  	DB	0,0,0,0,0,0,0	; Spares if needed
					;	
OUT$MODDATP:    OUT MODDATP 		; Out modem data port		134H			13DH
	        RET
	        DB	0,0,0,0,0,0,0	; Spares if needed
					;
IN$MODDATP:	IN MODDATP		;in modem data port		13EH
	        RET
	  	DB	0,0,0,0,0,0,0	; 
					;
		ENDIF			;END Appli-Card AND SABA


;....................................................................
					;
ANI$MODRCVB:	ANI	MODRCVB ! RET	;bit to test for receive ready		148H
CPI$MODRCVR:	CPI	MODRCVR ! RET	;value of rcv. bit when ready		14BH
ANI$MODSNDB:	ANI	MODSNDB ! RET	;bit to test for send ready		14EH
CPI$MODSNDR:	CPI	MODSNDR ! RET	;value of send bit when ready		151H
					;
					;	
	DS	14			;					156H
					;
					;
	DS	3			;DIALV: not done here (maybe MXO-SM)	162H
DISCV:	JMP	DISCON			;disconnect
GOODBV:	JMP	GOODBYE			;					168H
INMODV:	JMP	INITMOD			;go to user written routine		16BH
	RET ! NOP ! NOP			;NEWBDV					16EH
	RET ! NOP ! NOP			;NOPARV					171H
	RET ! NOP ! NOP			;PARITV					174H
SETUPV:	JMP	SETUPR			;					177H
	DS	3			;not used by MEX			17AH
VERSNV:	JMP	SYSVER			;					17DH
BREAKV:	JMP	SENDBRK			;					180H
					;
;
; Do not change the following six lines (they provide access to routines
; in MEX that are present to support MDM7 overlays -- they will likely
; be gone by MEX v2.0).
;
					;
ILPRTV:	DS	3			;					183H
INBUFV	DS	3			;					186H
ILCMPV:	DS	3			;					189H
INMDMV:	DS	3			;					18CH
	DS	3			;					18FH
TIMERV	DS	3			;					192H
					;
;
; Routine to clear to end of screen.  If using CLREOS and CLRSCRN, set
; SCRTEST to YES at 010AH (above).
;
					;
CLREOS:	LXI	D,EOSMSG		;					195H
	MVI	C,PRINT			;
	CALL	MEX			;
	RET				;
					;
CLS:	LXI	D,CLSMSG		;					19EH
	MVI	C,PRINT			;
	CALL	MEX			;	
	RET				;
					;					1A7H
					;
					; end of fixed area
					;
					;
;....................................................................
					;
		IF	APPLICARD	;if Appli-Card or Star-Card
					;
SYSVER:	MVI 	C,ILP			;in-line print
	CALL	MEX			;
	DB	'Version for Apple ][,' ;
	DB	' ][+, or //e',CR,LF	;
	DB	'with Appli-Card or '	;
	DB	'Star-Card',CR,LF	;
					;
	IF	CCS7710			;if CCS7710
	DB	'CCS 7710 Serial card'	;
	DB	CR,LF			;
	ENDIF				;END CCS7710
					;
	IF	SSC			;if Super Serial
	DB	'CCS 7711 Super Serial,';
	DB	' or Apple Super-Serial';
	DB	CR,LF			;
	ENDIF				;END Super Serial

	IF	SABA			;Ray Klein Z80 SIO Card
	DB	'Ray Klein Z80 SIO card'
	DB	CR,LF
	ENDIF				;END SABA
					;	
	DB	'REV 1.0 for MEX',CR,LF ;
	DB	CR,LF,0			;	
	RET				;
					;
	ENDIF				;END Appli-Card or Star-Card
					;
;....................................................................
					;
	IF	MICROSOFT		;if Microsoft Softcard
					;
SYSVER:	MVI	C,ILP			;in-line print
	CALL	MEX			;
	DB	'Version for Apple ][,'	;
	DB	' ][+, or //e',CR,LF	;
	DB	'with Microsoft '	;
	DB	'Softcard',CR,LF	;
					;
	IF	CCS7710			;if CCS7710
	DB	'CCS 7710 Serial card'	;
	DB	CR,LF			;
	ENDIF				;END CCS7710
					;
	IF	SSC			;if Super Serial
	DB	'CCS 7711 Super Serial' ;
	DB	', or Apple Super'	;
	DB	'-Serial',CR,LF		;
	ENDIF				;END Super Serial
					;
	DB	'REV 1.0 for'		;
	DB	' MEX',CR,LF 		;
	DB	CR,LF,0			;
	RET				;
					;
	ENDIF				;END Microsoft Softcard			
					;
;....................................................................
;
; Send break to remote
;
					;
SENDBRK:
	 IF SABA
; This routine sends a 300 ms. break tone
          MVI	A,15H
	  OUT	MODCTL1		;SEND TO THE STATUS PORT
	  MVI	B,3		;DELAY 300 MS.
	  CALL	TIMERV
	  MVI	A,15H
	  OUT	MODCTL1
	ENDIF ;SABA
;
	RET				;
					;
;....................................................................
;
; Routine to exit just prior to exit-to-cpm
;
					;
GOODBYE:
	 IF SABA
; This routine sends a 300 ms. break tone and sets DTR low for the 
; same length of time to disconnect some modems such as the Bell 212A, etc.
;
          MVI	A,15H
	  OUT	MODCTL1		;SEND TO THE STATUS PORT
	  MVI	A,68H		;TURN OFF DTR
;
GOODBYE1: OUT	MODCTL1
	  MVI	B,3		;DELAY 300 MS.
	  CALL	TIMERV
	  MVI	A,15H
	  OUT	MODCTL1
	  MVI	A,0E8H		;RESTORE TO NORMAL, 8 BITS, DTR ON, ETC.
	  OUT	MODCTL1
	ENDIF ;SABA
;
	RET				;not done here
					;
;....................................................................
;
; Routine to Disconnect the Modem
;
					;
DISCON:
	IF SABA
		JMP	GOODBYE
	ENDIF ;SABA

	RET				;not now
					;
;....................................................................
;
; The following address is used to set data bits, parity, stop bits
; and baud rate on the Super Serial Card and baud rate on CCS7710 Card.
;
					;
	IF	SSC			;if Super Serial
MODDLL:		EQU	MODCTL1+2	;SSC ACIA control register
	ENDIF				;END Super Serial
					;
	IF	CCS7710			;if CCS7710
MODDLL:	EQU	MODCTL1			;CCS7710 ACIA control register
	ENDIF				;END CCS7710

	IF 	SABA			;if SABA
MODDLL:	EQU	MODCTL1			;Ray Klein Z80 SIO card
	ENDIF				;END SABA

;....................................................................
;
; Control over number of data bits, parity and number of stop
; bits has not been implemented.  These must be
; set using the slide switches on the Super Serial Card.  
;
; End of SSC specific equates for initialization.
;
; The following is used to initialize the Apple SSC on execution of the
; program.  Change it to initialize the modem port on your micro if you
; wish.  It initializes to 1200 baud.
;
	IF NOT SABA 
					;
	IF	SSC			;if Super-Serial (Apple or CCS)
INITMOD: MVI	A,5			;default transfer time to 1200
					; change 5 to 1 for 300 baud
	STA	MSPEED			;
					;
	IF	MICROSOFT 		;if Microsoft Softcard
	LDA	MODDLL			;current baudrate from MODDLL
	ENDIF				;End Microsoft
					;
	IF 	APPLICARD		;if Appli-Card or Star-Card
	PUSH	D			;
	LXI	D,MODDLL		;	
	CALL	PEEK			;
	POP	D			;
	ENDIF				;End Appli-Card or Star-Card
					;
        ANI   0F0H			;zero the last 4 bits
					;
INITMOD1: ORI   08H			;get default baudrate (1200)
					;change to 06H for 300 baud 
					;
	IF	MICROSOFT		;if Microsoft Softcard
	STA	MODDLL			;store default baudrate
	ENDIF				;END Microsoft Softcard
					;
	IF	APPLICARD		;if Appli-Card or Star-Card
	PUSH	D			;
	LXI	D,MODDLL		;
	CALL	POKE			;poke into 6502 memory
	POP	D			;
	ENDIF				;end if Appli-Card or Star-Card
					;
  	RET				;
	ENDIF				;END SSC (Super Serial)
					;
	ENDIF				; NOT SABA
;...
;
	 IF 	SABA
; Aplicard initialization -- sets CTC timer 00H for send and receive
; baudrate.
;
INITMOD:
	MVI	A,IMSPEED
	STA	MSPEED
	PUSH	PSW
	CALL	INIT
	POP	PSW
	CPI	1		; 300 bps
	CZ	OK300
	CPI	5		; 1200 bps
	CZ	OK1200
	CPI	6		; 2400 bps
	CZ	OK2400
	CPI	8		; 9600 bps
	CZ	OK9600
	CPI	9  		;19200 bps
	CZ	OK19200
	CPI	10		;38400 bps (only IMSPEED can be 10)
	CZ	OK38400

INITMOD1:	
	MVI	A,0
	RET			; CHANGING BITS ETC. NOT IN YET.

INIT:	  MVI	A,10H		;SELECT REG.
	  OUT	MODCTL1
	  MVI	A,18H		;THROW OUT OF MODE
	  OUT	MODCTL1
	  MVI	A,14H		;SELECT REG.
	  OUT	MODCTL1
	  MVI	A,44H		;SET ASCII PARAMETERS X16 CLOCK
	  OUT	MODCTL1
	  MVI	A,13H		;SELECT REG.
	  OUT	MODCTL1
	  MVI	A,0C1H		;ENABLE RECEIVE
	  OUT	MODCTL1
	  MVI	A,15H		;SELECT REG.
	  OUT	MODCTL1
	  MVI	A,0EAH		;ENABLE SEND, DTR, RTS
	  OUT	MODCTL1
	  RET


OK300:	  MVI	A,7
	  OUT	CPORT
	  MVI	A,78
	  OUT   CPORT
	  MVI	A,14H
	  OUT   MODCTL1
	  MVI	A,044H		; SET X16 CLOCK
	  OUT	MODCTL1
	  RET
;
OK1200:	  MVI	A,47H
	  OUT	CPORT
	  MVI	A,96
	  OUT   CPORT
	  MVI	A,14H
	  OUT   MODCTL1
	  MVI	A,044H		; SET X16 CLOCK
	  OUT	MODCTL1
	  RET
;
OK2400:	  MVI	A,47H
	  OUT	CPORT
	  MVI	A,48
	  OUT   CPORT
	  MVI	A,14H
	  OUT   MODCTL1
	  MVI	A,044H		; SET X16 CLOCK
	  OUT	MODCTL1
	  RET
;
OK9600:	  MVI	A,47H
	  OUT	CPORT
	  MVI	A,12		; off by 2.34%
	  OUT   CPORT
	  MVI	A,14H
	  OUT   MODCTL1
	  MVI	A,44H		; SET X16 CLOCK 
	  OUT	MODCTL1
	  RET
;
OK19200:  MVI	A,47H
	  OUT	CPORT
	  MVI	A,6		; off by 2.4%
	  OUT   CPORT
	  MVI	A,14H
	  OUT   MODCTL1
	  MVI	A,44H		; SET X16 CLOCK
	  OUT	MODCTL1
	  RET
;
OK38400:  MVI	A,47H
	  OUT	CPORT
	  MVI	A,3		; off by 2.4% but it works fine on mine!
	  OUT   CPORT
	  MVI	A,14H
	  OUT   MODCTL1
	  MVI	A,44H		; SET X16 CLOCK
	  OUT	MODCTL1
	  RET

	 ENDIF ;SABA



;....................................................................
;
;setup routines for the CCS 7710 serial card
;
					;
	IF	CCS7710			;if CCS7710
					;	
INITMOD: MVI	A,5			;default 1200 baud (1 for 300 baud) 
	STA	MSPEED			;
					;
INITMOD1: MVI	A,00010101B		;default 8 data + 1 stop bit at
					;1200 baud or change to 00010110B
					;to default to 300 baud - MAKE SURE
					;to set card switches to 1200 baud
					;
 	IF 	MICROSOFT		;if Microsoft Softcard
	STA	MODDLL			;
	ENDIF				;End Microsoft Softcard
					;
	IF	APPLICARD 		;if Appli-Card or Star-Card
	PUSH	D			;
	LXI	D,MODDLL		;
	CALL	POKE			;
	POP	D			;
	ENDIF				;END Appli-Card or Star-Card
					;
	RET				;
	ENDIF				;END CCS7710
					;
;....................................................................
;
; PCPI Appli-Card or Micro Pro Star-Card routines
;
					;
	IF	APPLICARD AND NOT SABA	;Appli-Card or Star-Card
					;
					;
					; PEEK AT 6502 MEMORY
					; ===================
					;Peek at 1 byte in the 6502 memory
					;Entry: DE = 6502 memory address
					;Exit:  A = Read data
PEEK:	PUSH	B			;save B 
	MVI	C,PEEK1BYTE		;peek1byte = 6
	CALL	WRBYTE			;wrbyte = 0FFE3H
	CALL	WRWORD			;wrword = 0FFE6H
	CALL	RDBYTE			;rdbyte = 0FFE0H
	POP	B			;get B back
	RET				;return to caller
					;
					;
					;
					; POKE AT 6502 MEMORY
					; ===================
					;Poke 1 byte into the 6502 memory
					;Entry: DE = 6502 memory address
					;       A = Write data
					;Exit:  nothing returned on exit
POKE:	PUSH	B			;save B
	MOV	B,A			;
	MVI	C,POKE1BYTE		;poke1byte = 7
	CALL	WRBYTE			;wrbyte = 0FFE3H
	CALL	WRWORD			;wrword = 0FFE9H
	MOV	C,B			;
	CALL	WRBYTE			;wrbyte = 0FFE3H
	POP	B			;get B back
	RET				;
					;
	ENDIF				;END Appli-Card or Star-Card
					;    AND NOT SABA 	
;....................................................................
;
;set baud rate 
;
SETUPR:	MVI	C,SBLANK		;any arguments?
	CALL	MEX			;
	JC	BDSHOW			;if not, go display baud
	LXI	D,CMDTBL		;
	MVI	C,LOOKUP		;
	CALL	MEX			;parse argument
	PUSH	H			;save any parsed argument adrs on stack
	RNC				;if we have one, return to it
	POP	H			;oops, input not found in table
SETERR:	MVI	C,ILP			;inline print
	CALL	MEX			;
	DB	CR,LF,'SET command'	;
	DB	' error',CR,LF,0	;let him know he goofed
	CALL	BDSHOW			;show the curent baud rate
	CALL	STHELP			;go show how it works 
	RET				;
					;
;....................................................................
;
; Argument table
;
CMDTBL:	DB	'?'+80H			;help
	DW	STHELP			;
	DB	'BAU','D'+80H		;set baud
	DW	STBAUD			;
	DB	0			;END OF CMD TABLE
					;
;....................................................................
;
; SET ? processor
;
STHELP: MVI	C,ILP			;inline print
	CALL	MEX			;
	DB	CR,LF			;
	DB	'SET BAUD (RATE)'	;
	DB	CR,LF			;
	DB	CR,LF			;
	DB	CR,LF			;
	DB	'Baud rate is one of:'	;
	DB	CR,LF			;
					;
	IF	CCS7710			;if CCS7710
	DB	'300 or 1200',CR,LF	;
	ENDIF				;END CCS7710
					;
	IF	SSC			;if Super Serial
	DB	'110, 300, 600, 1200, ' ;
	DB	'2400, 4800, 9600, or '	;
	DB	'19200 '               	;
	DB	CR,LF			;
	ENDIF				;END Super Serial
					
	IF 	SABA			;Ray Klein Z80 SIO Card
	DB	'300, 1200, 2400, 9600, '
	DB	'19200, or 38400 ',CR,LF
	ENDIF 				;SABA


	DB	CR,LF,0			;
	RET				;
					;
;....................................................................
;
;SET BAUD processor
;
					;
STBAUD:	MVI	C,BDPARS		;function code: parse a baudrate
	CALL	MEX			;let MEX look up code
	JC	SETERR			;jump if invalid code
	CALL	PBAUD			;
	JC	SETERR			;if not one of ours, bomb out
BDSHOW	MVI	C,ILP			;inline print
	CALL	MEX			;display baud
	DB	'Baud: ',0		;
	LDA	MSPEED			;
	MVI	C,PRBAUD		;let mex print it
	CALL	MEX			;
	RET				;
					;
;....................................................................
;
; This routine sets baud rate passed as MSPEED code in A.
; Returns CY=1 if baud rate not supported (if supported,
; this routine must set the new MSPEED code).
;
					;
PBAUD:	PUSH	H			;don't alter anybody
	PUSH	D			;
	PUSH	B			;
	MOV	E,A			;MSPEED code to DE
	MVI	D,0			;
	LXI	H,BAUDTB		;offset into table
	DAD	D			;
	MOV	A,M			;fetch code
	ORA	A			;0? (means unsupported code)
	STC				;prep carry in case unsupported
	JZ	PBEXIT			;
					;
LOADBD:	STA	INITMOD1+1		;store baud rate factor from table
	MOV	A,E			;get MSPEED back
	STA	INITMOD+1		;store in INITMOD
	CALL	INITMOD			;reset BAUD RATE
	ORA	A			;
					;
PBEXIT:	POP	B			;
	POP	D			;
	POP	H			;
	RET				;


	IF	SABA			;RAY KLEIN Z80 SIO CARD
					;
BAUDTB:	DB	0			;110 
	DB	3			;300 
	DB	0			;450 (not supported)
	DB	0			;600 
	DB	0			;710 (not supported)
	DB	5			;1200 
	DB	6			;2400 
	DB	0			;4800 
	DB	8			;9600 
	DB	9			;19200 
					;
	ENDIF				;END Super Serial


					;
	IF	CCS7710			;
					;
BAUDTB:	DB	0			;110   (not supported)
	DB	0016H			;300   (8DB, 1SB, 300 BAUD)
	DB	0			;450   (not supported)
	DB	0			;600   (not supported)
	DB	0			;710   (not supported)
	DB	0015H			;1200  (8DB, 1SB, 1200 BAUD)
	DB	0			;2400  (not supported)
	DB	0			;4800  (not supported)
	DB	0			;9600  (not supported)
	DB	0			;19200 (not supported)
					;
	ENDIF				;END CCS7710
					;
	IF	SSC			;if Super Serial
					;
BAUDTB:	DB	003H			;110 
	DB	006H			;300 
	DB	0			;450 (not supported)
	DB	007H			;600 
	DB	0			;710 (not supported)
	DB	008H			;1200 
	DB	00AH			;2400 
	DB	00CH			;4800 
	DB	00EH			;9600 
	DB	00FH			;19200 
					;
	ENDIF				;END Super Serial
					;
					;
;....................................................................
;
;Clear-to-end-of-screen  and Clear-screen sequences
;
EOSMSG:	DB	ESC,'Y','$'		;Televideo protocol
CLSMSG	DB	ESC,'*','$'		;Televideo protocol

;....................................................................
					;
	  END				;end of this overlay file

 