;;;
;;;   File: thread.st
;;;
;;;   Show how threading can be done in Situation Theoretic Grammar
;;;
;;;   Alan W Black (awb@ed.ac.uk) July 91
;;;
;;;   This shows how thread can be used to build up a resource situation
;;;   about people mentioned in a discourse.
;;;

Individuals
    {h,t}
Relations
    ( 
      use_of/2 cat/2 
      sem/2 env/2
      NounPhrase/0 Sentence/0 VerbPhrase/0 Discourse/0
      subj/0 pred/0 
      daughter/2
      resource/2 resource-in/2
      threads/2 t-in/2 t-need/2
      label/2 anchor/2 
      marker/2
      sing/1 
    )
Parameters
    {S,NP,VP,PN,V,TS,Res}
Variables
    {*X, *Y, *S, *NP, *VP, *V, *DS
     *D1, *T2, *T1
     *type, *type1, *type2,
     *ResInType, *Res,
     *ThreadS, *ThreadNP, *ThreadVP, *ThreadV, *Thread,
     *Resource}
Situations
    (SitResource
    )
Topcat
   *S : [S ! S != <<cat,S,discourse,1>>
;;             S != <<resource,S,*Resource>>
        ]

Constraints

;;; The resource is based the rsource from the previous situation
;;; in the thread
;;*S :: [S ! S != <<resource,S,*Res : *ResInType &
;;                                    [Res ! Res != <<marker,*Y,*Type>>],1>>]
;;   <=
;;      *S :: [S ! S != <<resource-in,S *ResIn : *ResInType,1>>
;;                 S != <<ind,S,*Y,*Type,1>>].
;;
;;*S :: [S ! S != <<resource-in,S,*Res,1>>]
;;<=
;;   ThreadSit :: [S ! S != <<t-in,*S,*S1,1>>],
;;   *S1 :: [S ! S != <<resource,S,*Res,1>>],

;;;
;;;  Gather the threading information from the daughters to the parent
;;;
*T1 :: [S ! S != <<t-in,*X,*Y,1>>]
<= 
   *S :: [S ! S != <<daughter,S,
			     *D1 :
			     [T ! T != <<threads,T,
                                          *T2 : [TS ! TS != <<t-in,*X,*Y,1>>],
                                          1>>],1>>
              S != <<threads,S,*T1,1>>].

;;;
;;;  This is basically a lexical rule to add the base case of the
;;;  threads.  Lexical items thread through themselves as they have
;;;  no daughters.
;;;
*S :: [S ! S != <<threads,S,*Thread : 
                            [TS ! TS != <<t-need,*S,*S,1>>],1>>]
<=
   *S :: [S ! S != <<use_of,S,*Y,1>>].

Grammar Rules
*S :: [S ! S != <<cat,S,Sentence,1>>
           S != <<daughter,S,*NP,1>>
	   S != <<daughter,S,*VP,1>>
	   S != <<threads,S,*ThreadS : 
			    [TS ! TS != <<t-need,*S,*Y,1>>
				  TS != <<t-in,*X,*NP,1>>
				  TS != <<t-in,*S,*VP,1>>],1>>]
   ->
    *NP :: [NP ! NP != <<cat,NP,NounPhrase,1>>
                 NP != <<threads,NP,*ThreadNP : 
                                    [TS ! TS != <<t-need,*NP,*Y,1>>],1>>],
    *VP :: [VP ! VP != <<cat,VP,VerbPhrase,1>>
                 VP != <<threads,VP,*ThreadVP : 
                                    [TS ! TS != <<t-need,*VP,*X,1>>],1>>].


*VP :: [VP ! VP != <<cat,VP,VerbPhrase,1>>
             VP != <<daughter,VP,*V,1>>
             VP != <<daughter,VP,*NP,1>>
	     VP != <<threads,VP,*ThreadVP :
                               [TS ! TS != <<t-need,*VP,*X,1>>
                                     TS != <<t-in,*Y,*V,1>>
                                     TS != <<t-in,*VP,*NP,1>>],1>>]
   ->
    *V :: [V ! V != <<cat,V,Verb,1>>
               V != <<threads,V,*ThreadV : 
                                 [TS ! TS != <<t-need,*V,*X,1>>],1>>],
    *NP :: [NP ! NP != <<cat,NP,NounPhrase,1>>
                 NP != <<threads,NP,*ThreadNP :
                                 [TS ! TS != <<t-need,*NP,*Y,1>>],1>>].

*DS :: [DS ! DS != <<cat,DS,Discourse,1>>
             DS != <<threads,S,*Thread : *type &
                              [TS ! TS != <<t-in,*Y,*DS,1>>],1>>
             DS != <<resource-in,DS,SitResource,1>>]
   ->
   *S :: [S ! S != <<cat,S,sentence,1>>
              S != <<threads,S,*Threads : *type &
                                 [TS ! TS != <<t-need,*S,*Y,1>>
                                       TS != <<t-in,*X,*Y,1>>],1>>].

Lexical Entries

Hanako - 
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"Hanako",1>>
         PN != <<ind,h,female,1>>]
Taro -
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"Taro",1>>
         PN != <<ind,t,male,1>>]
sings -
   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<use_of,VP,"sings",1>>]
likes -
   [V ! V != <<cat,V,Verb,1>>
        V != <<use_of,V,"likes",1>>]

