#!/bin/ksh

# **************************************************************************
# *
# * File:  customerProfileTestData.sh
# *
# * This file is for creating the Enterprise tables for the CustomerProfile AC
# *
# * Updated: November 30th, 2000
# *
# **************************************************************************

USAGE="\nUsage: customerProfileTestData.sh database [userid password] [qualifier]"
qualifier=$1

function ErrorMessage
{
  print "$USAGE"
}

function DirectConnectWithCurrentUserid
{
  db2 connect to $1
  qualifier=$USER
  CreateTables
}

function DirectConnectWithQualifier1
{
  db2 connect to $1
  qualifier=$2
  CreateTables
}

function ConnectWithParWithUserid
{
  db2 connect to $1 user $2 using $3
  qualifier=$2
  CreateTables
}

function ConnectWithParWithQualifier2
{
  db2 connect to $1 user $2 using $3
  qualifier=$4
  CreateTables
}

function CreateTables
{
  print "Customer table"
  db2 insert into $qualifier.customer values"('READONLY_TESTCUSTOMERE001', '1900-02-01-01.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('READONLY_TESTCUSTOMERE002', '1900-02-01-01.01.01.000001', ' ', 'ACT', 'ENTERPRISE', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.customer values"('READONLY_TESTCUSTOMERE003', '1900-02-01-01.01.01.000001', ' ', 'ACT', 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('READONLY_TESTCUSTOMERE004', '1900-02-01-01.01.01.000001', ' ', 'ACT', 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('READONLY_TESTCUSTOMERE005', '1900-02-01-01.01.01.000001', ' ', 'ACT', 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('READONLY_TESTCUSTOMERE006', '1900-02-01-01.01.01.000001', ' ', 'ACT', 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('READONLY_TESTCUSTOMERE007', '1900-02-01-01.01.01.000001', ' ', 'ACT', 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('DELETED_TESTCUSTOMERE001', '1900-02-01-01.01.01.000001', 'D', null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('DELETED_TESTCUSTOMERE002', '1900-02-01-01.01.01.000001', 'D', null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('UPDATABLE_TESTCUSTOMERE001', '1900-02-01-01.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('UPDATABLE_TESTCUSTOMERE002', '1900-02-01-01.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('ADDITEMS_TESTCUSTOMERE', '1900-02-01-01.01.01.000001', ' ', null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('DELETE_ITEMS_TESTCUSTE', '1900-02-01-01.01.01.000001', ' ', null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('DELETE_THIS_TESTCUSTE', '1900-02-01-01.01.01.000001', ' ', null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_1', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_2', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_3', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_4', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_5', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_6', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_7', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_8', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_9', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_10', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_11', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_12', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_13', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_14', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_15', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_16', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_17', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_18', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_19', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_20', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_21', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_22', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_23', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_24', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_25', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_26', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_27', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_28', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_29', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_30', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_31', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_32', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_33', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_34', '1900-01-01-02.01.01.000001', 'D', null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_35', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_36', '1900-01-01-02.01.01.000001', 'D', null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMERE_37', '1900-01-01-02.01.01.000001', null, null, 'ENTERPRISE', null, null)"
  print "Customer table populated"

  print "Enterprise Name table"
  db2 insert into $qualifier.enterprise_name values"('READONLY_ENTNAME001', '1900-02-01-01.01.01.000001', 'READONLY_TESTCUSTOMERE001', ' ', 'IBM Canada', 'PRI', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.enterprise_name values"('READONLY_ENTNAME002', '1900-02-01-01.01.01.000002', 'READONLY_TESTCUSTOMERE001', ' ', 'Government of Canada', 'PRI', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.enterprise_name values"('READONLY_ENTNAME003', '1900-02-01-01.01.01.000003', 'READONLY_TESTCUSTOMERE002', null, null, null, null, null)"
  db2 insert into $qualifier.enterprise_name values"('READONLY_ENTNAME004', '1900-02-01-01.01.01.000004', 'READONLY_TESTCUSTOMERE003', 'D', null, null, null, null)"
  db2 insert into $qualifier.enterprise_name values"('READONLY_ENTNAME005', '1900-02-01-01.01.01.000005', 'READONLY_TESTCUSTOMERE003', ' ', null, null, null, null)"
  db2 insert into $qualifier.enterprise_name values"('DELETED_ENTNAME001', '1900-02-01-01.01.01.000001', 'DELETED_TESTCUSTOMERE001', 'D', null, 'FOM', ' ', ' ')"
  db2 insert into $qualifier.enterprise_name values"('UPDATABLE_ENTNAME001', '1900-02-01-01.01.01.000001', 'UPDATABLE_TESTCUSTOMERE001', null, ' ', 'PRI', ' ', ' ')"
  db2 insert into $qualifier.enterprise_name values"('DELETE_CUSTE_ENTNAME', '1900-02-01-01.01.01.000001', 'DELETE_THIS_TESTCUSTE', null, ' ', 'PRI', ' ', ' ')"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_1', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_1', ' ', 'Dithers Co.', 'PRI', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_2', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_2', ' ', 'Dithers Co.', 'FOM', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_3', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_3', ' ', 'CASETEST', 'PRI', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_4', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_4', ' ', 'CASEtest', 'FOM', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_5', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_5', ' ', 'casetest', 'PRI', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_6', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_6', ' ', 'Dithers', 'FOM', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_7', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_7', ' ', 'Dothers Co.', 'FOM', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_8', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_8', ' ', 'abc', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_9', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_9', ' ', 'abcd', 'FOM', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_10', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_10', ' ', 'abcde', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_11', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_11', ' ', 'abcde', 'FOM', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_12', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_12', ' ', 'bbcde', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_13', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_13', ' ', 'bddde', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_14', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_14', ' ', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_15', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_15', ' ', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_16', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_16', ' ', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_17', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_17', ' ', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_18', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_18', ' ', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_19', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_19', ' ', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_20', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_20', ' ', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_21', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_21', ' ', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_22', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_22', ' ', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_23', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_23', ' ', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_24', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_24', ' ', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_25', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_25', ' ', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_26', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_26', ' ', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_27', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_27', ' ', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_28', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_28', ' ', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_29', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_29', ' ', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_30', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_30', ' ', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_31', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_31', ' ', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_32', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_32', ' ', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_33', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_33', ' ', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_34', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_34', 'D', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_35', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_35', ' ', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_36', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_36', 'D', 'manymatches', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_name values"('SEARCHNAMEE_37', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_37', ' ', 'manymatches', 'PRI', null, null)"
  print "Enterprise Name table populated"

  print "Enterprise Information table"
  db2 insert into $qualifier.enterprise_info values"('READONLY_ENTINFO001', '1900-01-02-01.01.02.000001', 'READONLY_TESTCUSTOMERE001', null, '01/01/1950', '01/01/2000', 'ENG', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.enterprise_info values"('READONLY_ENTINFO002', '1900-01-02-01.01.02.000002', 'READONLY_TESTCUSTOMERE002', ' ', '01/01/1975', '01/01/2000', 'FRE', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.enterprise_info values"('READONLY_ENTINFO003', '1900-01-02-01.01.02.000003', 'READONLY_TESTCUSTOMERE003', 'D', null, null, null, null, null)"
  db2 insert into $qualifier.enterprise_info values"('READONLY_ENTINFO004', '1900-01-02-01.01.02.000004', 'READONLY_TESTCUSTOMERE003', ' ', null, null, null, null, null)"
  db2 insert into $qualifier.enterprise_info values"('DELETED_ENTINFO001', '1900-01-02-01.01.01.000001', 'DELETED_TESTCUSTOMERE001', 'D', null, null, null, ' ', ' ')"
  db2 insert into $qualifier.enterprise_info values"('UPDATABLE_ENTINFO001', '1900-01-02-01.01.01.000001', 'UPDATABLE_TESTCUSTOMERE001', null, null, null, null, ' ', ' ')"
  db2 insert into $qualifier.enterprise_info values"('DELETE_CUSTE_ENTINF', '1900-01-02-01.01.01.000001', 'DELETE_THIS_TESTCUSTE', null, null, null, null, ' ', ' ')"
  db2 insert into $qualifier.enterprise_info values"('SEARCHINFOE_1', '1900-03-01-01.01.01.000001', 'SEARCHCUSTOMERE_1', null, '01/01/1950', '01/01/2000', 'ENG', ' ', ' ')"
  print "Enterprise Information table populated"

  print "Address table"
  db2 insert into $qualifier.postal_address values"('TESTCUSTOMERE2_ADDRESS1', '1900-02-01-01.01.03.000001', 'READONLY_TESTCUSTOMERE002', ' ','Ottawa', 'CAN', 'address line', '38', '38th st.', '12', 'ONT', 'M2M2M2', '1111111111', '2222222222')"
  db2 insert into $qualifier.postal_address values"('TESTCUSTOMERE3_ADDRESS1xxxxxxx', '1900-02-01-01.01.03.000002','READONLY_TESTCUSTOMERE003', ' ', 'CityCityCityCityCity', 'CAN', '12345678901234567890123456789012345678901234567890123456789012345678901234567890', 'boxboxboxbox', 'street789012345678901234567890', 'streetnum012', 'QUE', 'm3m3m3m3m3', '1111111111', '2222222222')"
  db2 insert into $qualifier.postal_address values"('TESTCUSTOMERE3_ADDRESS2', '1900-02-01-01.01.03.000003', 'READONLY_TESTCUSTOMERE003', ' ', null, 'USA', null, null, null, null, 'AL' , null, null, null)"
  db2 insert into $qualifier.postal_address values"('UPDATABLE1E_ADDRESS1', '1900-02-01-01.01.03.000004', 'UPDATABLE_TESTCUSTOMERE001', ' ','Ottawa', 'CAN', 'address line', '38', '38th st.', '12', 'ONT', 'M2M2M2', '1111111111', '2222222222')"
  db2 insert into $qualifier.postal_address values"('UPDATABLE1E_ADDRESS2', '1900-02-01-01.01.03.000005', 'UPDATABLE_TESTCUSTOMERE001', ' ', null, 'CAN', null, null, null, null, 'QUE', null, null, null)"
  db2 insert into $qualifier.postal_address values"('UPDATABLE1E_ADDRESSD', '1900-02-01-01.01.03.000006', 'UPDATABLE_TESTCUSTOMERE001', 'D', null, 'CAN', null, null, null, null, 'MAN', null, null, null)"
  db2 insert into $qualifier.postal_address values"('DELETABLEE_ADDRESS', '1900-02-01-01.01.03.000007', 'DELETE_ITEMS_TESTCUSTE', ' ', null, 'CAN', null, null, null, null, 'MAN', null, null, null)"
  db2 insert into $qualifier.postal_address values"('DELETABLEE_ADDRESS2', '1900-02-01-01.01.03.000008', 'DELETE_ITEMS_TESTCUSTE', ' ', null, 'CAN', null, null, null, null, 'ONT', null, null, null)"
  db2 insert into $qualifier.postal_address values"('DELETE_CUSTE_ADDRESS', '1900-02-01-01.01.03.000009', 'DELETE_THIS_TESTCUSTE', ' ', null, null, null, null, null, null, null, null, null, null)"
  db2 insert into $qualifier.postal_address values"('SEARCH1E_ADDRESS1', '1900-01-01-01.02.03.000001', 'SEARCHCUSTOMERE_1', ' ', 'Ottawa', 'CAN', 'Dithers address', '38', 'Dithers St.', '56', 'ONT', 'M2M2M2', '1111111111', '2222222222')"
  db2 insert into $qualifier.postal_address values"('SEARCH1E_ADDRESS2', '1900-01-01-01.02.03.000001', 'SEARCHCUSTOMERE_1', ' ', 'Windsor', 'CAN', 'Dithers second address', '98', 'Blondie St.', '87', 'ONT', 'L5L5L5', null, null)"
  print "Address table populated"

  print "Address usage table"
  db2 insert into $qualifier.address_usage values"('ADDUS1E', ' ', 'MAI', 'TESTCUSTOMERE2_ADDRESS1')"
  db2 insert into $qualifier.address_usage values"('ADDUS2E', ' ', 'PRM', 'TESTCUSTOMERE3_ADDRESS1xxxxxxx')"
  db2 insert into $qualifier.address_usage values"('ADDUS22E', ' ', 'MAI', 'TESTCUSTOMERE3_ADDRESS1xxxxxxx')"
  db2 insert into $qualifier.address_usage values"('ADDUS23E', ' ', 'PPL', 'TESTCUSTOMERE3_ADDRESS1xxxxxxx')"
  db2 insert into $qualifier.address_usage values"('ADDUS3E', ' ', 'MAI', 'TESTCUSTOMERE3_ADDRESS2')"
  db2 insert into $qualifier.address_usage values"('ADDUSUE', ' ', 'MAI', 'UPDATABLE1E_ADDRESS1')"
  db2 insert into $qualifier.address_usage values"('ADDUSU1E', ' ', 'MAI', 'UPDATABLE1E_ADDRESS2')"
  db2 insert into $qualifier.address_usage values"('ADDUSU2E', ' ', 'MAI', 'UPDATABLE1E_ADDRESSD')"
  db2 insert into $qualifier.address_usage values"('ADDUSUDE', ' ', 'MAI', 'DELETABLEE_ADDRESS')"
  db2 insert into $qualifier.address_usage values"('ADDUSUD2E', ' ', 'MAI', 'DELETABLEE_ADDRESS2')"
  db2 insert into $qualifier.address_usage values"('ADDUSDDE', ' ', 'MAI', 'DELETE_CUSTE_ADDRESS')"
  db2 insert into $qualifier.address_usage values"('SUS1E', ' ', 'MAI', 'SEARCH1E_ADDRESS1')"
  db2 insert into $qualifier.address_usage values"('SUS2E', ' ', 'PPL', 'SEARCH1E_ADDRESS2')"
  print "Address Usage information table populated"

  print "Phone table"
  db2 insert into $qualifier.phone_number values"('TESTCUSTOMERE2_PHONE1', '1900-02-01-01.01.03.000001', 'READONLY_TESTCUSTOMERE002', ' ','13', '43', '332', '33328', '432', 'BUF', '1111111111', '2222222222')"
  db2 insert into $qualifier.phone_number values"('TESTCUSTOMERE3_PHONE1xxxxxxxxx', '1900-02-01-01.01.03.000002','READONLY_TESTCUSTOMERE003', ' ', '1234', '5321', '7890', '54323453', '4323', 'BUF', '1111111111', '2222222222')"
  db2 insert into $qualifier.phone_number values"('TESTCUSTOMERE3_PHONE2', '1900-02-01-01.01.03.000003', 'READONLY_TESTCUSTOMERE003', ' ', null, null, null, null, null, 'BUP', null, null)"
  db2 insert into $qualifier.phone_number values"('UPDATABLE1E_PHONE1', '1900-02-01-01.01.03.000004', 'UPDATABLE_TESTCUSTOMERE001', ' ','54', '4', '2', '8', '4', 'BUF', '1111111111', '2222222222')"
  db2 insert into $qualifier.phone_number values"('UPDATABLE1E_PHONE2', '1900-02-01-01.01.03.000005', 'UPDATABLE_TESTCUSTOMERE001', ' ', null, null, null, null, null, 'BUF', null, null)"
  db2 insert into $qualifier.phone_number values"('UPDATABLE1E_PHONED', '1900-02-01-01.01.03.000006', 'UPDATABLE_TESTCUSTOMERE001', 'D', null, null, null, null, null, null, null, null)"
  db2 insert into $qualifier.phone_number values"('DELETABLEE_PHONE', '1900-02-01-01.01.03.000007', 'DELETE_ITEMS_TESTCUSTE', ' ', null, null, null, null, null, null, null, null)"
  db2 insert into $qualifier.phone_number values"('DELETABLEE_PHONE2', '1900-02-01-01.01.03.000008', 'DELETE_ITEMS_TESTCUSTE', ' ', null, null, null, null, null, null, null, null)"
  db2 insert into $qualifier.phone_number values"('DELETE_CUSTOMERE_PHONE', '1900-02-01-01.01.03.000009', 'DELETE_THIS_TESTCUSTE', ' ', null, null, null, null, null, null, null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH1E_PHONE', '1900-01-01-01.02.03.000001', 'SEARCHCUSTOMERE_1', ' ', '333', '44', '55', '3334444', '87', 'BUP', '1111111111', '2222222222')"
  db2 insert into $qualifier.phone_number values"('SEARCH2E_PHONE', '1900-01-01-01.02.03.000001', 'SEARCHCUSTOMERE_1', ' ', '666', '99', '33', '3434343', '44', 'BUF', '1111111111', '2222222222')"
  print "Phone table populated"

  print "Email address table"
  db2 insert into $qualifier.email_address values"('TESTCUSTOMERE2_EMAIL1', '1900-02-01-01.01.03.000001', 'READONLY_TESTCUSTOMERE002', ' ','testcustomere2', 'ibm.com', 'PRM', '1111111111', '2222222222')"
  db2 insert into $qualifier.email_address values"('TESTCUSTOMERE3_EMAIL1xxxxxxxxx', '1900-02-01-01.01.03.000002','READONLY_TESTCUSTOMERE003', ' ', 'testcustomere123456789012', '1234567890.12345678901234', 'OTR', '1111111111', '2222222222')"
  db2 insert into $qualifier.email_address values"('TESTCUSTOMERE3_EMAIL2', '1900-02-01-01.01.03.000003', 'READONLY_TESTCUSTOMERE003', ' ', null, null, 'PRM', null, null)"
  db2 insert into $qualifier.email_address values"('UPDATABLE1E_EMAIL1', '1900-02-01-01.01.03.000004', 'UPDATABLE_TESTCUSTOMERE001', ' ','ut1', 'home.com', 'PRM', '1111111111', '2222222222')"
  db2 insert into $qualifier.email_address values"('UPDATABLE1E_EMAIL2', '1900-02-01-01.01.03.000005', 'UPDATABLE_TESTCUSTOMERE001', ' ', null, null, 'OTR', null, null)"
  db2 insert into $qualifier.email_address values"('UPDATABLE1E_EMAILD', '1900-02-01-01.01.03.000006', 'UPDATABLE_TESTCUSTOMERE001', 'D', null, null, null, null, null)"
  db2 insert into $qualifier.email_address values"('DELETABLEE_EMAIL', '1900-02-01-01.01.03.000007', 'DELETE_ITEMS_TESTCUSTE', ' ',  null, null, null, null, null)"
  db2 insert into $qualifier.email_address values"('DELETABLEE_EMAIL2', '1900-02-01-01.01.03.000008', 'DELETE_ITEMS_TESTCUSTE', ' ', null, null, null, null, null)"
  db2 insert into $qualifier.email_address values"('DELETE_CUSTOMERE_EMAIL', '1900-02-01-01.01.03.000009', 'DELETE_THIS_TESTCUSTE', ' ', null, null, null, null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH1E_EMAIL', '1900-01-01-01.02.03.000001', 'SEARCHCUSTOMERE_1', ' ', 'Dithers', 'Dithers.com', 'OTR', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH2E_EMAIL', '1900-01-01-01.02.03.000001', 'SEARCHCUSTOMERE_1', ' ', 'Dithers', 'Dithers.com', 'PRM', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH2E_EMAIL2', '1900-01-01-01.02.03.000002', 'SEARCHCUSTOMERE_2', ' ', 'Bumstead', 'Dithers.com', 'PRM', null, null)"
  print "Email address table populated"

  print "Customer table"
  db2 insert into $qualifier.customer values"('READONLY_TESTCUSTOMER001', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('READONLY_TESTCUSTOMER002', '1900-01-01-01.01.01.000001', ' ', 'ACT', 'PERSON', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.customer values"('READONLY_TESTCUSTOMER003', '1900-01-01-01.01.01.000001', ' ', 'ACT', 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('READONLY_TESTCUSTOMER004', '1900-01-01-01.01.01.000001', ' ', 'ACT', 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('READONLY_TESTCUSTOMER005', '1900-01-01-01.01.01.000001', ' ', 'ACT', 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('READONLY_TESTCUSTOMER006', '1900-01-01-01.01.01.000001', ' ', 'ACT', 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('READONLY_TESTCUSTOMER007', '1900-01-01-01.01.01.000001', ' ', 'ACT', 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('DELETED_TESTCUSTOMER001', '1900-01-01-01.01.01.000001', 'D', null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('DELETED_TESTCUSTOMER002', '1900-01-01-01.01.01.000001', 'D', null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('UPDATABLE_TESTCUSTOMER001', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('UPDATABLE_TESTCUSTOMER002', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('ADDITEMS_TESTCUSTOMER', '1900-01-01-01.01.01.000001', ' ', null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('TOOMANY_ITEMS_TESTCUSTOMER', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('DELETE_ITEMS_TESTCUSTOMER', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('DELETE_THIS_CUSTOMER', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_1', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_2', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_3', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_4', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_5', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_6', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_7', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_8', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_9', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_10', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_11', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_12', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_13', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_14', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_15', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_16', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_17', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_18', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_19', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_20', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_21', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_22', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_23', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_24', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_25', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_26', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_27', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_28', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_29', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_30', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_31', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_32', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_33', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_34', '1900-01-01-01.01.01.000001', 'D', null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_35', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_36', '1900-01-01-01.01.01.000001', 'D', null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_37', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_38', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_39', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('SEARCHCUSTOMER_40', '1900-01-01-01.01.01.000001', null, null, 'PERSON', null, null)"
  print "Customer table populated"

  print "Person Name table"
  db2 insert into $qualifier.person_name values"('READONLY_PERSONNAME001', '1900-01-01-01.01.01.000001', 'READONLY_TESTCUSTOMER001', ' ', 'Alice', 'Wonderland', 'In', 'MSS', 'Adventurer', 'LGL', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.person_name values"('READONLY_PERSONNAME002', '1900-01-01-01.01.01.000002', 'READONLY_TESTCUSTOMER001', ' ', 'Mad', 'Hatter', null, 'MR', 'Esquire', 'LGL', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.person_name values"('READONLY_PERSONNAME003', '1900-01-01-01.01.01.000003', 'READONLY_TESTCUSTOMER002', null, null, 'Wonderland', 'In', null, null, null, null, null)"
  db2 insert into $qualifier.person_name values"('READONLY_PERSONNAME004', '1900-01-01-01.01.01.000004', 'READONLY_TESTCUSTOMER003', 'D', null, null, null, null, null, null, null, null)"
  db2 insert into $qualifier.person_name values"('READONLY_PERSONNAME005', '1900-01-01-01.01.01.000005', 'READONLY_TESTCUSTOMER003', ' ', null, null, null, null, null, null, null, null)"
  db2 insert into $qualifier.person_name values"('DELETED_PERSONNAME001', '1900-01-01-01.01.01.000001', 'DELETED_TESTCUSTOMER001', 'D', ' ', ' ', ' ', null, null, 'LGL', ' ', ' ')"
  db2 insert into $qualifier.person_name values"('UPDATABLE_PERSONNAME001', '1900-01-01-01.01.01.000001', 'UPDATABLE_TESTCUSTOMER001', null, ' ', ' ', ' ', null, null, 'LGL', ' ', ' ')"
  db2 insert into $qualifier.person_name values"('DELETE_CUST_PERSONNAME', '1900-01-01-01.01.01.000001', 'DELETE_THIS_CUSTOMER', null, ' ', ' ', ' ', null, null, 'LGL', ' ', ' ')"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_1', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_1', ' ', 'Dagwood', 'Bumstead', null, 'MR', 'Employee', 'LGL', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_2', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_2', ' ', 'Dagwood', 'Bumstead', null, 'MRS', 'Employee', 'MLG', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_3', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_3', ' ', 'CASE', 'TEST', null, 'MR', 'Employee', 'LGL', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_4', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_4', ' ', 'CASE', 'test', null, 'MRS', 'Employee', 'MLG', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_5', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_5', ' ', 'case', 'test', null, 'MRS', 'Employee', 'MLG', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_6', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_6', ' ', 'Blondie', 'Bumstead', null, 'MRS', 'Employee', 'MLG', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_7', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_7', ' ', null, 'Bumstead', null, null, null, 'MLG', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_8', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_8', ' ', 'abc', 'pqr', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_9', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_9', ' ', 'abcd', 'pqrs', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_10', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_10', ' ', 'abcde', 'pqrst', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_11', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_11', ' ', 'abcde', 'pqrst', null, null, null, 'MLG', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_12', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_12', ' ', 'bbcde', 'qqrst', null, null, null, 'MLG', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_13', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_13', ' ', 'bddde', 'qqqqt', null, null, null, 'MLG', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_14', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_14', ' ', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_15', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_15', ' ', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_16', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_16', ' ', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_17', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_17', ' ', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_18', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_18', ' ', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_19', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_19', ' ', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_20', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_20', ' ', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_21', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_21', ' ', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_22', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_22', ' ', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_23', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_23', ' ', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_24', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_24', ' ', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_25', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_25', ' ', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_26', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_26', ' ', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_27', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_27', ' ', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_28', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_28', ' ', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_29', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_29', ' ', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_30', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_30', ' ', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_31', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_31', ' ', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_32', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_32', ' ', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_33', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_33', ' ', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_34', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_34', 'D', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_35', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_35', ' ', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_36', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_36', 'D', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_37', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_37', ' ', 'many', 'matches', null, null, null, 'LGL', null, null)"
  db2 insert into $qualifier.person_name values"('SEARCHNAME_38', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_38', ' ', 'Barnie', 'Rubble', null, 'MR', 'Employee', 'MLG', 'dynCol1', 'dynCol2')"
  print "Person Name table populated"

  print "Person Information table"
  db2 insert into $qualifier.person_info values"('READONLY_PERSONINFO001', '1900-01-01-01.01.02.000001', 'READONLY_TESTCUSTOMER001', null, '01/01/1900', '01/01/2000', 'FEM', 'ENG', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.person_info values"('READONLY_PERSONINFO002', '1900-01-01-01.01.02.000002', 'READONLY_TESTCUSTOMER002', ' ', '01/01/1900', '01/01/2000', 'FEM', 'ENG', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.person_info values"('READONLY_PERSONINFO003', '1900-01-01-01.01.02.000003', 'READONLY_TESTCUSTOMER003', 'D', null, null, null, null, null, null)"
  db2 insert into $qualifier.person_info values"('READONLY_PERSONINFO004', '1900-01-01-01.01.02.000004', 'READONLY_TESTCUSTOMER003', ' ', null, null, null, null, null, null)"
  db2 insert into $qualifier.person_info values"('DELETED_PERSONINFO001', '1900-01-01-01.01.01.000001', 'DELETED_TESTCUSTOMER001', 'D', null, null, null, null, ' ', ' ')"
  db2 insert into $qualifier.person_info values"('UPDATABLE_PERSONINFO001', '1900-01-01-01.01.01.000001', 'UPDATABLE_TESTCUSTOMER001', null, null, null, null, null, ' ', ' ')"
  db2 insert into $qualifier.person_info values"('SEARCHINFO_1', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_1', null, '01/01/1910', '01/01/1999', 'MAL', 'ENG', ' ', ' ')"
  db2 insert into $qualifier.person_info values"('DELETE_CUST_PERSONINFO', '1900-01-01-01.01.01.000001', 'DELETE_THIS_CUSTOMER', ' ', null, null, null, null, null, null)"
  print "Person Information table populated"

  print "Address table"
  db2 insert into $qualifier.postal_address values"('TESTCUSTOMER2_ADDRESS1', '1900-01-01-01.01.03.000001', 'READONLY_TESTCUSTOMER002', ' ','Ottawa', 'CAN', 'address line', '38', '38th st.', '12', 'ONT', 'M2M2M2', '1111111111', '2222222222')"
  db2 insert into $qualifier.postal_address values"('TESTCUSTOMER3_ADDRESS1xxxxxxxx', '1900-01-01-01.01.03.000002','READONLY_TESTCUSTOMER003', ' ', 'CityCityCityCityCity', 'CAN', '12345678901234567890123456789012345678901234567890123456789012345678901234567890', 'boxboxboxbox', 'street789012345678901234567890', 'streetnum012', 'QUE', 'm3m3m3m3m3', '1111111111', '2222222222')"
  db2 insert into $qualifier.postal_address values"('TESTCUSTOMER3_ADDRESS2', '1900-01-01-01.01.03.000003', 'READONLY_TESTCUSTOMER003', ' ', null, 'USA', null, null, null, null, 'AL' , null, null, null)"
  db2 insert into $qualifier.postal_address values"('TESTCUSTOMER4_ADDRESS1', '1900-01-01-01.01.03.000004', 'READONLY_TESTCUSTOMER004', 'D', null, 'CAN', null, null, null, null, 'ONT', null, null, null)"
  db2 insert into $qualifier.postal_address values"('DELETED_ADDRESSINFO001', '1900-01-01-01.01.03.000006', 'DELETED_TESTCUSTOMER001', 'D', null, null, null, null, null, null, null, null, null, null)"
  db2 insert into $qualifier.postal_address values"('UPDATABLE1_ADDRESS1', '1900-01-01-01.01.03.000005', 'UPDATABLE_TESTCUSTOMER001', ' ', 'Ottawa', 'CAN', 'address line', '38', '38th st.', '12', 'ONT', 'M2M2M2', '1111111111', '2222222222')"
  db2 insert into $qualifier.postal_address values"('UPDATABLE2_ADDRESS2', '1900-01-01-01.01.03.000008', 'UPDATABLE_TESTCUSTOMER002', ' ', 'Windsor', 'CAN', 'address line', '34', '34th ave.', '32', 'ONT', 'L4L4L4', '3333333333', '4444444444')"
  db2 insert into $qualifier.postal_address values"('DELETE_THIS_ADDRESS', '1900-01-01-01.01.03.000007', 'DELETE_ITEMS_TESTCUSTOMER', ' ', 'Ottawa', 'CAN', null, null, null,  null, 'ONT', null, null, null)"
  db2 insert into $qualifier.postal_address values"('SEARCH1_ADDRESS1', '1900-01-01-01.02.03.000001', 'SEARCHCUSTOMER_1', ' ', 'Ottawa', 'CAN', 'Bumstead address', '38', 'Dithers St.', '56', 'ONT', 'M2M2M2', '1111111111', '2222222222')"
  db2 insert into $qualifier.postal_address values"('SEARCH1_ADDRESS2', '1900-01-01-01.02.03.000001', 'SEARCHCUSTOMER_1', ' ', 'Windsor', 'CAN', 'Bumstead second address', '98', 'Blondie St.', '87', 'ONT', 'L5L5L5', null, null)"
  db2 insert into $qualifier.postal_address values"('SEARCH1_ADDRESS3', '1900-01-01-01.02.03.000001', 'SEARCHCUSTOMER_1', ' ', 'Winnipeg', 'CAN', 'Bumstead third address', '77', 'Portage St.', '65', 'MAN', 'J4J4J4', null, null)"
  db2 insert into $qualifier.postal_address values"('SEARCH1_ADDRESS4', '1900-01-01-01.02.03.000001', 'SEARCHCUSTOMER_1', ' ', 'Brandon', 'CAN', 'Bumstead fourth address', '78', 'Main St.', '64', 'MAN', 'J5J7J4', null, null)"
  db2 insert into $qualifier.postal_address values"('DELETE_CUST_ADDRESS', '1900-01-01-01.02.03.000001', 'DELETE_THIS_CUSTOMER', ' ', null, null, null, null, null, null, null, null, null, null)"
  print "Address table populated"

  print "Address usage table"
  db2 insert into $qualifier.address_usage values"('ADDUS1', ' ', 'MAG', 'TESTCUSTOMER2_ADDRESS1')"
  db2 insert into $qualifier.address_usage values"('ADDUS2', ' ', 'VAC', 'TESTCUSTOMER3_ADDRESS1xxxxxxxx')"
  db2 insert into $qualifier.address_usage values"('ADDUS22', ' ', 'HOM', 'TESTCUSTOMER3_ADDRESS1xxxxxxxx')"
  db2 insert into $qualifier.address_usage values"('ADDUS23', ' ', 'BUS', 'TESTCUSTOMER3_ADDRESS1xxxxxxxx')"
  db2 insert into $qualifier.address_usage values"('ADDUS3', ' ', 'VAC', 'TESTCUSTOMER3_ADDRESS2')"
  db2 insert into $qualifier.address_usage values"('ADDUSU', ' ', 'MAG', 'UPDATABLE1_ADDRESS1')"
  db2 insert into $qualifier.address_usage values"('ADDUSU2', ' ', 'MAG', 'UPDATABLE2_ADDRESS2')"
  db2 insert into $qualifier.address_usage values"('ADDUSD', ' ', 'MAG', 'DELETE_THIS_ADDRESS')"
  db2 insert into $qualifier.address_usage values"('SUS1', ' ', 'MAG', 'SEARCH1_ADDRESS1')"
  db2 insert into $qualifier.address_usage values"('SUS2', ' ', 'VAC', 'SEARCH1_ADDRESS2')"
  db2 insert into $qualifier.address_usage values"('SUS3', ' ', 'HOM', 'SEARCH1_ADDRESS3')"
  db2 insert into $qualifier.address_usage values"('SUS4', ' ', 'BUS', 'SEARCH1_ADDRESS4')"
  db2 insert into $qualifier.address_usage values"('DCA', ' ', 'BUS', 'DELETE_CUST_ADDRESS')"
  print "Address Usage information table populated"

  print "Phone table"
  db2 insert into $qualifier.phone_number values"('TESTCUSTOMER2_PHONE1', '1900-01-01-01.01.03.000001', 'READONLY_TESTCUSTOMER002', ' ','134', '78', '70', '145678', '14', 'REP', '1111111111', '2222222222')"
  db2 insert into $qualifier.phone_number values"('TESTCUSTOMER3_PHONE1xxxxxxxxxx', '1900-01-01-01.01.03.000002','READONLY_TESTCUSTOMER003', ' ', '1234', '5678', '9023', '12345678', '5432', 'BPH', '1111111111', '2222222222')"
  db2 insert into $qualifier.phone_number values"('TESTCUSTOMER3_PHONE2', '1900-01-01-01.01.03.000003', 'READONLY_TESTCUSTOMER003', ' ', null, null, null, null, null, 'HFX', null, null)"
  db2 insert into $qualifier.phone_number values"('TESTCUSTOMER4_PHONE1', '1900-01-01-01.01.03.000004', 'READONLY_TESTCUSTOMER004', 'D', null, null, null, '12345', null, 'CEL', null, null)"
  db2 insert into $qualifier.phone_number values"('DELETED_PHONEINFO001', '1900-01-01-01.01.03.000006', 'DELETED_TESTCUSTOMER001', 'D', null, null, null, null, null, 'BFX', null, null)"
  db2 insert into $qualifier.phone_number values"('UPDATABLE1_PHONE1', '1900-01-01-01.01.03.000005', 'UPDATABLE_TESTCUSTOMER001', ' ', '343', '343', '542', '245432', '44', 'REP', '1111111111', '2222222222')"
  db2 insert into $qualifier.phone_number values"('UPDATABLE2_PHONE2', '1900-01-01-01.01.03.000008', 'UPDATABLE_TESTCUSTOMER002', ' ', '545', '544', '364', '643424', '66', 'REP', '3333333333', '4444444444')"
  db2 insert into $qualifier.phone_number values"('DELETE_THIS_PHONE', '1900-01-01-01.01.03.000007', 'DELETE_ITEMS_TESTCUSTOMER', ' ',  null, null, null,  '3432343', null, null, null, null)"
  db2 insert into $qualifier.phone_number values"('DELETE_CUST_PHONE', '1900-01-01-01.02.03.000001', 'DELETE_THIS_CUSTOMER', ' ', null, null, null, null, null, null, null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH1_PHONE', '1900-01-01-01.02.03.000001', 'SEARCHCUSTOMER_1', ' ', '333', '44', null, '3334444', '87', 'REP', '1111111111', '2222222222')"
  db2 insert into $qualifier.phone_number values"('SEARCH2_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_2', ' ', '333', '44', null, '4443333', '871', 'BPH', '1111111111', '2222222222')"
  db2 insert into $qualifier.phone_number values"('SEARCH3_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_3', ' ', 'CASE', 'TEST', 'CASE', 'TEST', 'CASE', 'REP', '1111111111', '2222222222')"
  db2 insert into $qualifier.phone_number values"('SEARCH4_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_4', ' ', 'CASE', 'test', 'CASE', 'test', 'case', 'REP', '1111111111', '2222222222')"
  db2 insert into $qualifier.phone_number values"('SEARCH5_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_5', ' ', 'case', 'test', 'case', 'test', 'case', 'REP', '1111111111', '2222222222')"
  db2 insert into $qualifier.phone_number values"('SEARCH6_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_6', ' ', '444', '44', null, '4443333', '871', 'BPH', '1111111111', '2222222222')"
  db2 insert into $qualifier.phone_number values"('SEARCH7_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_7', ' ', null, null, '44', null, null, 'BPH', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH8_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_8', ' ', '232', '232', '232', '2322222', null, 'BPH', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH9_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_9', ' ', '332', '332', '332', '3322222', null, 'BPH', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH10_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_10', ' ', '233', '233', '233', '2333333', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH11_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_11', ' ', '234', '234', '234', '2344444', null, 'BPH', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH12_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_12', ' ', '131', '1331', '101', '1320001', null, 'BPH', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH13_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_13', ' ', '141', '131', '1221', '1321101', null, 'BPH', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH14_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_14', ' ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH15_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_15', ' ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH16_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_16', ' ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH17_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_17', ' ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH18_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_18', ' ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH19_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_19', ' ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH20_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_20', ' ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH21_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_21', ' ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH22_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_22', ' ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH23_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_23', ' ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH24_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_24', 'D', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH25_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_25', ' ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH26_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_26', ' ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH27_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_27', ' ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH28_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_28', ' ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH29_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_29', ' ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH30_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_30', ' ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH31_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_31', ' ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH32_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_32', ' ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH33_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_33', ' ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH34_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_34', 'D ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH35_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_35', ' ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH36_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_36', ' ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH37_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_37', ' ', null, null, 'many', 'matches', null, 'REP', null, null)"
  db2 insert into $qualifier.phone_number values"('SEARCH39_PHONE', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_39', ' ', null, null, '999', '9879876', null, 'BPH', null, null)"
  print "Phone table populated"

  print "Email address table"
  db2 insert into $qualifier.email_address values"('TESTCUSTOMER2_EMAIL1', '1900-01-01-01.01.03.000001', 'READONLY_TESTCUSTOMER002', ' ', 'testcustomer2', 'ibm.com',  'HME', '1111111111', '2222222222')"
  db2 insert into $qualifier.email_address values"('TESTCUSTOMER3_EMAIL1xxxxxxxxxx', '1900-01-01-01.01.03.000002','READONLY_TESTCUSTOMER003', ' ', 'testcustomer123456789012', '1234567890.12345678901234', 'BSN', '1111111111', '2222222222')"
  db2 insert into $qualifier.email_address values"('TESTCUSTOMER3_EMAIL2', '1900-01-01-01.01.03.000003', 'READONLY_TESTCUSTOMER003', ' ', null, null, 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('TESTCUSTOMER4_EMAIL1', '1900-01-01-01.01.03.000004', 'READONLY_TESTCUSTOMER004', 'D', null, null, 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('DELETED_EMAILINFO001', '1900-01-01-01.01.03.000006', 'DELETED_TESTCUSTOMER001', 'D', null, null, 'BSN', null, null)"
  db2 insert into $qualifier.email_address values"('UPDATABLE1_EMAIL1', '1900-01-01-01.01.03.000005', 'UPDATABLE_TESTCUSTOMER001', ' ','updatable', 'interlog.com', 'BSN', '1111111111', '2222222222')"
  db2 insert into $qualifier.email_address values"('UPDATABLE2_EMAIL2', '1900-01-01-01.01.03.000008', 'UPDATABLE_TESTCUSTOMER002', ' ', 'second', 'ibm.org', 'HME', '3333333333', '4444444444')"
  db2 insert into $qualifier.email_address values"('DELETE_THIS_EMAIL', '1900-01-01-01.01.03.000007', 'DELETE_ITEMS_TESTCUSTOMER', ' ', 'delete_this', null, null, null, null)"
  db2 insert into $qualifier.email_address values"('DELETE_CUST_EMAIL', '1900-01-01-01.02.03.000001', 'DELETE_THIS_CUSTOMER', ' ', null, null, 'BSN', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH1_EMAIL', '1900-01-01-01.02.03.000001', 'SEARCHCUSTOMER_1', ' ', 'Bumstead', 'Dithers.com', 'BSN', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH2_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_2', ' ', 'Bumstead', 'Dithers.com', 'HME', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.email_address values"('SEARCH3_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_3', ' ', 'CASE', 'TEST', 'BSN', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.email_address values"('SEARCH4_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_4', ' ', 'CASE', 'test', 'BSN', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.email_address values"('SEARCH5_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_5', ' ', 'case', 'test', 'BSN', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.email_address values"('SEARCH6_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_6', ' ', 'Blondie', 'Dithers.com', 'BSN', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.email_address values"('SEARCH7_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_7', ' ', 'Bumstead', 'Dithers.gov', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH8_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_8', ' ', 'abc', 'pqr', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH9_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_9', ' ', 'abcd', 'pqrs', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH10_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_10', ' ', 'abcde', 'pqrst', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH11_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_11', ' ', 'abcde', 'pqrst', 'BSN', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH12_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_12', ' ', 'bbcde', 'qqrst', 'BSN', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH13_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_13', ' ', 'bddde', 'qqqqt', 'BSN', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH14_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_14', ' ', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH15_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_15', ' ', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH16_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_16', ' ', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH17_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_17', ' ', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH18_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_18', ' ', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH19_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_19', ' ', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH20_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_20', ' ', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH21_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_21', ' ', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH22_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_22', ' ', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH23_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_23', ' ', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH24_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_24', ' ', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH25_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_25', ' ', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH26_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_26', ' ', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH27_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_27', ' ', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH28_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_28', ' ', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH29_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_29', ' ', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH30_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_30', ' ', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH31_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_31', ' ', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH32_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_32', ' ', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH33_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_33', ' ', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH34_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_34', 'D', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH35_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_35', ' ', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH36_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_36', 'D', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH37_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_37', ' ', 'many', 'matches', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"('SEARCH40_EMAIL', '1900-01-01-01.01.01.000001', 'SEARCHCUSTOMER_40', ' ', 'Rubble', 'Slate.com', 'HME', 'dynCol1', 'dynCol2')"
  print "Email table populated"
}

# *
# * Following block is for connecting to database and setting qualifier depending 
# * on number of parameters.
# *

if [[ $# = 0 ]]
then ErrorMessage
elif [[ $# = 1 ]]
then DirectConnectWithCurrentUserid $1
elif [[ $# = 2 ]]
then DirectConnectWithQualifier1 $1 $2
elif [[ $# = 3 ]]
then ConnectWithParWithUserid $1 $2 $3
elif [[ $# = 4 ]]
then ConnectWithParWithQualifier2 $1 $2 $3 $4
elif [[ $# > 4 ]]
then ErrorMessage
fi

db2 grant connect on database to public
db2 connect reset