#!/bin/ksh

# **************************************************************************
# *
# * File:  OCSample.sh
# *
# * This file is for running the OrderCapture Sample
# *
# * Updated: November 30th, 2000
# *
# **************************************************************************

USAGE="\nUsage: OCSample.sh [userid password] [qualifier]"
qualifier=$1


function ErrorMessage
{
  print "$USAGE"
}

function DirectConnectWithCurrentUserid
{
  qualifier=$USER

  print ""
  print "========================"
  print " Customer Profile Setup "
  print "========================"
  print ""

  db2 connect to $CP_DB
  CreateCPData
  db2 connect reset

  print ""
  print "======================="
  print " Product Catalog Setup "
  print "======================="
  print ""

  db2 connect to $PC_DB
  CreatePCData
  db2 connect reset
}

function DirectConnectWithqualifier1
{
  qualifier=$1

  print ""
  print "========================"
  print " Customer Profile Setup "
  print "========================"
  print ""

  db2 connect to $CP_DB
  CreateCPData
  db2 connect reset

  print ""
  print "======================="
  print " Product Catalog Setup "
  print "======================="
  print ""

  db2 connect to $PC_DB
  CreatePCData
  db2 connect reset
}

function ConnectWithParWithUserid
{
  qualifier=$1

  print ""
  print "========================"
  print " Customer Profile Setup "
  print "========================"
  print ""

  db2 connect to $CP_DB user $1 using $2
  CreateCPData
  db2 connect reset

  print ""
  print "======================="
  print " Product Catalog Setup "
  print "======================="
  print ""

  db2 connect to $PC_DB user $1 using $2
  CreatePCData
  db2 connect reset
}

function ConnectWithParWithqualifier2
{
  qualifier=$3

  print ""
  print "========================"
  print " Customer Profile Setup "
  print "========================"
  print ""

  db2 connect to $CP_DB user $1 using $2
  CreateCPData
  db2 connect reset

  print ""
  print "======================="
  print " Product Catalog Setup "
  print "======================="
  print ""

  db2 connect to $PC_DB user $1 using $2
  CreatePCData
  db2 connect reset
}

function CreateCPData
{
  print ""
  print "Creating Code Tables"
  print ""
  db2 -o- drop table $qualifier.code_category
  db2 -o- drop table $qualifier.code_group
  db2 -o- drop table $qualifier.code
  db2 -o- drop table $qualifier.category_group


  db2 create table $qualifier.code_category"(category_id char(5) not null primary key,description varchar(50))"
  db2 insert into $qualifier.code_category values"('CON','Contact Information')"
  db2 insert into $qualifier.code_category values"('CI' ,'Customer Information')"
  db2 insert into $qualifier.code_category values"('TEL','Telephone Information')"
  db2 insert into $qualifier.code_category values"('PI' ,'Personal Information')"
  db2 insert into $qualifier.code_category values"('PN' ,'Person Name Information')"
  db2 insert into $qualifier.code_category values"('BC' ,'Basic Customer Information')"
  db2 insert into $qualifier.code_category values"('ADI','Address Information')"
  db2 insert into $qualifier.code_category values"('EAI','Electronic Address Information')"
  db2 insert into $qualifier.code_category values"('ENI','Enterprise Information')"

  db2 create table $qualifier.code_group"(property_id char(5) not null primary key,description varchar(50))"
  db2 insert into $qualifier.code_group values"('TEU','Telephone Usage')"
  db2 insert into $qualifier.code_group values"('LA' ,'Language')"
  db2 insert into $qualifier.code_group values"('AU' ,'Address Usage')"
  db2 insert into $qualifier.code_group values"('NU' ,'Name Usage')"
  db2 insert into $qualifier.code_group values"('EAU','Email Address Usage')"
  db2 insert into $qualifier.code_group values"('COU','Country')"
  db2 insert into $qualifier.code_group values"('REG','Region')"
  db2 insert into $qualifier.code_group values"('CST','Customer Status')"
  db2 insert into $qualifier.code_group values"('GEN','Gender')"
  db2 insert into $qualifier.code_group values"('TTL','Title')"
 
  db2 create table $qualifier.code"(code_id char(5) not null primary key, group char(5) not null, dependency_code char(5) default null, description varchar(50) default null, constraint codes_f_key foreign key(group) references $qualifier.code_group)"
  db2 insert into $qualifier.code values"('BUF','TEU','ENT','Business Fax')"
  db2 insert into $qualifier.code values"('BUP','TEU','ENT','Business Phone')"
  db2 insert into $qualifier.code values"('REP','TEU','PER','Residential Phone')"
  db2 insert into $qualifier.code values"('BPH','TEU','PER','Business Phone')"
  db2 insert into $qualifier.code values"('HFX','TEU','PER','Home Fax')"
  db2 insert into $qualifier.code values"('CEL','TEU','PER','Cellular')"
  db2 insert into $qualifier.code values"('BFX','TEU','PER','Business Fax')"
  db2 insert into $qualifier.code values"('ENG','LA' ,' '  ,'English')"
  db2 insert into $qualifier.code values"('FRE','LA' ,' '  ,'French')"
  db2 insert into $qualifier.code values"('USA','COU',' '  ,'United States of America')"
  db2 insert into $qualifier.code values"('CAN','COU',' '  ,'Canada')"
  db2 insert into $qualifier.code values"('ALB','REG','CAN','Alberta')"
  db2 insert into $qualifier.code values"('MAN','REG','CAN','Manitoba')"
  db2 insert into $qualifier.code values"('BC' ,'REG','CAN','British Columbia')"
  db2 insert into $qualifier.code values"('NFL','REG','CAN','Newfoundland')"
  db2 insert into $qualifier.code values"('NBR','REG','CAN','New Brunswick')"
  db2 insert into $qualifier.code values"('NWT','REG','CAN','NW Territories')"
  db2 insert into $qualifier.code values"('NSC','REG','CAN','Nova Scotia')"
  db2 insert into $qualifier.code values"('ONT','REG','CAN','Ontario')"
  db2 insert into $qualifier.code values"('PEI','REG','CAN','Prince Edward Island')"
  db2 insert into $qualifier.code values"('QUE','REG','CAN','Quebec')"
  db2 insert into $qualifier.code values"('SAS','REG','CAN','Saskatchewan')"
  db2 insert into $qualifier.code values"('YKN','REG','CAN','Yukon')"
  db2 insert into $qualifier.code values"('AL' ,'REG','USA','Alabama')"
  db2 insert into $qualifier.code values"('AK' ,'REG','USA','Alaska')"
  db2 insert into $qualifier.code values"('AR' ,'REG','USA','Arkansas')"
  db2 insert into $qualifier.code values"('NC' ,'REG','USA','North Carolina')"
  db2 insert into $qualifier.code values"('SC' ,'REG','USA','South Carolina')"
  db2 insert into $qualifier.code values"('VI' ,'REG','USA','Virgin Islands')"
  db2 insert into $qualifier.code values"('IL' ,'REG','USA','Illinois')"
  db2 insert into $qualifier.code values"('SD' ,'REG','USA','South Dakota')"
  db2 insert into $qualifier.code values"('ND' ,'REG','USA','North Dakota')"
  db2 insert into $qualifier.code values"('WV' ,'REG','USA','West Virginia')"
  db2 insert into $qualifier.code values"('OH' ,'REG','USA','Ohio')"
  db2 insert into $qualifier.code values"('FL' ,'REG','USA','Florida')"
  db2 insert into $qualifier.code values"('NY' ,'REG','USA','New York')"
  db2 insert into $qualifier.code values"('IN' ,'REG','USA','Indiana')"
  db2 insert into $qualifier.code values"('KY' ,'REG','USA','Kentucky')"
  db2 insert into $qualifier.code values"('WI' ,'REG','USA','Wisconsin')"
  db2 insert into $qualifier.code values"('UT' ,'REG','USA','Utah')"
  db2 insert into $qualifier.code values"('WY' ,'REG','USA','Wyoming')"
  db2 insert into $qualifier.code values"('CO' ,'REG','USA','Colorado')"
  db2 insert into $qualifier.code values"('AZ' ,'REG','USA','Arizona')"
  db2 insert into $qualifier.code values"('CA' ,'REG','USA','California')"
  db2 insert into $qualifier.code values"('NV' ,'REG','USA','Nevada')"
  db2 insert into $qualifier.code values"('ID' ,'REG','USA','Idaho')"
  db2 insert into $qualifier.code values"('MS' ,'REG','USA','Mississippi')"
  db2 insert into $qualifier.code values"('TX' ,'REG','USA','Texas')"
  db2 insert into $qualifier.code values"('NM' ,'REG','USA','New Mexico')"
  db2 insert into $qualifier.code values"('WA' ,'REG','USA','Washington')"
  db2 insert into $qualifier.code values"('OR' ,'REG','USA','Oregon')"
  db2 insert into $qualifier.code values"('NH' ,'REG','USA','New Hampshire')"
  db2 insert into $qualifier.code values"('MD' ,'REG','USA','Maryland')"
  db2 insert into $qualifier.code values"('VA' ,'REG','USA','Virginia')"
  db2 insert into $qualifier.code values"('RI' ,'REG','USA','Rhode Island')"
  db2 insert into $qualifier.code values"('DE' ,'REG','USA','Delaware')"
  db2 insert into $qualifier.code values"('NJ' ,'REG','USA','New Jersey')"
  db2 insert into $qualifier.code values"('MT' ,'REG','USA','Montana')"
  db2 insert into $qualifier.code values"('OK' ,'REG','USA','Oklahoma')"
  db2 insert into $qualifier.code values"('CT' ,'REG','USA','Conneticut')"
  db2 insert into $qualifier.code values"('GA' ,'REG','USA','Georgia')"
  db2 insert into $qualifier.code values"('GU' ,'REG','USA','Guam')"
  db2 insert into $qualifier.code values"('HI' ,'REG','USA','Hawaii')"
  db2 insert into $qualifier.code values"('IA' ,'REG','USA','Iowa')"
  db2 insert into $qualifier.code values"('KS' ,'REG','USA','Kansas')"
  db2 insert into $qualifier.code values"('LA' ,'REG','USA','Louisianna')"
  db2 insert into $qualifier.code values"('ME' ,'REG','USA','Maine')"
  db2 insert into $qualifier.code values"('MA' ,'REG','USA','Massachusetts')"
  db2 insert into $qualifier.code values"('MI' ,'REG','USA','Michigan')"
  db2 insert into $qualifier.code values"('MO' ,'REG','USA','Missouri')"
  db2 insert into $qualifier.code values"('PA' ,'REG','USA','Pennsylvania')"
  db2 insert into $qualifier.code values"('PR' ,'REG','USA','Puerto Rico')"
  db2 insert into $qualifier.code values"('TN' ,'REG','USA','Tennessee')"
  db2 insert into $qualifier.code values"('VT' ,'REG','USA','Vermont')"
  db2 insert into $qualifier.code values"('DC' ,'REG','USA','District of Columbia')"
  db2 insert into $qualifier.code values"('NE' ,'REG','USA','Nebraska')"
  db2 insert into $qualifier.code values"('MN' ,'REG','USA','Minnesota')"
  db2 insert into $qualifier.code values"('PRP','CST',' '  ,'Prospect')"
  db2 insert into $qualifier.code values"('ACT','CST',' '  ,'Active')"
  db2 insert into $qualifier.code values"('DMT','CST',' '  ,'Dormant')"
  db2 insert into $qualifier.code values"('FMR','CST',' '  ,'Former')"
  db2 insert into $qualifier.code values"('MAL','GEN',' '  ,'Male')"
  db2 insert into $qualifier.code values"('FEM','GEN',' '  ,'Female')"
  db2 insert into $qualifier.code values"('UKN','GEN',' '  ,'Unknown')"
  db2 insert into $qualifier.code values"('MAI','AU' ,'ENT','Mailing')"
  db2 insert into $qualifier.code values"('PPL','AU' ,'ENT','Principle')"
  db2 insert into $qualifier.code values"('HOM','AU' ,'PER','Home')"
  db2 insert into $qualifier.code values"('BUS','AU' ,'PER','Business')"
  db2 insert into $qualifier.code values"('VAC','AU' ,'PER','Vacation')"
  db2 insert into $qualifier.code values"('MAG','AU' ,'PER','Mailing')"
  db2 insert into $qualifier.code values"('MAD','NU' ,'PER','Maiden Name')"
  db2 insert into $qualifier.code values"('FOR','NU' ,'PER','Former Name')"
  db2 insert into $qualifier.code values"('LGL','NU' ,'PER','Legal Name')"
  db2 insert into $qualifier.code values"('NBI','NU' ,'PER','Name at Birth')"
  db2 insert into $qualifier.code values"('MLG','NU' ,'PER','Mailing Name')"
  db2 insert into $qualifier.code values"('LEG','NU' ,'ENT','Legal Name')"
  db2 insert into $qualifier.code values"('FOM','NU' ,'ENT','Former Name')"
  db2 insert into $qualifier.code values"('MNG','NU' ,'ENT','Mailing Name')"
  db2 insert into $qualifier.code values"('PRI','NU' ,'ENT','Primary Name')"
  db2 insert into $qualifier.code values"('HME','EAU','PER','Home')"
  db2 insert into $qualifier.code values"('BSN','EAU','PER','Business')"
  db2 insert into $qualifier.code values"('OTR','EAU','ENT','Other')"
  db2 insert into $qualifier.code values"('PRM','EAU','ENT','Primary')"
  db2 insert into $qualifier.code values"('MSS','TTL','PER'  ,'Ms.')"
  db2 insert into $qualifier.code values"('MIS','TTL','PER'  ,'Miss')"
  db2 insert into $qualifier.code values"('MR' ,'TTL','PER'  ,'Mr.')"
  db2 insert into $qualifier.code values"('MRS','TTL','PER'  ,'Mrs.')"
  db2 insert into $qualifier.code values"('DOC','TTL','PER'  ,'Doctor')"
  db2 insert into $qualifier.code values"('REV','TTL','PER'  ,'Reverend')"
  db2 insert into $qualifier.code values"('FTH','TTL','PER'  ,'Father')"

  db2 create table $qualifier.category_group"(id timestamp not null primary key,category char(5) not null,group char(5) not null, constraint category_f_key foreign key(category) references $qualifier.code_category, constraint group_f_key foreign key(group) references $qualifier.code_group)"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000002','CI' ,'LA')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000003','CI' ,'CST')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000005','CI' ,'GEN')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000007','CI' ,'TTL')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000009','CI' ,'NU')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000013','CON','EAU')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000014','CON','AU')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000015','CON','TEU')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000016','CON','COU')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000017','CON','REG')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000023','TEL','TEU')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000024','PI' ,'TTL')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000025','PI' ,'GEN')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000026','PI' ,'LA')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000029','PI' ,'CST')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000033','PN' ,'NU')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000034','PN' ,'TTL')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000036','BC' ,'GEN')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000037','BC' ,'CST')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000038','BC' ,'LA')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000039','BC' ,'TEU')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000047','ADI','AU')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000048','ADI','REG')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000049','ADI','COU')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000050','EAI','EAU')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000051','ENI','LA')"
  db2 insert into $qualifier.category_group values"('2000-01-01-01.01.01.000052','ENI','CST')"

  db2 grant all on $qualifier.code_category to public
  db2 grant all on $qualifier.code_group to public
  db2 grant all on $qualifier.code to public
  db2 grant all on $qualifier.category_group to public
  print ""
  print "Code Tables Created"
  print ""


  print ""
  print "Creating Enterprise Tables"
  print ""
  db2 drop table $qualifier.customer
  db2 drop table $qualifier.enterprise_info
  db2 drop table $qualifier.enterprise_name


  db2 create table $qualifier.customer"(id char(40) not null, synchKey timestamp not null, maintenanceFlag char(1) default null, status char(5) default null, type char(20) not null, add_col1 char(10) default null, add_col2 char(10) default null)"
  db2 alter table $qualifier.customer add constraint customer_p_key primary key"(id)"
  db2 alter table $qualifier.customer add constraint customer_f_key foreign key"(status)" references $qualifier.code

  db2 create table $qualifier.enterprise_info"(id char(40) not null, synchKey timestamp not null, customer_id char(40) not null, maintenanceFlag char(1) default null, start_date date default null, fiscal_year_end date default null, prefer_lang char(5) default null, add_col1 char(10) default null, add_col2 char(10) default null)"
  db2 alter table $qualifier.enterprise_info add constraint ent_info_p_key primary key"(id)"
  db2 alter table $qualifier.enterprise_info add constraint ent_info_f_key  foreign key"(customer_id)" references $qualifier.customer on delete cascade 
  db2 alter table $qualifier.enterprise_info add constraint ent_info_f_key1 foreign key"(prefer_lang)" references $qualifier.code 

  db2 create table $qualifier.enterprise_name"( id char(40) not null, synchKey timestamp not null, customer_id char(40) not null, maintenanceFlag char(1) default null, full_name char(35) default null,  usage char(5) default null, add_col1 char(10) default null, add_col2 char(10) default null)"
  db2 alter table $qualifier.enterprise_name add constraint ent_name_p_key primary key"(id)"
  db2 alter table $qualifier.enterprise_name add constraint ent_name_f_key  foreign key"(customer_id)" references $qualifier.customer on delete cascade 
  db2 alter table $qualifier.enterprise_name add constraint ent_name_f_key2 foreign key"(usage)" references $qualifier.code 

  db2 grant all on $qualifier.customer to public
  db2 grant all on $qualifier.enterprise_info to public
  db2 grant all on $qualifier.enterprise_name to public
  print ""
  print "Enterprise Tables Created"
  print ""


  print ""
  print "Creating ContactPoints Tables"
  print ""
  db2 -o- drop table $qualifier.postal_address
  db2 -o- drop table $qualifier.address_usage
  db2 -o- drop table $qualifier.phone_number
  db2 -o- drop table $qualifier.email_address


  db2 create table $qualifier.postal_address"(id char(30) not null, synchKey timestamp not null, customer_id char(40) not null, maintenanceFlag char(1) default null, city char(20) default null, country char(5) default null, address_lines varchar(80) default null, box_number char(12) default null, street_name char(30) default null, street_number char(12) default null, region char(5) default null, postal_code char(10) default null, add_col1 char(10) default null, add_col2 char(10) default null, address_line2 char(80) default null, address_line3 char(80) default null, TYPE char(6) default null, URL char(40) default null)"
  db2 alter table $qualifier.postal_address add constraint address_p_key primary key"(id)"
  db2 alter table $qualifier.postal_address add constraint address_f_key  foreign key"(customer_id)"  references $qualifier.customer on delete cascade
  db2 alter table $qualifier.postal_address add constraint address_f_key1 foreign key"(country)" references $qualifier.code
  db2 alter table $qualifier.postal_address add constraint address_f_key2 foreign key"(region)" references $qualifier.code

  db2 create table $qualifier.address_usage"(id char(30) not null, maintenanceFlag char(1) default null, usage char(5) not null, address_id char(40) not null) "
  db2 alter table $qualifier.address_usage add constraint usage_p_key primary key"(id)"
  db2 alter table $qualifier.address_usage add constraint usage_f_key  foreign key"(address_id)"  references $qualifier.postal_address on delete cascade
  db2 alter table $qualifier.address_usage add constraint usage_f_key1 foreign key"(usage)" references $qualifier.code

  db2 create table $qualifier.phone_number"(id char(30) not null, synchKey timestamp not null, customer_id char(40) not null, maintenanceFlag char(1) default null, country_code char(4) default null, in_country_pref char(4) default null, area_code char(4) default null, local_number char(8) default null, extension char(4) default null, usage char(5) default null, add_col1 char(10) default null, add_col2 char(10) default null)"
  db2 alter table $qualifier.phone_number add constraint phone_p_key primary key"(id)"
  db2 alter table $qualifier.phone_number add constraint phone_f_key foreign key"(customer_id)" references $qualifier.customer on delete cascade
  db2 alter table $qualifier.phone_number add constraint phone_f_key1 foreign key"(usage)" references $qualifier.code

  db2 create table $qualifier.email_address"(id char(30) not null, synchKey timestamp not null, customer_id char(40) not null, maintenanceFlag char(1) default null, user_name char(25) default null, domain_name char(25) default null, usage char(5) default null, add_col1 char(10) default null, add_col2 char(10) default null)"
  db2 alter table $qualifier.email_address add constraint email_p_key primary key"(id)"
  db2 alter table $qualifier.email_address add constraint email_f_key foreign key"(customer_id)" references $qualifier.customer on delete cascade
  db2 alter table $qualifier.email_address add constraint email_f_key1 foreign key"(usage)" references $qualifier.code

  db2 grant all on $qualifier.postal_address to public
  db2 grant all on $qualifier.address_usage to public
  db2 grant all on $qualifier.phone_number to public
  db2 grant all on $qualifier.email_address to public
  print ""
  print "ContactPoints Tables Created"
  print ""

  print ""
  print "Population Tables"
  print ""
  db2 insert into $qualifier.customer values"('987654', current timestamp, ' ', null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.enterprise_name values"(current timestamp, current timestamp, '987654', null, 'CallahoonAutoParts Incorporated', 'LEG', null, null)"
  db2 insert into $qualifier.enterprise_name values"(current timestamp, current timestamp, '987654', null, 'CallahoonAutoParts', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_info values"(current timestamp, current timestamp, '987654', null, '10/3/1990', '12/30/2000', 'ENG', null, null, 'mynameistommy', 'USD', 'CC', 'true', 'PartnerDiscountGroup1', 'PartnerPriceGroup1', 'COD', 'COD', 'SD')"
  db2 insert into $qualifier.postal_address values"('987654SoldTo', current timestamp, '987654', null, 'Auto City', 'USA', '123 Auto Parts Ln', null, null, null, 'MI', '12345', null, null, null, null, 'SoldTo', 'www.callahoonautoparts.com')"
  db2 insert into $qualifier.address_usage values"(current timestamp, null, 'PPL', '987654SoldTo')"
  db2 insert into $qualifier.postal_address values"('987654ShipTo', current timestamp, '987654', null, 'Auto City', 'USA', 'Warehouse 12B', null, null, null, 'MI', '12345', null, null, '123 Auto Parts Ln', null, 'ShipTo', 'www.callahoonautoparts.com')"
  db2 insert into $qualifier.address_usage values"(current timestamp, null, 'PPL', '987654ShipTo')"
  db2 insert into $qualifier.postal_address values"('987654BillTo', current timestamp, '987654', null, 'Headquarters', 'USA', '1000000 Millionnaire Dr.', null, null, null, 'CA', '99999', null, null, null, null, 'BillTo', 'www.callahoonautoparts.com')"
  db2 insert into $qualifier.address_usage values"(current timestamp, null, 'PPL', '987654BillTo')"
  db2 insert into $qualifier.email_address values"(current timestamp, current timestamp, '987654', null, 'tboy', 'callahoonparts.com', 'PRM', null, null)"
  db2 insert into $qualifier.phone_number values"(current timestamp, current timestamp, '987654', null, 'null', 'null', '441', '1113333', '5555', 'BUP', null, null)"
  db2 insert into $qualifier.phone_number values"(current timestamp, current timestamp, '987654', null, 'null', 'null', '448', '4446666', 'null', 'BUF', null, null)"

  db2 insert into $qualifier.customer values"('123456', current timestamp, ' ', null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.enterprise_name values"(current timestamp, current timestamp, '123456', null, 'MyAutoPartsForU Incorporated', 'LEG', null, null)"
  db2 insert into $qualifier.enterprise_name values"(current timestamp, current timestamp, '123456', null, 'MyAutoPartsForU', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_info values"(current timestamp, current timestamp, '123456', null, '11/2/1978', '7/30/2001', 'ENG', null, null, 'mynameisbetsy', 'USD', 'CP', 'true', 'PartnerDiscountGroup2', 'PartnerPriceGroup1', 'COD', 'COD', 'WHS')"
  db2 insert into $qualifier.postal_address values"('123456SoldTo', current timestamp, '123456', null, 'Caliper', 'USA', '3535 Alternator Rd', null, null, null, 'WI', '98765', null, null, null, null, 'SoldTo', 'www.myautoparts4u.com')"
  db2 insert into $qualifier.address_usage values"(current timestamp, null, 'PPL', '123456SoldTo')"
  db2 insert into $qualifier.postal_address values"('123456ShipTo', current timestamp, '123456', null, 'Freepart', 'USA', 'Dock 3B', null, null, null, 'SC', '82282', null, null, '828 Radiator Rd', null, 'ShipTo', 'www.myautoparts4u.com')"
  db2 insert into $qualifier.address_usage values"(current timestamp, null, 'PPL', '123456ShipTo')"
  db2 insert into $qualifier.postal_address values"('123456BillTo', current timestamp, '123456', null, 'Caliper', 'USA', '3535 Alternator Rd', null, null, null, 'NC', '98765', null, null, null, null, 'BillTo', 'www.myautoparts4u.com')"
  db2 insert into $qualifier.address_usage values"(current timestamp, null, 'PPL', '123456BillTo')"
  db2 insert into $qualifier.email_address values"(current timestamp, current timestamp, '123456', null, 'betsy', 'myautoparts4u.com', 'BSN', null, null)"
  db2 insert into $qualifier.phone_number values"(current timestamp, current timestamp, '123456', null, 'null', 'null', '499', '4886233', '4444', 'BUP', null, null)"
  db2 insert into $qualifier.phone_number values"(current timestamp, current timestamp, '123456', null, 'null', 'null', '499', '4889966', 'null', 'BUF', null, null)"

  db2 insert into $qualifier.customer values"('456789', current timestamp, ' ', null, 'ENTERPRISE', null, null)"
  db2 insert into $qualifier.enterprise_name values"(current timestamp, current timestamp, '456789', null, 'NAPAL Incorporated', 'LEG', null, null)"
  db2 insert into $qualifier.enterprise_name values"(current timestamp, current timestamp, '456789', null, 'NAPAL', 'PRI', null, null)"
  db2 insert into $qualifier.enterprise_info values"(current timestamp, current timestamp, '456789', null, '7/8/1965', '5/1/2001', 'ENG', null, null, 'napalisthebest', 'CAD', 'ST', 'true', 'PartnerDiscountGroup2', 'PartnerPriceGroup2', 'CASH', 'COD', 'FOB')"
  db2 insert into $qualifier.postal_address values"('456789SoldTo', current timestamp, '456789', null, 'Hydraulics', 'USA', '493 Auto King Pl', null, null, null, 'IL', '53694', null, null, null, null, 'SoldTo', 'www.napalonline.com')"
  db2 insert into $qualifier.address_usage values"(current timestamp, null, 'PPL', '456789SoldTo')"
  db2 insert into $qualifier.postal_address values"('456789ShipTo', current timestamp, '456789', null, 'Hydraulics', 'USA', 'Dock 13E', null, null, null, 'IL', '53694', null, null, 'Building 85', '493 Auto King Pl', 'ShipTo', 'www.napalonline.com')"
  db2 insert into $qualifier.address_usage values"(current timestamp, null, 'PPL', '456789ShipTo')"
  db2 insert into $qualifier.postal_address values"('456789BillTo', current timestamp, '456789', null, 'Hydraulics', 'USA', '493 Auto King Pl', null, null, null, 'IL', '53694', null, null, null, null, 'BillTo', 'www.napalonline.com')"
  db2 insert into $qualifier.address_usage values"(current timestamp, null, 'PPL', '456789BillTo')"
  db2 insert into $qualifier.email_address values"(current timestamp, current timestamp, '456789', null, 'contact', 'napal.com', 'PRM', null, null)"
  db2 insert into $qualifier.phone_number values"(current timestamp, current timestamp, '456789', null, 'null', 'null', '213', '2556985', 'null', 'BUP', null, null)"
  print ""
  print "Tables Populated"
  print ""

} #End CreateCPData

function CreatePCData
{
  print ""
  print "Creating ProductCatalog Tables"
  print ""
  db2 -o- drop table $qualifier.Category
  db2 -o- drop table $qualifier.CategoryLocale
  db2 -o- drop table $qualifier.ComPoint
  db2 -o- drop table $qualifier.ComPointLocale
  db2 -o- drop table $qualifier.ComPointData
  db2 -o- drop table $qualifier.ComPointDataLocale
  db2 -o- drop table $qualifier.Product
  db2 -o- drop table $qualifier.ProductLocale
  db2 -o- drop table $qualifier.Cat_CP_Link
  db2 -o- drop table $qualifier.Cat_PR_Link
  db2 -o- drop table $qualifier.Dyna_Text

  db2 create table $qualifier.Category"(ProductCategoryID char(25) NOT NULL,Sequence decimal(11,3),MainSynchKey timestamp NOT NUll,MaintenanceFlag char(1),HasSubcategories char(5) NOT NULL,HasProducts char(5) NOT NULL,ParentCategoryID char(25))"
  db2 create table $qualifier.CategoryLocale"(ID char(30) NOT NULL,SynchKey timestamp NOT NULL,ProductCategoryID char(25) NOT NULL,Name Varchar(50) NOT NULL, Locale char(5) NOT NULL)"
  db2 create table $qualifier.ComPoint"(MainSynchKey timestamp NOT NUll,ComparisonPointID char(25) NOT NULL,MaintenanceFlag char(1))"
  db2 create table $qualifier.ComPointLocale"(ID char(30) NOT NULL,SynchKey timestamp NOT NULL,ComparisonPointID char(25) NOT NULL,Description long Varchar, Locale char(5) NOT NULL,Name Varchar(50) NOT NULL)"
  db2 create table $qualifier.ComPointData"(MainSynchKey timestamp NOT NUll,CPDataID char(25) NOT NULL,MaintenanceFlag char(1),ProductID char(25) NOT NULL,ComparisonPointID char(25) NOT NULL)"
  db2 create table $qualifier.ComPointDataLocale"(ID char(30) NOT NULL,SynchKey timestamp NOT NULL,CPDataID char(25) NOT NULL,ShortDescription Varchar(100) NOT NULL, Locale char(5) NOT NULL,LongDescription long Varchar NOT NULL,LongSameAsShort char(5) NOT NULL)"
  db2 create table $qualifier.Product"(MainSynchKey timestamp NOT NUll,ProductID char(25) NOT NULL,MaintenanceFlag char(1),ThumbNailImage varchar(100),DisplayToPublic char(5) NOT NULL,AvailabilityDate date,ShippingCode char(25))"
  db2 create table $qualifier.ProductLocale"(ID char(30) NOT NULL,SynchKey timestamp NOT NUll,ProductID char(25) NOT NULL,Name varchar(50) not null,Locale char(5) NOT NULL,Description long Varchar,SlideURL varchar(100),RelatedInfoURL varchar(100),FullSizeImage varchar(100),OrderUnitsOfMeas varchar(100))"
  db2 create table $qualifier.Cat_CP_Link"(ID char(30) NOT NULL,ProductCategoryID char(25) NOT NULL,ComparisonPointID char(25) NOT NULL,Sequence decimal(11,3))"
  db2 create table $qualifier.Cat_PR_Link"(ID char(30) NOT NULL,ProductID char(25) NOT NULL,ProductCategoryID char(25) NOT NULL,Sequence decimal(11,3))"
  db2 create table $qualifier.Dyna_Text"(ID char(30) NOT NULL,TAG char(30) NOT NULL,LOCALE varchar(5) NOT NULL, VALUE varchar(30) NOT NULL)"

  # *
  # * Creating the primary keys and foreign keys
  # *

  db2 alter table $qualifier.category add primary key"(productcategoryid)"
  db2 alter table $qualifier.category add foreign key"(parentcategoryid)" references $qualifier.category

  db2 alter table $qualifier.categorylocale add primary key"(id)"
  db2 alter table $qualifier.categorylocale add foreign key"(productcategoryid)" references $qualifier.category

  db2 alter table $qualifier.Product add primary key"(productid)"

  db2 alter table $qualifier.Productlocale add primary key"(id)"
  db2 alter table $qualifier.Productlocale add foreign key"(productid)" references $qualifier.Product

  db2 alter table $qualifier.compoint add primary key"(comparisonpointid)"

  db2 alter table $qualifier.compointlocale add primary key"(id)"
  db2 alter table $qualifier.compointlocale add foreign key"(comparisonpointid)" references $qualifier.compoint

  db2 alter table $qualifier.compointdata add primary key"(cpdataid)"
  db2 alter table $qualifier.compointdata add foreign key"(productid)" references $qualifier.Product
  db2 alter table $qualifier.compointdata add foreign key"(comparisonpointid)" references $qualifier.compoint

  db2 alter table $qualifier.compointdatalocale add primary key"(id)"
  db2 alter table $qualifier.compointdatalocale add foreign key"(cpdataid)" references $qualifier.compointdata

  db2 alter table $qualifier.Dyna_Text add primary key"(id)"

  db2 alter table $qualifier.Cat_CP_Link add primary key"(id)"
  db2 alter table $qualifier.Cat_CP_Link add foreign key"(productcategoryid)" references $qualifier.category
  db2 alter table $qualifier.Cat_CP_Link add foreign key"(comparisonpointid)" references $qualifier.compoint

  db2 alter table $qualifier.Cat_PR_Link add primary key"(id)"
  db2 alter table $qualifier.Cat_PR_Link add foreign key"(productcategoryid)" references $qualifier.category
  db2 alter table $qualifier.Cat_PR_Link add foreign key"(productid)" references $qualifier.product
  print ""
  print "ProductCatalog Tables Created"
  print ""

  # * Category table
  db2 insert into $qualifier.category values"('LBNW', float(1.0), current timestamp, ' ', 'true', 'false', null)"
  db2 insert into $qualifier.categoryLocale values"('LBNWen_US', current timestamp, 'LBNW', 'Lights, Bulbs, and Wipers', 'en_US')"

  db2 insert into $qualifier.category values"('LIGHTS', float(1.0), current timestamp, ' ', 'false', 'true', 'LBNW')"
  db2 insert into $qualifier.categoryLocale values"('LIGHTSen_US', current timestamp, 'LIGHTS', 'Headlights And Bulbs', 'en_US')"

  db2 insert into $qualifier.category values"('WIPERS', float(2.0), current timestamp, ' ', 'false', 'true', 'LBNW')"
  db2 insert into $qualifier.categoryLocale values"('WIPERSen_US', current timestamp, 'WIPERS', 'Wiper Blades', 'en_US')"

  db2 insert into $qualifier.category values"('BRAKES', float(2.0), current timestamp, ' ', 'true', 'false', null)"
  db2 insert into $qualifier.categoryLocale values"('BRAKESen_US', current timestamp, 'BRAKES', 'Brakes Components', 'en_US')"

  db2 insert into $qualifier.category values"('BRPADS', float(1.0), current timestamp, ' ', 'false', 'true', 'BRAKES')"
  db2 insert into $qualifier.categoryLocale values"('BRPADSen_US', current timestamp, 'BRPADS', 'Brake Pads', 'en_US')"

  db2 insert into $qualifier.category values"('ELEC', float(3.0), current timestamp, ' ', 'true', 'false', null)"
  db2 insert into $qualifier.categoryLocale values"('ELECen_US', current timestamp, 'ELEC', 'Electrical Components', 'en_US')"

  db2 insert into $qualifier.category values"('BATTERIES', float(1.0), current timestamp, ' ', 'false', 'true', 'ELEC')"
  db2 insert into $qualifier.categoryLocale values"('BATTERIESen_US', current timestamp, 'BATTERIES', 'Batteries', 'en_US')"

  print "Category Tables Populated"

  # * Product table
  db2 insert into $qualifier.product values"(current timestamp, 'SFWIP00001', ' ', 'wiper.jpg', 'true', null, '2222')"
  db2 insert into $qualifier.productLocale values"('SFWIP00001en_US', current timestamp, 'SFWIP00001', 'Fits All Wiper Blade', 'en_US', 'Wiper blade which installs easily on most vehicles.', null, null, null, 'Pc')"
  db2 insert into $qualifier.Cat_PR_Link values"('SFWIP00001WIPERS', 'SFWIP00001', 'WIPERS', float(1.0))"

  db2 insert into $qualifier.product values"(current timestamp, 'SFWIP00002', ' ', 'wiper.jpg', 'true', null, '2222')"
  db2 insert into $qualifier.productLocale values"('SFWIP00002en_US', current timestamp, 'SFWIP00002', 'High Powered Wiper Blade', 'en_US', 'Professional wiper blade to help clear windshields in the toughest conditions.', null, null, null, 'Pc')"
  db2 insert into $qualifier.Cat_PR_Link values"('SFWIP00002WIPERS', 'SFWIP00002', 'WIPERS', float(2.0))"

  db2 insert into $qualifier.product values"(current timestamp, 'SFLGT00001', ' ', 'headlight.jpg', 'true', null, '2222')"
  db2 insert into $qualifier.productLocale values"('SFLGT00001en_US', current timestamp, 'SFLGT00001', 'Rear Signal Bulb', 'en_US', 'Rear signal replacement bulb for left or right rear signal light.', null, null, null, 'Pc')"
  db2 insert into $qualifier.Cat_PR_Link values"('SFLGT00001LIGHTS', 'SFLGT00001', 'LIGHTS', float(1.0))"

  db2 insert into $qualifier.product values"(current timestamp, 'SFLGT00002', ' ', 'headlight.jpg', 'true', null, '2222')"
  db2 insert into $qualifier.productLocale values"('SFLGT00002en_US', current timestamp, 'SFLGT00002', 'Front headlight - high beam', 'en_US', 'Front high beam headlight replacement bulb for front left or right high beam headlight.  Guaranteed for up to 8000 hours of use.', null, null, null, 'Pc')"
  db2 insert into $qualifier.Cat_PR_Link values"('SFLGT00002LIGHTS', 'SFLGT00002', 'LIGHTS', float(2.0))"

  db2 insert into $qualifier.product values"(current timestamp, 'SFLGT00003', ' ', 'headlight.jpg', 'true', null, '2222')"
  db2 insert into $qualifier.productLocale values"('SFLGT00003en_US', current timestamp, 'SFLGT00003', 'Front headlight - low beam - long-life', 'en_US', 'Front low beam headlight to replace front left or right low beam headlight.  Long-life bulb for guaranteed use of 13000 hours.', null, null, null, 'Pc')"
  db2 insert into $qualifier.Cat_PR_Link values"('SFLGT00003LIGHTS', 'SFLGT00003', 'LIGHTS', float(3.0))"

  db2 insert into $qualifier.product values"(current timestamp, 'SFBPD00001', ' ', 'brakepad.jpg', 'true', null, '2222')"
  db2 insert into $qualifier.productLocale values"('SFBPD00001en_US', current timestamp, 'SFBPD00001', 'Brake pads - front', 'en_US', 'Front brake pads with StopForSure technology.  Five year warranty.', null, null, null, 'Pc')"
  db2 insert into $qualifier.Cat_PR_Link values"('SFBPD00001BRPADS', 'SFBPD00001', 'BRPADS', float(1.0))"

  db2 insert into $qualifier.product values"(current timestamp, 'SFBPD00002', ' ', 'brakepad.jpg', 'true', null, '2222')"
  db2 insert into $qualifier.productLocale values"('SFBPD00002en_US', current timestamp, 'SFBPD00002', 'Brake pads - rear', 'en_US', 'Rear brake pads with StopForSure technology.  Five year warranty.', null, null, null, 'Pc')"
  db2 insert into $qualifier.Cat_PR_Link values"('SFBPD00002BRPADS', 'SFBPD00002', 'BRPADS', float(2.0))"

  db2 insert into $qualifier.product values"(current timestamp, 'SFBTY00001', ' ', 'battery.jpg', 'true', '8/14/2000', '2222')"
  db2 insert into $qualifier.productLocale values"('SFBTY00001en_US', current timestamp, 'SFBTY00001', 'Battery - The King', 'en_US', 'The King battery will keep your car running hours and hours.  Amazing twenty year warranty.', null, 'www.superbatteries.com', null, 'Pc')"
  db2 insert into $qualifier.Cat_PR_Link values"('SFBTY00001BATTERIES', 'SFBTY00001', 'BATTERIES', float(1.0))"

  db2 insert into $qualifier.product values"(current timestamp, 'SFBTY00002', ' ', 'battery.jpg', 'true', '2/25/1999', '2222')"
  db2 insert into $qualifier.productLocale values"('SFBTY00002en_US', current timestamp, 'SFBTY00002', 'Battery - The Warrior', 'en_US', 'The Warrior battery is almost as tough as The King, and is a little less expensive.  Ten year warranty.', null, 'www.carbatteries.com', null, 'Pc')"
  db2 insert into $qualifier.Cat_PR_Link values"('SFBTY00002BATTERIES', 'SFBTY00002', 'BATTERIES', float(2.0))"
  print""
  print "Product Tables Populated"
  print ""
} #End CreatePCData

#*****************
#Shell Starts Here
#*****************

print ""
print "Enter a CustomerProfile database name:"
read CP_DB
print ""
print ""
print "Enter a ProductCatalogue database name:"
read PC_DB
print ""

if [[ $# = 0 ]]
then
{
  db2 -o- drop database $CP_DB
  db2 create database $CP_DB
  db2 -o- drop database $PC_DB
  db2 create database $PC_DB
  DirectConnectWithCurrentUserid
}
elif [[ $# = 1 ]]
then
{
  db2 -o- drop database $CP_DB
  db2 create database $CP_DB
  db2 -o- drop database $PC_DB
  db2 create database $PC_DB
  DirectConnectWithqualifier1 $1
}
elif [[ $# = 2 ]]
then
{
  db2 -o- drop database $CP_DB
  db2 create database $CP_DB
  db2 -o- drop database $PC_DB
  db2 create database $PC_DB
  ConnectWithParWithUserid $1 $2
elif [[ $# = 3 ]]
then
{
  db2 -o- drop database $CP_DB
  db2 create database $CP_DB
  db2 -o- drop database $PC_DB
  db2 create database $PC_DB
  ConnectWithParWithqualifier2 $1 $2 $3
elif [[ $# > 3 ]]
then ErrorMessage
fi