#!/bin/ksh

# **************************************************************************
# *
# * File:  productCatalogDB.sh
# *
# * This file is for creating tables for ProductCatalog AC
# *
# * Updated: November 30th, 2000
# *
# **************************************************************************
USAGE="\nUsage: productCatalogDB.sh database [userid password] [qualifier]"
qualifier=$1

function ErrorMessage
{
  print "$USEAGE"
}

function DirectConnectWithCurrentUserid
{
  db2 connect to $1
  qualifier=$USER
  CreateTables
}

function DirectConnectWithQualifier1
{
  db2 connect to $1
  qualifier=$2
  CreateTables
}

function ConnectWithParWithUserid
{
  db2 connect to $1 user $2 using $3
  qualifier=$2
  CreateTables
}

function ConnectWithParWithQualifier2
{
  db2 connect to $1 user $2 using $3
  qualifier=$4
  CreateTables
}

function CreateTables
{
  db2 drop table $qualifier.Category
  db2 drop table $qualifier.CategoryLocale
  db2 drop table $qualifier.ComPoint
  db2 drop table $qualifier.ComPointLocale
  db2 drop table $qualifier.ComPointData
  db2 drop table $qualifier.ComPointDataLocale
  db2 drop table $qualifier.Product
  db2 drop table $qualifier.ProductLocale
  db2 drop table $qualifier.Cat_CP_Link
  db2 drop table $qualifier.Cat_PR_Link
  db2 drop table $qualifier.Dyna_Text

  db2 create table $qualifier.Category"(ProductCategoryID char(25) NOT NULL,Sequence decimal(11,3),MainSynchKey timestamp NOT NUll,MaintenanceFlag char(1),HasSubcategories char(5) NOT NULL,HasProducts char(5) NOT NULL,ParentCategoryID char(25))"
  db2 create table $qualifier.CategoryLocale"(ID char(30) NOT NULL,SynchKey timestamp NOT NULL,ProductCategoryID char(25) NOT NULL,Name Varchar(50) NOT NULL, Locale char(5) NOT NULL)"
  db2 create table $qualifier.ComPoint"(MainSynchKey timestamp NOT NUll,ComparisonPointID char(25) NOT NULL,MaintenanceFlag char(1))"
  db2 create table $qualifier.ComPointLocale"(ID char(30) NOT NULL,SynchKey timestamp NOT NULL,ComparisonPointID char(25) NOT NULL,Description long Varchar, Locale char(5) NOT NULL,Name Varchar(50) NOT NULL)"
  db2 create table $qualifier.ComPointData"(MainSynchKey timestamp NOT NUll,CPDataID char(25) NOT NULL,MaintenanceFlag char(1),ProductID char(25) NOT NULL,ComparisonPointID char(25) NOT NULL)"
  db2 create table $qualifier.ComPointDataLocale"(ID char(30) NOT NULL,SynchKey timestamp NOT NULL,CPDataID char(25) NOT NULL,ShortDescription Varchar(100) NOT NULL, Locale char(5) NOT NULL,LongDescription long Varchar,LongSameAsShort char(5) NOT NULL)"
  db2 create table $qualifier.Product"(MainSynchKey timestamp NOT NUll,ProductID char(25) NOT NULL,MaintenanceFlag char(1),ThumbNailImage varchar(100),DisplayToPublic char(5) NOT NULL,AvailabilityDate date,ShippingCode char(25))"
  db2 create table $qualifier.ProductLocale"(ID char(30) NOT NULL,SynchKey timestamp NOT NUll,ProductID char(25) NOT NULL,Name varchar(50) not null,Locale char(5) NOT NULL,Description long Varchar,SlideURL varchar(100),RelatedInfoURL varchar(100),FullSizeImage varchar(100),OrderUnitsOfMeas varchar(100))"
  db2 create table $qualifier.Cat_CP_Link"(ID char(30) NOT NULL,ProductCategoryID char(25) NOT NULL,ComparisonPointID char(25) NOT NULL,Sequence decimal(11,3))"
  db2 create table $qualifier.Cat_PR_Link"(ID char(30) NOT NULL,ProductID char(25) NOT NULL,ProductCategoryID char(25) NOT NULL,Sequence decimal(11,3))"
  db2 create table $qualifier.Dyna_Text"(ID char(30) NOT NULL,TAG char(30) NOT NULL,LOCALE varchar(5) NOT NULL, VALUE varchar(30) NOT NULL)"

  print ""
  print "Creating the primary keys and foreign keys"
  print ""

  db2 alter table $qualifier.category add primary key"(productcategoryid)"
  db2 alter table $qualifier.category add foreign key"(parentcategoryid)" references $qualifier.category

  db2 alter table $qualifier.categorylocale add primary key"(id)"
  db2 alter table $qualifier.categorylocale add foreign key"(productcategoryid)" references $qualifier.category

  db2 alter table $qualifier.Product add primary key"(productid)"

  db2 alter table $qualifier.Productlocale add primary key"(id)"
  db2 alter table $qualifier.Productlocale add foreign key"(productid)" references $qualifier.Product

  db2 alter table $qualifier.compoint add primary key"(comparisonpointid)"

  db2 alter table $qualifier.compointlocale add primary key"(id)"
  db2 alter table $qualifier.compointlocale add foreign key"(comparisonpointid)" references $qualifier.compoint

  db2 alter table $qualifier.compointdata add primary key"(cpdataid)"
  db2 alter table $qualifier.compointdata add foreign key"(productid)" references $qualifier.Product
  db2 alter table $qualifier.compointdata add foreign key"(comparisonpointid)" references $qualifier.compoint

  db2 alter table $qualifier.compointdatalocale add primary key"(id)"
  db2 alter table $qualifier.compointdatalocale add foreign key"(cpdataid)" references $qualifier.compointdata

  db2 alter table $qualifier.Dyna_Text add primary key"(id)"

  db2 alter table $qualifier.Cat_CP_Link add primary key"(id)"
  db2 alter table $qualifier.Cat_CP_Link add foreign key"(productcategoryid)" references $qualifier.category
  db2 alter table $qualifier.Cat_CP_Link add foreign key"(comparisonpointid)" references $qualifier.compoint

  db2 alter table $qualifier.Cat_PR_Link add primary key"(id)"
  db2 alter table $qualifier.Cat_PR_Link add foreign key"(productcategoryid)" references $qualifier.category
  db2 alter table $qualifier.Cat_PR_Link add foreign key"(productid)" references $qualifier.product
}

# *
# * Following block is for connecting to database and setting qualifier depending 
# * on number of parameters.
# *

if [[ $# = 0 ]]
then ErrorMessage
elif [[ $# = 1 ]]
then DirectConnectWithCurrentUserid $1
elif [[ $# = 2 ]]
then DirectConnectWithQualifier1 $1 $2
elif [[ $# = 3 ]]
then ConnectWithParWithUserid $1 $2 $3
elif [[ $# = 4 ]]
then ConnectWithParWithQualifier2 $1 $2 $3 $4
elif [[ $# > 4 ]]
then ErrorMessage
fi

db2 grant connect on database to public
db2 connect reset