/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Properties;

public class SocketFetcher
implements Runnable {
    private Socket socket;
    private String host;
    private int port;
    private Properties props;
    private String prefix;
    private int cto;
    private IOException exception;
    private boolean aborted = false;
    private boolean done = false;

    private SocketFetcher(String host, int port2, Properties props, String prefix, int cto) throws IOException {
        this.host = host;
        this.port = port2;
        this.props = props;
        this.prefix = prefix;
        this.cto = cto;
    }

    public static Socket getSocket(String host, int port2, Properties props, String prefix) throws IOException {
        if (prefix == null) {
            prefix = "socket";
        }
        if (props == null) {
            props = new Properties();
        }
        String s = props.getProperty(prefix + ".connectiontimeout", null);
        int cto = -1;
        if (s != null) {
            try {
                cto = Integer.parseInt(s);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if (cto > 0) {
            SocketFetcher sf = new SocketFetcher(host, port2, props, prefix, cto);
            try {
                Thread t = new Thread((Runnable)sf, "Connection thread for host " + host);
                t.start();
            }
            catch (Exception ex) {
                return SocketFetcher.getSocket0(host, port2, props, prefix);
            }
            return sf.getSocket();
        }
        return SocketFetcher.getSocket0(host, port2, props, prefix);
    }

    private static Socket getSocket0(String host, int port2, Properties props, String prefix) throws IOException {
        Socket socket = null;
        String sfClass = props.getProperty(prefix + ".socketFactory.class", null);
        String timeout = props.getProperty(prefix + ".timeout", null);
        if (sfClass == null || sfClass.length() <= 0) {
            socket = new Socket(host, port2);
        } else {
            String fallback = props.getProperty(prefix + ".socketFactory.fallback", null);
            boolean fb = fallback == null || !fallback.equalsIgnoreCase("false");
            String sfPortStr = props.getProperty(prefix + ".socketFactory.port", null);
            int sfPort = -1;
            if (sfPortStr != null) {
                try {
                    sfPort = Integer.parseInt(sfPortStr);
                }
                catch (NumberFormatException nfex) {
                    // empty catch block
                }
            }
            try {
                Class<?> clsSockFact = Class.forName(sfClass);
                Method mthGetDefault = clsSockFact.getMethod("getDefault", new Class[0]);
                Object o = mthGetDefault.invoke(new Object(), new Object[0]);
                Class[] mthArgs = new Class[]{String.class, Integer.TYPE};
                Method mthCreateSocket = clsSockFact.getMethod("createSocket", mthArgs);
                Integer portInt = new Integer(sfPort != -1 ? sfPort : port2);
                Object[] crSockArgs = new Object[]{host, portInt};
                socket = (Socket)mthCreateSocket.invoke(o, crSockArgs);
            }
            catch (Exception ex) {
                Throwable t;
                if (fb) {
                    socket = new Socket(host, port2);
                }
                if (ex instanceof InvocationTargetException && (t = ((InvocationTargetException)ex).getTargetException()) instanceof Exception) {
                    ex = (Exception)t;
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                throw new IOException("Couldn't connect using \"" + sfClass + "\" socket factory to host, port: " + host + ", " + sfPort + "; Exception: " + ex);
            }
        }
        int to = -1;
        if (timeout != null) {
            try {
                to = Integer.parseInt(timeout);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if (to >= 0) {
            socket.setSoTimeout(to);
        }
        return socket;
    }

    private synchronized Socket getSocket() throws IOException {
        if (!this.done) {
            try {
                long now = System.currentTimeMillis();
                long deadline = now + (long)this.cto;
                while (now < deadline) {
                    this.wait(deadline - now);
                    if (!this.done) {
                        now = System.currentTimeMillis();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ex) {
                this.exception = new InterruptedIOException(ex.toString());
            }
        }
        if (this.exception != null) {
            this.aborted = true;
            throw this.exception;
        }
        if (this.socket == null) {
            this.aborted = true;
            throw new ConnectException("connection to " + this.host + " timed out");
        }
        Socket s = this.socket;
        this.socket = null;
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Socket s = SocketFetcher.getSocket0(this.host, this.port, this.props, this.prefix);
            SocketFetcher socketFetcher = this;
            synchronized (socketFetcher) {
                if (this.aborted) {
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {}
                } else {
                    this.socket = s;
                }
                this.done = true;
                this.notify();
            }
        }
        catch (IOException ex) {
            SocketFetcher socketFetcher = this;
            synchronized (socketFetcher) {
                this.exception = ex;
                this.done = true;
                this.notify();
            }
        }
    }

    protected synchronized void finalize() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }
}

