/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util;

import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.XMLString;
import com.ibm.xml.xlxp.scan.util.XMLStringBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;

public class ParsedEntityStream
extends InputStream {
    private final XMLStringBuffer fStringBuffer;
    private final XMLString fContent;
    private DataBuffer fDataBuffer;
    private DataBuffer fLastBuffer;
    private int fDataOffset;
    private int fDataLength;
    private int fLastOffset;

    public ParsedEntityStream(XMLStringBuffer xMLStringBuffer) {
        this.fStringBuffer = xMLStringBuffer;
        this.fContent = new XMLString();
    }

    public XMLString skippedContent() {
        return this.fContent;
    }

    public void writeTo(Writer writer) throws IOException {
        int n;
        char[][] cArrayArray = new char[1][];
        int[] nArray = new int[1];
        for (n = 8; n < this.fContent.length; n <<= 1) {
        }
        cArrayArray[0] = new char[n];
        this.fContent.getChars(cArrayArray, nArray);
        writer.write(cArrayArray[0], 0, nArray[0]);
    }

    public String toString() {
        return this.fContent.toString();
    }

    private void prepareForReading() {
        if ((this.fContent.flags & 4) != 0) {
            int n = this.fStringBuffer.getOffset();
            this.fStringBuffer.appendXMLString(this.fContent);
            this.fStringBuffer.setStringValues(n, this.fStringBuffer.getOffset(), this.fContent);
        }
        this.fDataBuffer = this.fContent.firstBuffer;
        this.fDataLength = this.fContent.length;
        this.fDataOffset = this.fContent.startOffset;
        if (this.fContent.bytes != null) {
            this.fLastBuffer = this.fDataBuffer;
            this.fLastOffset = this.fContent.endOffset;
        } else {
            this.fLastBuffer = this.fContent.lastBuffer;
            this.fLastOffset = this.fDataBuffer.endOffset;
        }
    }

    public int available() {
        if (this.fDataBuffer == null) {
            this.prepareForReading();
        }
        return this.fDataLength;
    }

    public int read() {
        if (this.fDataBuffer == null) {
            this.prepareForReading();
        }
        while (true) {
            if (this.fDataOffset < this.fLastOffset) {
                --this.fDataLength;
                return this.fDataBuffer.bytes[this.fDataOffset++] & 0xFF;
            }
            if (this.fDataLength <= 0) break;
            this.fDataBuffer = this.fDataBuffer.next;
            this.fDataOffset = this.fDataBuffer.startOffset;
            if (this.fDataBuffer == this.fLastBuffer) {
                this.fLastOffset = this.fContent.endOffset;
                continue;
            }
            this.fLastOffset = this.fDataBuffer.endOffset;
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) {
        int n3 = 0;
        if (this.fDataBuffer == null) {
            this.prepareForReading();
        }
        while (this.fDataLength > 0) {
            int n4 = this.fLastOffset - this.fDataOffset;
            if (n4 > n2) {
                n4 = n2;
            }
            System.arraycopy(this.fDataBuffer.bytes, this.fDataOffset, byArray, n, n4);
            this.fDataOffset += n4;
            this.fDataLength -= n4;
            n3 += n4;
            if (n4 < n2 && this.fDataLength > 0) {
                n += n4;
                n2 -= n4;
                this.fDataBuffer = this.fDataBuffer.next;
                this.fDataOffset = this.fDataBuffer.startOffset;
                if (this.fDataBuffer == this.fLastBuffer) {
                    this.fLastOffset = this.fContent.endOffset;
                    continue;
                }
                this.fLastOffset = this.fDataBuffer.endOffset;
                continue;
            }
            return n3;
        }
        return n3 > 0 ? n3 : -1;
    }
}

