/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import java.net.URI;

public class WSAHelper {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSAHelper.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);

    private WSAHelper() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "WSAHelper");
        }
    }

    public static String getEndpointAddress(EndpointReference endpointReference) {
        URI uRI;
        AttributedURI attributedURI;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getEndpointAddress", endpointReference);
        }
        if (endpointReference != null && (attributedURI = endpointReference.getAddress()) != null && (uRI = attributedURI.getURI()) != null) {
            String string = uRI.toString();
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getEndpointAddress", string);
            }
            return string;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getEndpointAddress");
        }
        return "";
    }

    public static String getAction(AttributedURI attributedURI) {
        URI uRI;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getAction", attributedURI);
        }
        if (attributedURI != null && (uRI = attributedURI.getURI()) != null) {
            String string = uRI.toString();
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getAction", string);
            }
            return string;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAction");
        }
        return "";
    }
}

