/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.provider.soap;

import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.client.ClientEngine;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.SerializerFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BeanSerializerFactory;
import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.extensions.ExtensionDescription;
import com.ibm.ws.webservices.multiprotocol.models.ModelServiceProvider;
import com.ibm.ws.webservices.multiprotocol.provider.BindingGenerator;
import com.ibm.ws.webservices.multiprotocol.provider.StubGenerator;
import com.ibm.ws.webservices.multiprotocol.provider.Transport;
import com.ibm.ws.webservices.multiprotocol.provider.soap.SOAPBindingGenerator;
import com.ibm.ws.webservices.multiprotocol.provider.soap.ServiceProxy;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaStubWriter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMapping;
import org.apache.commons.logging.Log;

public class SOAPServiceProvider
extends ModelServiceProvider {
    protected static Log log = LogFactory.getLog(SOAPServiceProvider.class.getName());

    public String getName() {
        return "soap";
    }

    protected String[] getSupportedBindingNamespaces() {
        return new String[]{"http://schemas.xmlsoap.org/wsdl/soap/"};
    }

    protected String[] getRequiredClasses() {
        return new String[]{"com.ibm.ws.webservices.engine.client.Service"};
    }

    public ExtensionDescription[] getExtensionDescriptions() {
        return new ExtensionDescription[0];
    }

    public BindingGenerator[] getBindingGenerators() {
        return new BindingGenerator[]{new SOAPBindingGenerator("http"), new SOAPBindingGenerator("jms")};
    }

    public StubGenerator getStubGenerator(Emitter emitter, BindingEntry bindingEntry, SymbolTable symbolTable) {
        return new JavaStubWriter(emitter, bindingEntry, symbolTable);
    }

    public String[] getPropertyNames() {
        return new String[0];
    }

    public Transport makeTransport(ServiceContext serviceContext) {
        return null;
    }

    protected Service makeService(ServiceContext serviceContext) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SOAPServiceProvider::makeService");
        }
        Definition definition = serviceContext.getDefinition();
        Service service = serviceContext.getGeneratedService();
        ServiceProxy serviceProxy = null;
        if (definition == null) {
            if (log.isDebugEnabled()) {
                log.debug("WSDL definition is null, creating basic Service.");
            }
            serviceProxy = new ServiceProxy(service);
        } else {
            QName qName = serviceContext.getServiceName();
            Hashtable hashtable = this.getNamespace2packageMappings();
            ClientEngine clientEngine = null;
            if (serviceContext.isManagedEnvironment()) {
                clientEngine = serviceContext.getClientEngine();
            }
            if (log.isDebugEnabled()) {
                log.debug("WSDL definition is non-null, creating full-powered Service from WSDL definition.");
            }
            serviceProxy = new ServiceProxy(clientEngine, definition, qName, hashtable, service);
            serviceProxy.setServiceRefName(serviceContext.getServiceRefName());
            serviceProxy.setWSDLDocumentLocation(serviceContext.getWSDLDocumentLocation());
            if (log.isDebugEnabled()) {
                log.debug("Set Service's serviceRefName to: " + serviceContext.getServiceRefName());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SOAPServiceProvider::makeService");
        }
        return serviceProxy;
    }

    protected Hashtable getNamespace2packageMappings() {
        return new Hashtable();
    }

    public static void initTypeMapping(WebServicesEngine webServicesEngine, HashMap hashMap) {
        TypeMappingRegistry typeMappingRegistry = webServicesEngine.getTypeMappingRegistry();
        TypeMapping typeMapping = SOAPServiceProvider.getTypeMapping(typeMappingRegistry, "http://schemas.xmlsoap.org/soap/encoding/");
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            QName qName = (QName)iterator.next();
            Class clazz = (Class)hashMap.get(qName);
            SOAPServiceProvider.registerType(typeMapping, clazz, qName);
        }
    }

    protected static void registerType(TypeMapping typeMapping, Class clazz, QName qName) {
        SerializerFactory serializerFactory = BaseSerializerFactory.createFactory(BeanSerializerFactory.class, clazz, qName);
        DeserializerFactory deserializerFactory = BaseDeserializerFactory.createFactory(BeanDeserializerFactory.class, clazz, qName);
        if (serializerFactory != null || deserializerFactory != null) {
            typeMapping.register(clazz, qName, serializerFactory, deserializerFactory);
        }
    }

    protected static TypeMapping getTypeMapping(javax.xml.rpc.encoding.TypeMappingRegistry typeMappingRegistry, String string) {
        TypeMapping typeMapping = typeMappingRegistry.getTypeMapping(string);
        TypeMapping typeMapping2 = typeMappingRegistry.getDefaultTypeMapping();
        if (typeMapping == null || typeMapping == typeMapping2) {
            typeMapping = typeMappingRegistry.createTypeMapping();
            typeMapping.setSupportedEncodings(new String[]{string});
            typeMappingRegistry.register(string, typeMapping);
        }
        return typeMapping;
    }
}

