/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.security.AuthenticatedUser;
import com.ibm.ws.webservices.engine.security.SecurityProvider;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;

public class SimpleAuthorizationHandler
extends BasicHandler {
    protected static Log log = LogFactory.getLog(SimpleAuthorizationHandler.class.getName());

    public void invoke(MessageContext messageContext) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SimpleAuthorizationHandler::invoke");
        }
        boolean bl = JavaUtils.isTrueExplicitly(this.getOption("allowByDefault"));
        AuthenticatedUser authenticatedUser = (AuthenticatedUser)messageContext.getProperty(MessageContext.AUTHUSER);
        if (authenticatedUser == null) {
            throw new WebServicesFault("Server.NoUser", Messages.getMessage("needUser00"), null, null);
        }
        String string = authenticatedUser.getName();
        SOAPPort sOAPPort = messageContext.getPort();
        if (sOAPPort == null) {
            throw new WebServicesFault(Messages.getMessage("needService00"));
        }
        String string2 = sOAPPort.getName();
        String string3 = (String)sOAPPort.getOption("allowedRoles");
        if (string3 == null) {
            if (bl) {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("noRoles00"));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("noRoles01"));
                }
                throw new WebServicesFault("Server.Unauthorized", Messages.getMessage("notAuth00", string, string2), null, null);
            }
            if (log.isDebugEnabled()) {
                log.debug("Exit: SimpleAuthorizationHandler::invoke");
            }
            return;
        }
        SecurityProvider securityProvider = (SecurityProvider)messageContext.getProperty("securityProvider");
        if (securityProvider == null) {
            throw new WebServicesFault(Messages.getMessage("noSecurity00"));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (!securityProvider.userMatches(authenticatedUser, string4)) continue;
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("auth01", string, string2));
            }
            if (log.isDebugEnabled()) {
                log.debug("Exit: SimpleAuthorizationHandler::invoke");
            }
            return;
        }
        throw new WebServicesFault("Server.Unauthorized", Messages.getMessage("cantAuth02", string, string2), null, null);
    }
}

