/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.tcp.channel.impl.TCPProxyConnLink;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public class TCPProxyResponse {
    TCPProxyConnLink connLink;
    public static final String PROXY_TARGET_HOST_PORT = "PROXY_TARGET_HOST_PORT";
    public static final String PROXY_TARGET_USER_PASS = "PROXY_TARGET_USER_PASS";
    private static byte[] PROXY_CONNECT = null;
    private static byte[] PROXY_HTTPVERSION = null;
    private static byte[] PROXY_AUTHORIZATION = null;
    private static final byte[] PROXY_CRLF = new byte[]{13, 10};
    private ProxyWriteCallback proxyWriteCB = null;
    private ProxyReadCallback proxyReadCB = null;
    private boolean isProxyResponseValid = false;
    protected static final int STATUS_NOT_DONE = 0;
    protected static final int STATUS_DONE = 1;
    protected static final int STATUS_ERROR = 2;
    protected static final TraceComponent tc = Tr.register(TCPProxyResponse.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");

    public TCPProxyResponse(TCPProxyConnLink tCPProxyConnLink) {
        this.connLink = tCPProxyConnLink;
    }

    protected void setIsProxyResponseValid(boolean bl) {
        this.isProxyResponseValid = bl;
    }

    protected void proxyReadHandshake() {
        this.connLink.getReadInterface().setJITAllocateSize(1024);
        if (this.connLink.isAsyncConnect()) {
            this.proxyReadCB = new ProxyReadCallback();
            this.readProxyResponse(this.connLink.getVirtualConnection());
        } else {
            int n = 0;
            while (n == 0) {
                this.readProxyResponse(this.connLink.getVirtualConnection());
                n = this.checkResponse(this.connLink.getReadInterface());
            }
            if (n == 2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "could not complete proxy handshake, read request failed");
                }
                this.releaseProxyReadBuffer();
                if (!this.connLink.isSyncError()) {
                    this.connLink.connectFailed(new IOException("Invalid Proxy Server Response "));
                }
            }
        }
    }

    protected int checkResponse(TCPReadRequestContext tCPReadRequestContext) {
        WsByteBuffer[] wsByteBufferArray = tCPReadRequestContext.getBuffers();
        if (null == wsByteBufferArray) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not complete proxy handshake, null buffers");
            }
            return 2;
        }
        int n = this.validateProxyResponse(wsByteBufferArray);
        if (1 == n) {
            this.releaseProxyReadBuffer();
        }
        return n;
    }

    protected void writeAndShake() {
        if (!this.connLink.isAsyncConnect()) {
            try {
                this.connLink.getWriteInterface().write(-1L, 0);
                this.releaseProxyWriteBuffer();
                this.proxyReadHandshake();
            }
            catch (IOException iOException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "connectComplete: could not complete sync handshake");
                }
                this.releaseProxyWriteBuffer();
                this.connLink.connectFailed(iOException);
            }
        } else {
            this.proxyWriteCB = new ProxyWriteCallback();
            VirtualConnection virtualConnection = this.connLink.getWriteInterface().write(-1L, this.proxyWriteCB, false, 0);
            if (null != virtualConnection) {
                this.proxyWriteCB.complete(virtualConnection, this.connLink.getWriteInterface());
            }
        }
    }

    protected void releaseProxyWriteBuffer() {
        WsByteBuffer wsByteBuffer = this.connLink.getWriteInterface().getBuffer();
        if (null != wsByteBuffer) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Releasing proxy write buffer: " + wsByteBuffer);
            }
            wsByteBuffer.release();
            this.connLink.getWriteInterface().setBuffer(null);
        }
    }

    protected void releaseProxyReadBuffer() {
        WsByteBuffer wsByteBuffer = this.connLink.getReadInterface().getBuffer();
        if (null != wsByteBuffer) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Releasing proxy read buffer: " + wsByteBuffer);
            }
            wsByteBuffer.release();
            this.connLink.getReadInterface().setBuffer(null);
        }
    }

    protected int validateProxyResponse(WsByteBuffer[] wsByteBufferArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "validateProxyResponse");
        }
        int n = 0;
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            wsByteBufferArray[i].flip();
            byte[] byArray = new byte[wsByteBufferArray[i].limit()];
            wsByteBufferArray[i].get(byArray);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "buffer: [" + new String(byArray) + "]");
            }
            if (!this.isProxyResponseValid) {
                this.isProxyResponseValid = this.containsHTTP200(byArray);
                if (!this.isProxyResponseValid) {
                    n = 2;
                    break;
                }
            }
            if (this.containsEOLDelimiters(byArray)) {
                n = 1;
                break;
            }
            wsByteBufferArray[i].clear();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "validateProxyResponse, rc=" + n);
        }
        return n;
    }

    protected boolean containsEOLDelimiters(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (13 == byArray[i] || 10 == byArray[i]) {
                if (4 == ++n) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "contains 4 consecutive CRs and/or LFs: true");
                    }
                    return true;
                }
                if (i <= 0 || 10 != byArray[i] || 10 != byArray[i - 1]) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "contains LF-LF: true");
                }
                return true;
            }
            n = 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "containsEOLDelimiters: false count=" + n);
        }
        return false;
    }

    protected boolean containsHTTP200(byte[] byArray) {
        boolean bl = true;
        if (byArray.length < 12 || byArray[0] != 72 || byArray[1] != 84 || byArray[2] != 84 || byArray[3] != 80 || byArray[9] != 50 || byArray[10] != 48 || byArray[11] != 48) {
            bl = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "containsHTTP200: " + bl);
        }
        return bl;
    }

    protected boolean setForwardProxyBuffers(Map map) {
        byte[] byArray = (byte[])map.get(PROXY_TARGET_HOST_PORT);
        if (null == byArray) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Proxy tunnel attempt missing target host");
            }
            this.connLink.connectFailed(new IOException("Missing forward proxy target host"));
            return false;
        }
        byte[] byArray2 = (byte[])map.get(PROXY_TARGET_USER_PASS);
        int n = 100 + byArray.length + (null != byArray2 ? byArray2.length : 0);
        WsByteBuffer wsByteBuffer = WsByteBufferPoolManagerImpl.getRef().allocate(n);
        wsByteBuffer.put(PROXY_CONNECT);
        wsByteBuffer.put(byArray);
        wsByteBuffer.put(PROXY_HTTPVERSION);
        if (null != byArray2) {
            wsByteBuffer.put(PROXY_AUTHORIZATION);
            wsByteBuffer.put(byArray2);
            wsByteBuffer.put(PROXY_CRLF);
        }
        wsByteBuffer.put(PROXY_CRLF);
        wsByteBuffer.flip();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            byte[] byArray3 = new byte[wsByteBuffer.limit()];
            wsByteBuffer.get(byArray3);
            Tr.debug(tc, "ForwardProxyBuffers[" + new String(byArray3) + "]");
            wsByteBuffer.position(0);
        }
        this.connLink.getWriteInterface().setBuffer(wsByteBuffer);
        return true;
    }

    protected void readProxyResponse(VirtualConnection virtualConnection) {
        int n = 1;
        if (!this.isProxyResponseValid) {
            n = 12;
        }
        if (this.connLink.isAsyncConnect()) {
            VirtualConnection virtualConnection2 = this.connLink.getReadInterface().read(n, this.proxyReadCB, false, 0);
            if (null != virtualConnection2) {
                this.proxyReadCB.complete(virtualConnection2, this.connLink.getReadInterface());
            }
        } else {
            try {
                this.connLink.getReadInterface().read(n, 0);
            }
            catch (IOException iOException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "could not complete proxy handshake, read request failed");
                }
                this.releaseProxyReadBuffer();
                this.connLink.connectFailed(iOException);
            }
        }
    }

    static {
        try {
            PROXY_CONNECT = "CONNECT ".getBytes("ISO-8859-1");
            PROXY_HTTPVERSION = " HTTP/1.0\r\n".getBytes("ISO-8859-1");
            PROXY_AUTHORIZATION = "Proxy-authorization: basic ".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "ISO-8859-1 encoding not supported.  Exception: " + unsupportedEncodingException);
            }
            PROXY_CONNECT = "CONNECT ".getBytes();
            PROXY_HTTPVERSION = " HTTP/1.0\r\n".getBytes();
            PROXY_AUTHORIZATION = "Proxy-authorization: basic ".getBytes();
        }
    }

    protected class ProxyReadCallback
    implements TCPReadCompletedCallback {
        protected ProxyReadCallback() {
        }

        public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
            int n;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ProxyReadCallback --> complete for " + virtualConnection);
            }
            if ((n = TCPProxyResponse.this.checkResponse(tCPReadRequestContext)) == 1) {
                TCPProxyResponse.this.connLink.getApplicationCallback().ready(virtualConnection);
            } else if (n == 0) {
                TCPProxyResponse.this.readProxyResponse(virtualConnection);
            } else {
                TCPProxyResponse.this.releaseProxyReadBuffer();
                TCPProxyResponse.this.connLink.connectFailed(new IOException("Invalid Proxy Server Response "));
            }
        }

        public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ProxyReadCallback--> error for " + virtualConnection);
                Tr.debug(tc, "ioe: " + iOException);
            }
            TCPProxyResponse.this.releaseProxyReadBuffer();
            TCPProxyResponse.this.connLink.connectFailed(iOException);
        }
    }

    protected class ProxyWriteCallback
    implements TCPWriteCompletedCallback {
        protected ProxyWriteCallback() {
        }

        public void complete(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ProxyWriteCallback --> complete for " + virtualConnection);
            }
            TCPProxyResponse.this.releaseProxyWriteBuffer();
            TCPProxyResponse.this.proxyReadHandshake();
        }

        public void error(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext, IOException iOException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ProxyWriteCallback--> error for " + virtualConnection);
                Tr.debug(tc, "ioe: " + iOException);
            }
            TCPProxyResponse.this.releaseProxyWriteBuffer();
            TCPProxyResponse.this.connLink.connectFailed(iOException);
        }
    }
}

