/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.ssl.JSSEProviderFactory;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class TrustManagerData {
    private static final TraceComponent tc = Tr.register(TrustManagerData.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    String tmName;
    String tmProvider;
    String tmAlgorithm;
    String tmCustomClass;
    Properties tmCustomProps;
    String tmScope;

    public TrustManagerData(String string, String string2, String string3, String string4, List list, String string5) {
        this.tmName = string;
        this.tmProvider = string2;
        this.tmAlgorithm = string3;
        this.tmCustomClass = string4;
        this.tmCustomProps = this.convertListToProperties(list);
        this.tmScope = string5;
    }

    public Properties convertListToProperties(List list) {
        if (list != null) {
            Properties properties = new Properties();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                if (property == null) continue;
                properties.setProperty(property.getName(), property.getValue());
            }
            return properties;
        }
        return null;
    }

    public String getName() {
        return this.tmName;
    }

    public void setName(String string) {
        this.tmName = string;
    }

    public String getProvider() {
        return this.tmProvider;
    }

    public void setProvider(String string) {
        this.tmProvider = string;
    }

    public String getAlgorithm() {
        return this.tmAlgorithm;
    }

    public void setAlgorithm(String string) {
        this.tmAlgorithm = string;
    }

    public String getTrustManagerClass() {
        return this.tmCustomClass;
    }

    public void setTrustManagerClass(String string) {
        this.tmCustomClass = string;
    }

    public Properties getAdditionalTrustManagerAttrs() {
        return this.tmCustomProps;
    }

    public void setAdditionalTrustManagerAttrs(List list) {
        this.tmCustomProps = this.convertListToProperties(list);
    }

    public String getManagementScope() {
        return this.tmScope;
    }

    public void setManagementScope(String string) {
        this.tmScope = string;
    }

    public String getTrustManagerString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustManagerString");
        }
        if (this.tmCustomClass != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTrustManagerString -> " + this.tmCustomClass);
            }
            return this.tmCustomClass;
        }
        if (this.tmAlgorithm != null && this.tmProvider != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTrustManagerString -> " + this.tmAlgorithm + "|" + this.tmProvider);
            }
            return this.tmAlgorithm + "|" + this.tmProvider;
        }
        if (this.tmAlgorithm != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTrustManagerString -> " + this.tmAlgorithm);
            }
            return this.tmAlgorithm;
        }
        String string = JSSEProviderFactory.getTrustManagerFactoryAlgorithm();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustManagerString (default) -> " + string);
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TrustManagerData: name=");
        stringBuffer.append(this.tmName);
        stringBuffer.append(", algorithm=");
        stringBuffer.append(this.tmAlgorithm);
        stringBuffer.append(", provider=");
        stringBuffer.append(this.tmProvider);
        stringBuffer.append(", customClass=");
        stringBuffer.append(this.tmCustomClass);
        stringBuffer.append(", scope=");
        stringBuffer.append(this.tmScope);
        return stringBuffer.toString();
    }
}

