/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.cmdframework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.exception.SessionTimeoutException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.cmdframework.impl.TaskCommandSession;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TaskCommandSessionMgr
implements AlarmListener {
    private static TraceComponent tc = Tr.register(TaskCommandSessionMgr.class, "TaskCommandSessionMgr", "com.ibm.ws.management.resources.cmdframework");
    private HashMap taskSessions = new HashMap();

    public TaskCommandSessionMgr() {
        this.registerAlarm();
    }

    private void registerAlarm() {
        AlarmManager.createDeferrable(600000L, this);
    }

    public synchronized TaskCommandSession createTaskCommandSession(TaskCommand taskCommand) {
        TaskCommandSession taskCommandSession = new TaskCommandSession();
        this.taskSessions.put(taskCommandSession, taskCommand);
        return taskCommandSession;
    }

    public synchronized TaskCommand getTaskCommand(TaskCommandSession taskCommandSession) throws SessionTimeoutException {
        TaskCommand taskCommand = (TaskCommand)this.taskSessions.get(taskCommandSession);
        if (taskCommand != null) {
            Set set = this.taskSessions.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                TaskCommandSession taskCommandSession2 = (TaskCommandSession)iterator.next();
                if (!taskCommandSession2.equals(taskCommandSession)) continue;
                taskCommandSession2.refreshActiveTimeStamp();
            }
        }
        if (taskCommand == null) {
            throw new SessionTimeoutException(new Session(Long.toString(taskCommandSession.getSessionId()), true));
        }
        return taskCommand;
    }

    public synchronized void removeTaskCommand(TaskCommandSession taskCommandSession) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTaskCommand, [" + this.taskSessions.size() + "] removing TaskCommand " + taskCommandSession);
        }
        TaskCommand taskCommand = (TaskCommand)this.taskSessions.remove(taskCommandSession);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTaskCommand, [" + this.taskSessions.size() + "] TaskCommand " + taskCommand + " removed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm");
        }
        try {
            Set set = this.taskSessions.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                TaskCommandSession taskCommandSession = (TaskCommandSession)entry.getKey();
                if (!taskCommandSession.isExpired()) continue;
                iterator.remove();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "removed session", taskCommandSession);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            FFDCFilter.processException(throwable, "com.ibm.ws.management.cmdframework.TaskCommandSessionMgr", "77", this);
        }
        finally {
            this.registerAlarm();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }
}

