/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;

public class HttpOSCBodyReadCallback
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register(HttpOSCBodyReadCallback.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static HttpOSCBodyReadCallback myInstance = null;

    private HttpOSCBodyReadCallback() {
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new HttpOSCBodyReadCallback();
        }
    }

    public static final HttpOSCBodyReadCallback getRef() {
        if (null == myInstance) {
            HttpOSCBodyReadCallback.createSingleton();
        }
        return myInstance;
    }

    public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "complete() called: vc=" + virtualConnection);
        }
        HttpOutboundServiceContextImpl httpOutboundServiceContextImpl = (HttpOutboundServiceContextImpl)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
        httpOutboundServiceContextImpl.continueRead();
    }

    public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
        HttpOutboundServiceContextImpl httpOutboundServiceContextImpl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "error() called: vc=" + virtualConnection + " ioe=" + iOException);
        }
        if ((httpOutboundServiceContextImpl = (HttpOutboundServiceContextImpl)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC)).canceledRead()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Ignoring error callback on canceled read");
            }
            httpOutboundServiceContextImpl.resetCanceledRead();
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Socket closure, signaling close.");
        }
        if (!httpOutboundServiceContextImpl.isChunkedEncoding() && !httpOutboundServiceContextImpl.isContentLength()) {
            httpOutboundServiceContextImpl.prepareClosure();
            httpOutboundServiceContextImpl.getAppReadCallback().complete(virtualConnection);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "IOException during body read");
            }
            httpOutboundServiceContextImpl.setPersistent(false);
            httpOutboundServiceContextImpl.getAppReadCallback().error(virtualConnection, iOException);
        }
    }
}

