/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.extension.thinregistry;

import com.ibm.ws.bootstrap.LoggingServices;
import com.ibm.ws.extension.thinregistry.Extension;
import com.ibm.ws.extension.thinregistry.ExtensionPoint;
import com.ibm.ws.extension.thinregistry.ExtensionRegistry;
import com.ibm.ws.extension.thinregistry.PluginDescriptor;
import java.util.Collection;
import java.util.Iterator;

public class RegistryResolver {
    private static final String srcClass = "RegistryResolver";
    private static final String SEPARATOR = ".";
    private ExtensionRegistry _reg;

    public RegistryResolver(ExtensionRegistry extensionRegistry) {
        this._reg = extensionRegistry;
    }

    public void resolve() {
        Collection collection = this._reg.getAllPlugins();
        if (collection == null || collection.isEmpty()) {
            if (LoggingServices.debugEnabled) {
                LoggingServices.trace("registry.warning.empty_plugin_list");
            }
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PluginDescriptor pluginDescriptor = (PluginDescriptor)iterator.next();
            this.resolvePluginDescriptorExtensions(pluginDescriptor);
        }
    }

    private void resolvePluginDescriptorExtensions(PluginDescriptor pluginDescriptor) {
        Extension[] extensionArray = (Extension[])pluginDescriptor.getExtensions();
        if (extensionArray != null && 0 < extensionArray.length) {
            for (int i = 0; i < extensionArray.length; ++i) {
                if (extensionArray[i] == null) continue;
                this.resolveExtension(extensionArray[i]);
            }
        }
    }

    private boolean resolveExtension(Extension extension) {
        boolean bl = false;
        String string = extension.getExtensionPointUniqueIdentifier();
        int n = string.lastIndexOf(SEPARATOR);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PluginDescriptor pluginDescriptor = this._reg.getPlugin(string2);
        if (pluginDescriptor != null) {
            ExtensionPoint extensionPoint = (ExtensionPoint)pluginDescriptor.getExtensionPoint(string3);
            if (extensionPoint == null) {
                if (LoggingServices.debugEnabled) {
                    LoggingServices.trace("registry.warning.nonexistent_ext_pt", new Object[]{string, extension.getUniqueIdentifier()});
                }
            } else {
                extensionPoint.addExtension(extension);
                bl = true;
            }
        }
        return bl;
    }
}

