/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config;

import com.ibm.ws.exception.WsException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ImplFactory;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.wst.common.internal.emf.utilities.EncoderDecoder;
import org.eclipse.wst.common.internal.emf.utilities.EncoderDecoderRegistry;

public class ModelMgr {
    private static boolean initialized = false;
    private static HashMap processedModelsMap = new HashMap();

    public static void initialize(String string) {
        if (initialized) {
            return;
        }
        ModelMgr.initializeModels(string);
        try {
            EncoderDecoder encoderDecoder = (EncoderDecoder)ImplFactory.loadImplFromKey(EncoderDecoder.class);
            EncoderDecoderRegistry.getDefaultRegistry().setDefaultEncoderDecoder(encoderDecoder);
            initialized = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new IllegalStateException(throwable.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeModels(String string) {
        if ("ws-server".equals(string)) {
            string = "server";
        }
        try {
            ArrayList arrayList = null;
            HashMap hashMap = processedModelsMap;
            synchronized (hashMap) {
                arrayList = (ArrayList)processedModelsMap.get(string);
                if (arrayList != null) {
                    return;
                }
                arrayList = new ArrayList();
                processedModelsMap.put(string, arrayList);
            }
            ModelMgr.loadModelsViaEclipse(string, arrayList);
            ModelMgr.loadModelsViaLegacy(string, arrayList);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.config.ModelMgr", "98");
        }
    }

    private static void loadModelsViaLegacy(String string, List list) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> enumeration = null;
        try {
            enumeration = classLoader.getResources("META-INF/ws-" + string + "-model.init");
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.config.ModelMgr", "59");
            return;
        }
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                while ((string2 = bufferedReader.readLine()) != null) {
                    try {
                        try {
                            if (string2.trim().length() <= 0 || list.contains(string2)) continue;
                            Class<?> clazz = classLoader.loadClass(string2);
                            Method method = clazz.getDeclaredMethod("init", null);
                            method.invoke(null, null);
                            list.add(string2);
                        }
                        catch (Exception exception) {
                            throw new WsException("Error processing plugin for " + uRL.toString() + " class: " + string2, exception);
                        }
                    }
                    catch (WsException wsException) {
                        FFDCFilter.processException(wsException, "com.ibm.ws.config.ModelMgr", "116");
                    }
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, "com.ibm.ws.config.ModelMgr", "82");
            }
        }
    }

    private static void loadModelsViaEclipse(String string, List list) {
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (iExtensionRegistry == null) {
            return;
        }
        String string2 = ExtensionRegistryFactory.instance().getDefaultPluginID() + "." + string + "-model-init";
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string2);
        IExtension[] iExtensionArray = null;
        if (iExtensionPoint != null) {
            iExtensionArray = iExtensionPoint.getExtensions();
            for (int i = 0; i < iExtensionArray.length; ++i) {
                try {
                    String string3 = null;
                    try {
                        IExtension iExtension = iExtensionArray[i];
                        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                        if (iConfigurationElementArray.length != 1) continue;
                        IConfigurationElement iConfigurationElement = iConfigurationElementArray[0];
                        string3 = iConfigurationElement.getAttribute("classname");
                        Object object = iConfigurationElement.createExecutableExtension("classname");
                        Class<?> clazz = object.getClass();
                        Method method = clazz.getDeclaredMethod("init", null);
                        method.invoke(null, null);
                        list.add(string3);
                        continue;
                    }
                    catch (Exception exception) {
                        throw new WsException("Error processing plugin for class: " + string3, exception);
                    }
                }
                catch (WsException wsException) {
                    FFDCFilter.processException(wsException, "com.ibm.ws.config.ModelMgr", "116");
                }
            }
        }
    }
}

