/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection.feedback;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.ws.cluster.selection.RouterMediator;
import com.ibm.ws.cluster.selection.algorithm.SelectionAlgorithm;
import com.ibm.ws.cluster.selection.feedback.WeightBasedFeedback;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.monitor.AdvisorFactory;
import com.ibm.wsspi.cluster.monitor.AdvisorMediator;
import java.util.Set;

public final class BlendedWeightFeedback
implements WeightBasedFeedback,
DescriptionModificationListener {
    private static final TraceComponent tc = Tr.register(BlendedWeightFeedback.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final DescriptionManager descriptionManager = DescriptionManagerFactory.getDescriptionManager();
    private ClusterDescription cluster;
    private SelectionAlgorithm selectionAlgorithm;
    private MemberData[] members = new MemberData[0];
    private volatile boolean execute = true;

    private int[] modifyWeights(MemberData[] memberDataArray) {
        int n;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyWeights", memberDataArray);
        }
        int n3 = memberDataArray.length;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            n5 += memberDataArray[n2].observed;
            n4 += memberDataArray[n2].desired;
        }
        n2 = 0;
        if (n5 == 0) {
            for (int i = 0; i < n3; ++i) {
                nArray[i] = memberDataArray[i].desired;
                if (memberDataArray[i].last == memberDataArray[i].desired) continue;
                memberDataArray[i].last = memberDataArray[i].desired;
                n2 = 1;
            }
        } else if (n4 == 0) {
            int n6 = n5 / n3;
            for (n = 0; n < n3; ++n) {
                nArray[n] = n6 - memberDataArray[n].observed;
                if (nArray[n] == memberDataArray[n].last) continue;
                memberDataArray[n].last = nArray[n];
                n2 = 1;
            }
        } else {
            double d = (double)n4 / (double)n5;
            for (int i = 0; i < n3; ++i) {
                int n7 = nArray[i] = memberDataArray[i].desired == 0 ? 0 : 2 * memberDataArray[i].desired - (int)((double)memberDataArray[i].observed * d);
                if (nArray[i] == memberDataArray[i].last) continue;
                memberDataArray[i].last = nArray[i];
                n2 = 1;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("weights ");
            for (n = 0; n < n3; ++n) {
                stringBuffer.append(memberDataArray[n].desired);
                stringBuffer.append("->");
                stringBuffer.append(nArray[n]);
                stringBuffer.append(" ");
            }
            stringBuffer.append(n4);
            stringBuffer.append(" ");
            stringBuffer.append(n5);
            Tr.exit(tc, "modifyWeights", stringBuffer);
        }
        return (int[])(n2 != 0 ? nArray : null);
    }

    public void init(Identity identity, SelectionAlgorithm selectionAlgorithm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init", new Object[]{identity, selectionAlgorithm});
        }
        this.cluster = (ClusterDescription)descriptionManager.getDescription((DescriptionKey)identity);
        this.selectionAlgorithm = selectionAlgorithm;
        Set set = this.getClusterMemento().getMembers().keySet();
        Identity[] identityArray = new Identity[set.size()];
        set.toArray(identityArray);
        this.applyStructuralUpdate(identityArray);
        AdvisorMediator advisorMediator = AdvisorFactory.getAdvisorMediator();
        ((RouterMediator)advisorMediator).registerFeedback(this, this.cluster.getKey());
        this.cluster.registerNotificationListener(this, "type.cluster.weight.update", null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init", this);
        }
    }

    public void applyStructuralUpdate(Identity[] identityArray) {
        MemberData[] memberDataArray = new MemberData[identityArray.length];
        for (int i = 0; i < identityArray.length; ++i) {
            MemberData memberData = this.getMemberData(identityArray[i]);
            if (memberData == null) {
                memberData = new MemberData(identityArray[i]);
            }
            memberDataArray[i] = memberData;
            memberData.desired = this.getClusterMemento().getWeightTableEntry((DescriptionKey)identityArray[i]);
        }
        this.members = memberDataArray;
        this.execute(true);
    }

    public void applyWorkloadUpdate(Identity identity, int n) {
        MemberData memberData = this.getMemberData(identity);
        if (memberData != null) {
            memberData.observed = n;
        }
        if (this.execute) {
            this.execute = false;
            this.execute(false);
            this.execute = true;
        }
    }

    public void applyExceptionUpdate(Identity identity, int n) {
        MemberData memberData = this.getMemberData(identity);
        if (memberData != null) {
            memberData.exception += n;
        }
        if (this.execute) {
            this.execute = false;
            this.execute(false);
            this.execute = true;
        }
    }

    private void execute(boolean bl) {
        MemberData[] memberDataArray = this.members;
        int[] nArray = this.modifyWeights(memberDataArray);
        if (bl || nArray != null) {
            int n;
            Identity[] identityArray = new Identity[memberDataArray.length];
            for (n = 0; n < memberDataArray.length; ++n) {
                identityArray[n] = memberDataArray[n].memberIdentity;
            }
            if (nArray == null) {
                nArray = new int[identityArray.length];
                for (n = 0; n < memberDataArray.length; ++n) {
                    nArray[n] = memberDataArray[n].desired;
                }
            }
            this.selectionAlgorithm.prepare(identityArray, nArray);
        }
    }

    public void handleNotification(DescriptionKey descriptionKey, String string, Object object, Object object2) {
        MemberData memberData;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "handleNotification", new Object[]{descriptionKey, string, object});
        }
        if ((memberData = this.getMemberData((Identity)object)) != null) {
            memberData.desired = this.getClusterMemento().getWeightTableEntry((DescriptionKey)object);
        }
        this.execute(true);
    }

    private MemberData getMemberData(Identity identity) {
        MemberData[] memberDataArray = this.members;
        for (int i = 0; i < memberDataArray.length; ++i) {
            if (memberDataArray[i].memberIdentity != identity) continue;
            return memberDataArray[i];
        }
        return null;
    }

    public String toString() {
        return super.toString() + '[' + this.cluster.getKey() + ' ' + this.selectionAlgorithm + ' ' + this.members + ']';
    }

    private ClusterDescription.Memento getClusterMemento() {
        return (ClusterDescription.Memento)this.cluster.getMemento();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.10 ");
        }
    }

    private final class MemberData {
        private final Identity memberIdentity;
        private int desired;
        private int observed;
        private int exception;
        private int last;

        private MemberData(Identity identity) {
            this.memberIdentity = identity;
        }

        public String toString() {
            return "[" + this.memberIdentity + ':' + this.desired + ':' + this.observed + ':' + this.exception + ':' + this.last + ']';
        }
    }
}

