/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.monitor.AdvisorMediator;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;

public abstract class AdvisorMediatorA
implements AdvisorMediator {
    private static final TraceComponent tc = Tr.register(AdvisorMediatorA.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    static final Integer zero = new Integer(0);
    protected Map unavailableServers = new HashMap();
    private final WeightTable weightTable = new WeightTable();
    private static final DescriptionManager descMgr;

    public boolean isAvailable(Identity identity) {
        return false;
    }

    public void setAvailable(Identity identity) {
    }

    public void setUnavailable(Identity identity) {
    }

    public boolean isQuiesced(Identity identity, Identity identity2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isQuiesced", new Object[]{"cluster is: " + identity, "member is: " + identity2});
        }
        if (identity == null) {
            throw new IllegalArgumentException("The passed in cluster Identity is null.");
        }
        if (identity2 == null) {
            throw new IllegalArgumentException("The passed in member Identity is null.");
        }
        ClusterDescription clusterDescription = null;
        Description description = descMgr.getDescription((DescriptionKey)identity);
        if (description == null) {
            throw new IllegalArgumentException("The cluster identified by the passed in cluster Identity does not exist.");
        }
        try {
            clusterDescription = (ClusterDescription)description;
            ClusterDescription.Memento memento = (ClusterDescription.Memento)clusterDescription.getMemento();
            Map map = memento.getMembers();
            if (!map.containsKey(identity2)) {
                throw new IllegalArgumentException("The passed in member is not a member of the passed in cluster.");
            }
            boolean bl = memento.isQuiesced(identity2);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isQuiesced", "survey says: " + bl);
            }
            return bl;
        }
        catch (ClassCastException classCastException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The passed in Identity of the cluster did not identify a cluster.");
            illegalArgumentException.initCause(classCastException);
            throw illegalArgumentException;
        }
    }

    public void setQuiesce(Identity identity, Identity identity2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setQuiesced", new Object[]{"cluster is: " + identity, "member is: " + identity2});
        }
        if (identity == null) {
            throw new IllegalArgumentException("The passed in cluster Identity is null.");
        }
        if (identity2 == null) {
            throw new IllegalArgumentException("The passed in member Identity is null.");
        }
        ClusterDescription clusterDescription = null;
        Description description = descMgr.getDescription((DescriptionKey)identity);
        if (description == null) {
            throw new IllegalArgumentException("The cluster identified by the passed in cluster Identity does not exist.");
        }
        try {
            clusterDescription = (ClusterDescription)description;
            clusterDescription.setQuiesce(identity2);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setQuiesced");
            }
        }
        catch (ClassCastException classCastException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The passed in Identity of the cluster did not identify a cluster.");
            illegalArgumentException.initCause(classCastException);
            throw illegalArgumentException;
        }
    }

    public void unsetQuiesce(Identity identity, Identity identity2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetQuiesced", new Object[]{"cluster is: " + identity, "member is: " + identity2});
        }
        if (identity == null) {
            throw new IllegalArgumentException("The passed in cluster Identity is null.");
        }
        if (identity2 == null) {
            throw new IllegalArgumentException("The passed in member Identity is null.");
        }
        ClusterDescription clusterDescription = null;
        Description description = descMgr.getDescription((DescriptionKey)identity);
        if (description == null) {
            throw new IllegalArgumentException("The cluster identified by the passed in cluster Identity does not exist.");
        }
        try {
            clusterDescription = (ClusterDescription)description;
            clusterDescription.unsetQuiesce(identity2);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "unsetQuiesced");
            }
        }
        catch (ClassCastException classCastException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The passed in Identity of the cluster did not identify a cluster.");
            illegalArgumentException.initCause(classCastException);
            throw illegalArgumentException;
        }
    }

    public int getObservedWeight(Identity identity, Identity identity2) {
        return this.weightTable.get(identity, identity2);
    }

    public void setObservedWeight(Identity identity, Identity identity2, int n) {
        this.weightTable.set(identity, identity2, new Integer(n));
    }

    public void tareObservedWeights(Identity identity) {
        this.weightTable.remove(identity);
    }

    static {
        DescriptionManagerFactory.getInstance();
        descMgr = DescriptionManagerFactory.getDescriptionManager();
    }

    private final class AvailabilityTimer
    extends TimerTask {
        private AvailabilityTimer() {
        }

        void unavailable(Identity identity) {
        }

        public void run() {
        }
    }

    private final class WeightTable {
        private final Map weights = new HashMap();

        private WeightTable() {
        }

        Integer get(Identity identity, Identity identity2) {
            Map map = (Map)this.weights.get(identity);
            if (map == null) {
                return zero;
            }
            Integer n = (Integer)map.get(identity2);
            return n == null ? zero : n;
        }

        void set(Identity identity, Identity identity2, Integer n) {
            HashMap<Identity, Integer> hashMap = (HashMap<Identity, Integer>)this.weights.get(identity);
            if (identity2 == null) {
                hashMap = new HashMap<Identity, Integer>();
            }
            hashMap.put(identity2, n);
        }

        void remove(Identity identity) {
            this.weights.remove(identity);
        }
    }
}

