/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.channel.ChannelTargetImpl;
import com.ibm.ws.cluster.channel.NoAvailableEndPointExceptionImpl;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.CFEndPointCriteria;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.Target;
import com.ibm.wsspi.cluster.adapter.channel.ChannelSelectionAdapter;
import com.ibm.wsspi.cluster.adapter.channel.ChannelSelectionCriteria;
import com.ibm.wsspi.cluster.adapter.channel.ChannelTarget;
import com.ibm.wsspi.cluster.adapter.channel.HealthMonitorManager;
import com.ibm.wsspi.cluster.adapter.channel.NoAvailableEndPointException;
import com.ibm.wsspi.cluster.selection.NoApplicableTargetException;
import com.ibm.wsspi.cluster.selection.NoAvailableTargetException;
import com.ibm.wsspi.cluster.selection.SelectionService;
import com.ibm.wsspi.cluster.selection.SelectionServiceFactory;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class ChannelSelectionAdapterImpl
extends WsComponentImpl
implements ChannelSelectionAdapter {
    private static final TraceComponent tc = Tr.register(ChannelSelectionAdapterImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private SelectionService selectionService = SelectionServiceFactory.getSelectionService();
    static ChannelFrameworkService cfService = null;
    static HealthMonitorManager hmService = null;
    private Map targetCache = Collections.synchronizedMap(new WeakHashMap());

    public void initialize(Object object) throws ComponentDisabledException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{object});
        }
        try {
            cfService = (ChannelFrameworkService)WsServiceRegistry.getService(this, ChannelFrameworkService.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, ChannelSelectionAdapterImpl.class.getName() + ".initialize", "105");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "initialize getService Failed");
            }
            throw new ComponentDisabledException();
        }
        if (cfService == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize", "ChannelFrameworkService is unavailable.  Shutting down the ChannelSelectionAdapter");
            }
            throw new ComponentDisabledException();
        }
        try {
            WsServiceRegistry.addService(this, ChannelSelectionAdapter.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, ChannelSelectionAdapterImpl.class.getName() + ".initialize", "123");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "initialize addService Failed");
            }
            throw new ComponentDisabledException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize ");
        }
    }

    public void start() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public CFEndPoint select(Identity identity, CFEndPointCriteria cFEndPointCriteria) throws NoAvailableEndPointException, NoApplicableTargetException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "select", new Object[]{identity, cFEndPointCriteria});
        }
        if (identity == null) {
            throw new IllegalArgumentException("The Identity argument must not be null.");
        }
        if (cFEndPointCriteria == null) {
            throw new IllegalArgumentException("The CFEndPointCriteria argument must not be null.");
        }
        ChannelSelectionCriteria channelSelectionCriteria = this.getCriteria(identity, null, cFEndPointCriteria);
        ChannelTarget channelTarget = this.select(channelSelectionCriteria);
        CFEndPoint cFEndPoint = channelTarget.getCFEndPoint();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "select", cFEndPoint);
        }
        return cFEndPoint;
    }

    public ChannelTarget select(ChannelSelectionCriteria channelSelectionCriteria) throws NoAvailableEndPointException, NoApplicableTargetException {
        ChannelTarget channelTarget;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "select", channelSelectionCriteria);
        }
        if (channelSelectionCriteria == null) {
            throw new IllegalArgumentException("The ChannelSelectionCriteria attribute must not be null.");
        }
        try {
            Target target = this.selectionService.select(channelSelectionCriteria.getCriteria());
            channelTarget = (ChannelTarget)this.targetCache.get(target);
            if (channelTarget == null) {
                channelTarget = new ChannelTargetImpl(target, channelSelectionCriteria.getCFEndPointCriteria());
                this.targetCache.put(target, channelTarget);
            }
        }
        catch (NoAvailableTargetException noAvailableTargetException) {
            throw new NoAvailableEndPointExceptionImpl(noAvailableTargetException, channelSelectionCriteria);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "select", channelTarget);
        }
        return channelTarget;
    }

    public ChannelTarget select(Identity identity, ChannelSelectionCriteria channelSelectionCriteria) throws NoAvailableEndPointException, NoApplicableTargetException {
        ChannelTargetImpl channelTargetImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "select", new Object[]{identity, channelSelectionCriteria});
        }
        if (identity == null) {
            throw new IllegalArgumentException("The Identity argument must not be null.");
        }
        if (channelSelectionCriteria == null) {
            throw new IllegalArgumentException("The ChannelSelectionCriteria argument must not be null.");
        }
        try {
            Target target = this.selectionService.select(channelSelectionCriteria.getCriteria());
            channelTargetImpl = new ChannelTargetImpl(target, channelSelectionCriteria.getCFEndPointCriteria());
        }
        catch (NoAvailableTargetException noAvailableTargetException) {
            throw new NoAvailableEndPointExceptionImpl(noAvailableTargetException, channelSelectionCriteria);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "select", channelTargetImpl);
        }
        return channelTargetImpl;
    }

    public ChannelSelectionCriteria getCriteria(Identity identity, Map hashMap, CFEndPointCriteria cFEndPointCriteria) {
        ChannelSelectionCriteria channelSelectionCriteria;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCriteria", new Object[]{identity, hashMap, cFEndPointCriteria});
        }
        if (identity == null) {
            throw new IllegalArgumentException("The identity attribute must not be null.");
        }
        if (hashMap == null) {
            hashMap = new HashMap<String, Map>(5);
        }
        if (!hashMap.containsKey("endpoints")) {
            hashMap.put("endpoints", ChannelTargetImpl.distinction);
        }
        ChannelSelectionCriteria channelSelectionCriteria2 = channelSelectionCriteria = cFEndPointCriteria == null ? new ChannelSelectionCriteria(identity, hashMap, null, null, null, false) : new ChannelSelectionCriteria(identity, hashMap, cFEndPointCriteria);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCriteria", channelSelectionCriteria);
        }
        return channelSelectionCriteria;
    }

    public ChannelSelectionCriteria getCriteria(Identity identity, Map map, String string, Class clazz, Class[] classArray, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCriteria", new Object[]{identity, map, string, clazz, classArray, String.valueOf(bl)});
        }
        if (identity == null) {
            throw new IllegalArgumentException("The identity attribute must not be null.");
        }
        ChannelSelectionCriteria channelSelectionCriteria = new ChannelSelectionCriteria(identity, map, string, clazz, classArray, bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCriteria", channelSelectionCriteria);
        }
        return channelSelectionCriteria;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.18.1.1 ");
        }
    }
}

