/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.crypto;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.Serializable;
import java.security.Key;
import java.security.cert.Certificate;

public class KeyPair
implements Serializable {
    private static final TraceComponent tc = Tr.register(KeyPair.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private Key privKey = null;
    private Key pubKey = null;
    private Certificate[] chain = null;

    public KeyPair(Certificate[] certificateArray, Key key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KeyPair (cert)");
        }
        this.privKey = key;
        this.chain = certificateArray;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KeyPair");
        }
    }

    public KeyPair(Key key, Key key2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KeyPair (no cert)");
        }
        this.privKey = key2;
        this.pubKey = key;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KeyPair");
        }
    }

    public Certificate[] getCertificateChain() {
        return this.chain;
    }

    public Certificate getCertificate() {
        if (this.chain != null && this.chain[0] != null) {
            return this.chain[0];
        }
        return null;
    }

    public Key getPrivateKey() {
        return this.privKey;
    }

    public Key getPublicKey() {
        if (this.chain != null && this.chain[0] != null) {
            return this.chain[0].getPublicKey();
        }
        return this.pubKey;
    }
}

