/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras.mgr;

import com.ibm.ras.RASObject;
import java.util.Enumeration;
import java.util.Hashtable;

public class RASConfig
extends Hashtable {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static final long serialVersionUID = -5466198196850427009L;
    private boolean modified = false;
    private transient int inUseCount = 0;
    private transient RASObject object = null;

    public RASConfig() {
    }

    public RASConfig(Hashtable hashtable) {
        this.setConfig(hashtable);
    }

    public Hashtable getConfig() {
        return this;
    }

    public void setConfig(Hashtable hashtable) {
        Object object;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            this.put(object, hashtable.get(object));
        }
        object = this.getObject();
        if (object != null) {
            ((RASObject)object).setConfig(hashtable);
        }
    }

    public int getInUseCount() {
        return this.inUseCount;
    }

    public void setInUseCount(int n) {
        this.inUseCount = n;
    }

    public int incrementInUseCount() {
        ++this.inUseCount;
        return this.inUseCount;
    }

    public int decrementInUseCount() {
        if (this.inUseCount > 0) {
            --this.inUseCount;
        }
        return this.inUseCount;
    }

    public synchronized void setModified(boolean bl) {
        this.modified = bl;
    }

    public synchronized boolean isModified() {
        return this.modified;
    }

    public RASObject getObject() {
        return this.object;
    }

    public void setObject(RASObject rASObject) {
        this.object = rASObject;
    }

    protected void updateActiveObjects(RASConfig rASConfig) {
        RASObject rASObject;
        if (rASConfig != null && (rASObject = rASConfig.getObject()) != null) {
            this.setObject(rASObject);
            this.setInUseCount(rASConfig.getInUseCount());
            rASObject.setConfig(this);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        stringBuffer.append("    RASConfig Object:\r\n");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append("      " + string + ":  " + (String)this.get(string) + "\r\n");
        }
        stringBuffer.append("      In Use Count:  " + this.inUseCount + "\r\n");
        return stringBuffer.toString();
    }
}

