/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASIQueue;
import com.ibm.ras.RASQueueEmptyException;
import com.ibm.ras.RASQueueFullException;
import com.ibm.ras.RASUtil;
import java.util.Vector;

public class RASQueue
implements RASIQueue {
    private static final String S = "(C) Copyright Tivoli Systems 1999.";
    private int maxQueueSize;
    private Vector queue;

    public RASQueue() {
        this(0);
    }

    public RASQueue(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException(RASUtil.rasMsgs.getMessage("ERR_QUEUE_SIZE", new Integer(n)));
        }
        this.maxQueueSize = n;
        if (n == 0) {
            n = 1000;
            this.queue = new Vector(n, n);
        } else {
            this.queue = new Vector(n);
        }
    }

    public synchronized int getQueueSize() {
        return this.queue.size();
    }

    public int getMaximumQueueSize() {
        return this.maxQueueSize;
    }

    public synchronized boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public synchronized boolean isFull() {
        int n = this.getMaximumQueueSize();
        return this.getQueueSize() >= n && n != 0;
    }

    public boolean isCircular() {
        return false;
    }

    public synchronized void enqueue(Object object) throws RASQueueFullException {
        if (object != null) {
            if (this.isFull()) {
                throw new RASQueueFullException();
            }
            this.queue.addElement(object);
        }
    }

    public synchronized Object dequeue() throws RASQueueEmptyException {
        Object object = this.firstObject();
        this.queue.removeElementAt(0);
        return object;
    }

    public void requeue(Object object) {
        if (object != null) {
            this.queue.insertElementAt(object, 0);
        }
    }

    public synchronized Object firstObject() throws RASQueueEmptyException {
        if (this.isEmpty()) {
            throw new RASQueueEmptyException();
        }
        return this.queue.firstElement();
    }
}

