/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.LogRolloverListener;
import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ws.logging.TraceLogFormatter;
import com.ibm.ws.logging.WsHandler;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.logging.LogRecord;

class TraceLogger
implements WsHandler,
LogRolloverListener {
    private boolean ivBasicFormat;
    private ByteArrayOutputStream ivHeaderBaos;
    private PrintStream ivHeaderPs;
    OutputStream ivOs;
    PrintStream ivOut;
    String ivCharEncoding = null;

    TraceLogger(OutputStream outputStream) {
        this.ivOs = outputStream;
        this.ivOut = new PrintStream(outputStream, true);
        this.ivCharEncoding = null;
        this.ivHeaderBaos = new ByteArrayOutputStream();
        this.ivHeaderPs = new PrintStream(this.ivHeaderBaos, false);
    }

    TraceLogger(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this.ivOs = outputStream;
        this.ivOut = new PrintStream(outputStream, true, string);
        this.ivCharEncoding = string;
        this.ivHeaderBaos = new ByteArrayOutputStream();
        this.ivHeaderPs = new PrintStream((OutputStream)this.ivHeaderBaos, false, string);
    }

    TraceLogger(OutputStream outputStream, boolean bl) {
        this(outputStream);
        this.ivBasicFormat = bl;
    }

    TraceLogger(OutputStream outputStream, boolean bl, String string) throws UnsupportedEncodingException {
        this(outputStream, string);
        this.ivBasicFormat = bl;
    }

    public synchronized void logRolled() {
        this.printHeader();
    }

    public void processEvent(LogRecord logRecord) {
        if (logRecord == null) {
            return;
        }
        WsLogRecord wsLogRecord = WsLogRecordFactory.getWsLogRecordIfConvertible(logRecord);
        if (wsLogRecord != null && wsLogRecord.getExtension("service_log_only") != null) {
            return;
        }
        this.doLog(logRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doLog(LogRecord logRecord) {
        String string = this.ivBasicFormat ? TraceLogFormatter.formatBasic(logRecord) : TraceLogFormatter.formatAdvanced(logRecord);
        TraceLogger traceLogger = this;
        synchronized (traceLogger) {
            this.ivOut.println(string);
        }
    }

    synchronized void printHeader() {
        String string;
        String string2 = "************ Start Display Current Environment ************";
        String string3 = "************* End Display Current Environment *************";
        String string4 = "WebSphere {0} running with process name {1} and process id {2}";
        String string5 = "Host Operating System is {0}, version {1}";
        String string6 = "Java version = {0}, Java Compiler = {1}, Java VM name = {2}";
        String string7 = "was.install.root = {0}";
        String string8 = "user.install.root = {0}";
        String string9 = "Java Home = {0}";
        String string10 = "ws.ext.dirs = {0}";
        String string11 = "Classpath = {0}";
        String string12 = "Java Library path = {0}";
        String string13 = "Current trace specification = {0}";
        this.ivHeaderBaos.reset();
        this.ivHeaderPs.println(string2);
        String string14 = RasHelper.getVersionId();
        if (string14 != null && !string14.equals("")) {
            this.ivHeaderPs.println(MessageFormat.format(string4, string14, RasHelper.getServerName(), RasHelper.getProcessId()));
        }
        if ((string = RasHelper.getSystemProperty("java.fullversion")) == null) {
            string = RasHelper.getSystemProperty("java.version");
        }
        String string15 = RasHelper.getSystemProperty("os.name");
        String string16 = RasHelper.getSystemProperty("os.version");
        this.ivHeaderPs.println(MessageFormat.format(string5, string15, string16));
        string15 = RasHelper.getSystemProperty("java.compiler");
        string16 = RasHelper.getSystemProperty("java.vm.name");
        this.ivHeaderPs.println(MessageFormat.format(string6, string, string15, string16));
        this.ivHeaderPs.println(MessageFormat.format(string7, RasHelper.getSystemProperty("was.install.root")));
        this.ivHeaderPs.println(MessageFormat.format(string8, RasHelper.getSystemProperty("user.install.root")));
        this.ivHeaderPs.println(MessageFormat.format(string9, RasHelper.getSystemProperty("java.home")));
        this.ivHeaderPs.println(MessageFormat.format(string10, RasHelper.getSystemProperty("ws.ext.dirs")));
        this.ivHeaderPs.println(MessageFormat.format(string11, RasHelper.getSystemProperty("java.class.path")));
        this.ivHeaderPs.println(MessageFormat.format(string12, RasHelper.getSystemProperty("java.library.path")));
        this.ivHeaderPs.println(MessageFormat.format(string13, ManagerAdmin.getTraceSpecification()));
        this.ivHeaderPs.println(string3);
        this.ivHeaderPs.flush();
        byte[] byArray = this.ivHeaderBaos.toByteArray();
        try {
            this.ivOs.write(byArray);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    synchronized void printFooter(int n) {
    }
}

