/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasEvent;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.ras.Traceable;
import com.ibm.ejs.ras.Untraceable;
import com.ibm.websphere.ras.RasMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;
import java.util.Locale;

public class MessageEvent
extends RasEvent
implements RasMessage {
    private static final long serialVersionUID = 4537833367680944037L;
    private static final int svClassVersion = 2;
    private static int svMaxStringSize = 1000;
    private int ivClassVersion = 2;
    String ivBundleName;
    private Object[] ivMsgParms;
    private transient String tivFormattedMessage = null;

    public MessageEvent(int n, TraceComponent traceComponent, String string, String string2, Object object, String string3, String string4, String string5, String string6, String string7, String string8) {
        super(n, traceComponent, string6, string7, string, string3, string4, string5, string8, true);
        this.ivBundleName = string2;
        this.convertParameters(object);
        if (this.ivBundleName == null) {
            if (this.ivMsgParms != null) {
                StringBuffer stringBuffer = new StringBuffer(this.ivMsgKey);
                int n2 = this.ivMsgParms.length;
                for (int i = 0; i < n2; ++i) {
                    stringBuffer.append(" ");
                    stringBuffer.append(this.ivMsgParms[i].toString());
                }
                this.ivMsgKey = new String(stringBuffer);
            }
            this.tivFormattedMessage = this.ivMsgKey;
        } else {
            this.tivFormattedMessage = this.getLocalizedMessage(Locale.getDefault());
        }
    }

    MessageEvent(int n, TraceComponent traceComponent, String string, String string2, Object object) {
        super(n, traceComponent, null, string, string2, "IBM", "WebSphere", "Application Server", null, false);
        this.ivBundleName = traceComponent.getResourceBundleName();
        this.convertParameters(object);
        this.tivFormattedMessage = this.getLocalizedMessage(Locale.getDefault());
    }

    MessageEvent() {
    }

    public String getMessageSeverity() {
        switch (this.ivType) {
            case 1: {
                return "Audit";
            }
            case 4: {
                return "Error";
            }
            case 8: {
                return "Fatal";
            }
            case 9: {
                return "Service";
            }
            case 10: {
                return "Warning";
            }
            case 11: {
                return "Informational";
            }
        }
        return "Unknown";
    }

    public String getMessageKey() {
        return this.ivMsgKey;
    }

    public String getResourceBundleName() {
        return this.ivBundleName;
    }

    public String getMessageOriginator() {
        return this.ivEventSource;
    }

    public String getLocalizedMessage(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.ivBundleName == null) {
            return this.ivMsgKey;
        }
        String string = this.ivMsgKey.replace(' ', '.');
        if (this.ivMsgParms == null) {
            return TraceNLS.getStringFromBundle(this.ivBundleName, string, locale, this.ivMsgKey);
        }
        return TraceNLS.getFormattedMessage(this.ivBundleName, string, locale, this.ivMsgParms, this.ivMsgKey);
    }

    public String formatBasic(StringBuffer stringBuffer, DateFormat dateFormat, Date date, FieldPosition fieldPosition) {
        this.formatHeaderBasic(stringBuffer, dateFormat, date, fieldPosition);
        stringBuffer.append(this.tivFormattedMessage);
        if (this.ivExtendedMessage != null) {
            stringBuffer.append(lineSeparator);
            stringBuffer.append(svBasicPadding);
            stringBuffer.append(this.ivExtendedMessage);
        }
        return new String(stringBuffer);
    }

    public String formatAdvanced(StringBuffer stringBuffer, DateFormat dateFormat, Date date, FieldPosition fieldPosition) {
        this.formatHeaderAdvanced(stringBuffer, dateFormat, date, fieldPosition);
        stringBuffer.append(lineSeparator);
        stringBuffer.append(svAdvancedPadding);
        stringBuffer.append(this.tivFormattedMessage);
        if (this.ivExtendedMessage != null) {
            stringBuffer.append(lineSeparator);
            stringBuffer.append(svAdvancedPadding);
            stringBuffer.append(this.ivExtendedMessage);
        }
        return new String(stringBuffer);
    }

    final Object[] getMessageInserts() {
        return this.ivMsgParms;
    }

    private void convertParameters(Object object) {
        if (object == null) {
            this.ivMsgParms = null;
            return;
        }
        Object[] objectArray = null;
        Class<?> clazz = object.getClass();
        objectArray = clazz.isArray() ? (Object.class.isAssignableFrom(clazz.getComponentType()) ? (Object[])object : RasHelper.primitiveArrayToString(object)) : new Object[]{object};
        int n = objectArray.length;
        this.ivMsgParms = new Object[n];
        String string = null;
        for (int i = n - 1; i >= 0; --i) {
            if (objectArray[i] == null) {
                this.ivMsgParms[i] = "<null>";
                continue;
            }
            if (objectArray[i] instanceof String) {
                this.ivMsgParms[i] = objectArray[i];
                continue;
            }
            if (objectArray[i] instanceof Number || objectArray[i] instanceof Date) {
                this.ivMsgParms[i] = objectArray[i];
                continue;
            }
            try {
                string = objectArray[i] instanceof Untraceable ? objectArray[i].getClass().getName() : (objectArray[i] instanceof Traceable ? ((Traceable)objectArray[i]).toTraceString() : (objectArray[i] instanceof Throwable ? RasHelper.throwableToString((Throwable)objectArray[i]) : objectArray[i].toString()));
                if (string == null) {
                    string = "<malformed parameter>";
                }
                this.ivMsgParms[i] = string;
                continue;
            }
            catch (Throwable throwable) {
                this.ivMsgParms[i] = "<malformed parameter>";
            }
        }
    }

    void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        int n;
        dataOutputStream.writeInt(this.ivClassVersion);
        if (this.ivOrganization == null) {
            dataOutputStream.writeUTF("");
        } else {
            dataOutputStream.writeUTF(this.ivOrganization);
        }
        if (this.ivProduct == null) {
            dataOutputStream.writeUTF("");
        } else {
            dataOutputStream.writeUTF(this.ivProduct);
        }
        if (this.ivComponent == null) {
            dataOutputStream.writeUTF("");
        } else {
            dataOutputStream.writeUTF(this.ivComponent);
        }
        dataOutputStream.writeUTF(this.ivVersion);
        if (this.ivEventSource == null) {
            dataOutputStream.writeUTF("");
        } else {
            dataOutputStream.writeUTF(this.ivEventSource);
        }
        if (this.ivMethodName == null) {
            dataOutputStream.writeUTF("");
        } else {
            dataOutputStream.writeUTF(this.ivMethodName);
        }
        dataOutputStream.writeUTF(this.ivThreadId);
        if (this.ivProcessId == null) {
            dataOutputStream.writeUTF("");
        } else {
            dataOutputStream.writeUTF(this.ivProcessId);
        }
        dataOutputStream.writeUTF(this.ivServerName);
        if (this.ivMsgKey == null) {
            dataOutputStream.writeUTF("");
        } else {
            dataOutputStream.writeUTF(this.ivMsgKey);
        }
        if (this.ivBundleName == null) {
            dataOutputStream.writeUTF("");
        } else {
            dataOutputStream.writeUTF(this.ivBundleName);
        }
        if (this.ivExtendedMessage == null) {
            dataOutputStream.writeUTF("");
        } else {
            dataOutputStream.writeUTF(this.ivExtendedMessage);
        }
        if (this.ivUnitOfWork == null) {
            dataOutputStream.writeUTF("");
        } else {
            dataOutputStream.writeUTF(this.ivUnitOfWork);
        }
        dataOutputStream.writeLong(this.ivTimeStamp);
        dataOutputStream.writeInt(this.ivType);
        if (this.ivMsgParms == null) {
            dataOutputStream.writeInt(0);
        } else {
            n = this.ivMsgParms.length;
            dataOutputStream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                dataOutputStream.writeUTF(this.ivMsgParms[i].toString());
            }
        }
        if (this.ivRawData == null) {
            dataOutputStream.writeInt(0);
        } else {
            n = this.ivRawData.length;
            dataOutputStream.writeInt(n);
            dataOutputStream.write(this.ivRawData, 0, n);
        }
        if (this.ivClassName == null) {
            dataOutputStream.writeUTF("");
        } else {
            dataOutputStream.writeUTF(this.ivClassName);
        }
    }

    void readFromStream(DataInputStream dataInputStream) throws IOException {
        int n;
        this.ivClassVersion = dataInputStream.readInt();
        this.ivOrganization = dataInputStream.readUTF();
        this.ivProduct = dataInputStream.readUTF();
        this.ivComponent = dataInputStream.readUTF();
        this.ivVersion = dataInputStream.readUTF();
        this.ivEventSource = dataInputStream.readUTF();
        this.ivMethodName = dataInputStream.readUTF();
        this.ivThreadId = dataInputStream.readUTF();
        this.ivProcessId = dataInputStream.readUTF();
        this.ivServerName = dataInputStream.readUTF();
        this.ivMsgKey = dataInputStream.readUTF();
        this.ivBundleName = dataInputStream.readUTF();
        this.ivExtendedMessage = dataInputStream.readUTF();
        this.ivUnitOfWork = dataInputStream.readUTF();
        this.ivTimeStamp = dataInputStream.readLong();
        this.ivType = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        if (n2 == 0) {
            this.ivMsgParms = null;
        } else {
            this.ivMsgParms = new Object[n2];
            for (n = 0; n < n2; ++n) {
                String string = dataInputStream.readUTF();
                this.ivMsgParms[n] = string;
            }
        }
        n = dataInputStream.readInt();
        if (n == 0) {
            this.ivRawData = null;
        } else {
            this.ivRawData = new byte[n];
            dataInputStream.read(this.ivRawData, 0, n);
        }
        if (this.ivClassVersion == 2) {
            this.ivClassName = dataInputStream.readUTF();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.ivMsgParms != null) {
            int n = this.ivMsgParms.length;
            for (int i = 0; i < n; ++i) {
                String string;
                if (!(this.ivMsgParms[i] instanceof String) || (string = (String)this.ivMsgParms[i]).length() <= svMaxStringSize) continue;
                string = string.substring(0, svMaxStringSize - 1) + "  -- <truncated> --";
                this.ivMsgParms[i] = string;
            }
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    static {
        try {
            String string = RasHelper.getSystemProperty("com.ibm.ws.ras.MessageElementSize");
            if (string == null) {
                svMaxStringSize = 1000;
            } else {
                svMaxStringSize = Integer.parseInt(string);
                if (svMaxStringSize < 100) {
                    svMaxStringSize = 100;
                }
            }
        }
        catch (Throwable throwable) {
            svMaxStringSize = 1000;
        }
    }
}

