

!EmImageBuilder class privateMethods !

createMethods

	 "Private - Create the methods specified by the builder classes."

"
	 - change the exitBlock to remove new class names from the global namespace if a method cannot be created...
	   collisions have already been dealt with.
	 - add each new class name and unknown pool dictionary to the global namespace so code will compile correctly.
	 - when creating the methods, compile/link or rebind variables depending the severity of the changes
	   (if the shape or # of instVars of the class changed then compile otherwise rebind).
	 - any methods that must be compiled are remembered and compiled after all other methods have been dealt with.
"

	 | newGlobals oldExitBlock needToLink appsWithoutBytecodes removedSelectors storedNewByteCodesOrShadow total index |

	##PR = ##'1EIUNFA'.

	 self secondaryMessageString:  ( NlsCatEMbsES  residentMsg: 'MxEMbsES28' ) ;  "$NLS$ Creating methods..."
		  fractionComplete: 0;
		  cancelIfRequired.

	 newGlobals := OrderedCollection new.
	 oldExitBlock := exitBlock.
	 exitBlock := [
		  newGlobals do: [:var | System image globalNamespace removeKey: var].
		  ^ oldExitBlock value].

	classesToLoad do: [:cl |
		(System image globalNamespace classAt: cl symbol) isNil ifTrue: [
			   "Have already checked to make sure a global does not exist with the same name."
			   System image globalNamespace declareVariable: cl symbol.
			   newGlobals add: cl symbol].
		  cl newClass sharedPoolNames do: [:poolName |
			   System image globalNamespace poolDictionaryAt: poolName ifAbsent: [
					(System image globalNamespace includesKey: poolName)
						 ifTrue: [
							  self stopBecause: 358 withParms: (Array with: cl symbol with: cl controller signature with: poolName)]
						 ifFalse: [
							  "Defined pool dictionary %1"
							  EmImageSupport errorReporter
								   logError: 78
								   withParms: (Array with: poolName)].
					System image globalNamespace at: poolName put: EsPoolDictionary new.
					newGlobals add: poolName]]].

	 total := classesToLoad size.
	 index := 0. "For portability, do not use #doWithIndex:."
	 classesToLoad do: [:cl |
		| newAppNames |
		  index := index + 1.
		  needToLink := cl residentClass isNil or: [
			   cl residentClass methodFormatTimeStamp ~= cl newClass methodFormatTimeStamp].
		  appsWithoutBytecodes := Set new.
		  removedSelectors := OrderedCollection new.
		  cl classMD associationsDo: [:assoc |
			   (storedNewByteCodesOrShadow := self
					createMethodFrom: assoc
					in: cl newClass class
					orLink: needToLink) == false ifFalse: [
						 storedNewByteCodesOrShadow isNil
							  ifTrue: [removedSelectors add: assoc key]
							  ifFalse: [
								   storedNewByteCodesOrShadow class == EmShadowCompiledMethod
										ifTrue: [
											 cl addUnlinkableClassMethod: assoc value.
											 removedSelectors add: assoc key]
										ifFalse: [
											 appsWithoutBytecodes add: (cl newClass class applicationFor: assoc key)]]]].
		  removedSelectors do: [:sel | cl classMD removeKey: sel ifAbsent: []].

		  removedSelectors := OrderedCollection new.
		  cl instanceMD associationsDo: [:assoc |
			   (storedNewByteCodesOrShadow := self
					createMethodFrom: assoc
					in: cl newClass
					orLink: needToLink) == false ifFalse: [
						 storedNewByteCodesOrShadow isNil
							  ifTrue: [removedSelectors add: assoc key]
							  ifFalse: [
								   storedNewByteCodesOrShadow class == EmShadowCompiledMethod
										ifTrue: [
											 cl addUnlinkableInstanceMethod: assoc value.
											 removedSelectors add: assoc key]
										ifFalse: [
											 appsWithoutBytecodes add: (cl newClass applicationFor: assoc key)]]]].
		  removedSelectors do: [:sel | cl instanceMD removeKey: sel ifAbsent: []].

		cl newApplications notEmpty ifTrue: [
			cl newApplications do: [:app |
				(cl isVersionIn: app) ifTrue: [
					((cl editionEntryIn: app) knownFormats includes: cl newClass methodFormatTimeStamp) ifFalse: [
						cl newClass updateIn: app with: [:editionsRecord |
							editionsRecord currentEntry
								knowsMFTS: cl newClass methodFormatTimeStamp]]]].
			cl residentClass notNil ifTrue: [
				newAppNames := cl newApplications collect: [:app | app symbol].
				cl residentClass applications do: [:app |
					((newAppNames includes: app symbol) not and: [cl residentClass isVersionIn: app]) ifTrue: [
						((cl residentClass editionEntryIn: app) knownFormats includes: cl newClass methodFormatTimeStamp) ifFalse: [
							cl residentClass updateIn: app with: [:editionsRecord |
								editionsRecord currentEntry
									knowsMFTS: cl newClass methodFormatTimeStamp]]]]]].
		self
			fractionComplete: index / total;
			cancelIfRequired]! !