/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*      VisualAge Generator Server for OS/2, AIX, HP-UX, and Windows NT      */
/*                          Version 3.0  5697-C28                            */
/*                    (C) COPYRIGHT IBM CORP. 1994,1997                      */
/*                                                                           */
/*****************************************************************************/
#ifndef FCWRECD_H
#define FCWRECD_H

class Item;
class NumItem;
class RPCParm;

// *********************************************************************
// Parent of item's (ie. base of record and table strutures)
// *********************************************************************
class Parent
{
   friend class Item;
   private:
       LIST(Item*) LItems;
       char*       dataPtr;
       Bool        bAllocated;
       long        size;
       void*       pData;

   protected:
                   Parent(long);
      virtual      ~Parent();
      void         SetOccurs(int);
      void         Add(Item*);
      void         SetupRpc(LIST(RPCParm*)&, int&, int, Item*, Item*);

   public:
      void       Setup (void* b=NULL);
      void       SetEmpty();
      void       SetClear();

      char*      Data();
      void       SetData(void*);
      long       Size();
      void       SetSize(long);
      void       ConvertData( char, FILE* );
      Item*      GetItem(int);
};


/*-------------------------------------------------------------------------*/
/*  Record class definition -- base class for all record types             */
/*-------------------------------------------------------------------------*/
class Record : public Parameter, public Parent
{
  private:
    int            numberOfRPCEntries;
    LIST(RPCParm*) LRPCParm;                           /* List of RPC Parms*/
    void*          pData;

  protected:
    Record (long l);
    virtual ~Record ();

  public:
    void Setup (void* b=NULL);

    long ParmSize();
    char* ParmData();

    int& fNumberOfRPCEntries();
    LIST(RPCParm*)& RPCList();

    virtual void SetupRpc();
    virtual Item* getRLI();
    virtual Item* getNOI();
    virtual ItemType  itemType() const { return tRECORD; };
};

/*-------------------------------------------------------------------------*/
/*  FileRecord class - base class for all file  records                    */
/*-------------------------------------------------------------------------*/
class File;
class FileRecord : public Record
{
  protected:
    FileRecord(long l, char* n);
    FileRecord(long l, char* n, char* ft, char* rn);

    void CalcRecordLength();         /* Calculate length of var length recs*/
    void   SetRecOrg(char ro);
    void   SetRecFormat(char rf);

    File&     file();
    void      setRLI( NumItem* );
    Bool      hasRLI( );
    NumItem&  RLI( );
    void      setNOI( NumItem* );
    void      setFixedLength( long );
    void      setOccursItemLength( long );

  private:

    FCWString fileName;
    FCWString fileType;              /* File type (vsam, seq, tempmain, ..)*/
    FCWString resName;                 /* Resource name                    */
    File*     pfile;                   /* Pointer to associated file object*/
    char      recOrg;                 /* Record organization (serial, etc.)*/
    char      recFormat;               /* Record format (fixed, variable)  */

    NumItem* pRLI;                                    /* Record Length Item*/
    NumItem* pNOI;                                 /* Number of Occurs Item*/
    long     fixedLength;              /* Length of fixed-part of record   */
    long     occursItemLength;         /* Length of the Occurs Item        */
    void*    pData;

  public:
    virtual  ~FileRecord();
    void Setup();

    // General error checks
    int Err();
    int Hrd();

    // Soft errors
    int Eof();
    int Nrf();
    int Lok();
    int Dup();
    int Unq();

    // Hard errors
    int Ful();
    int Fmt();
    int Fnf();
    int Fna();

    // Compatibility  V2x
    int Ded();

    // operations
    void Close();
    void ChkStatus(char* operation);

    void  EZEDEST(char* n);
    void  EZEDEST( FCWString s );
    char* EZEDEST();

    FCWString& Name()        ;
    FCWString& Type()        ;
    FCWString& ResourceName();
    char    GetRecOrg()      ;
    char   GetRecFormat()    ;

    Item*  getRLI();
    Item*  getNOI();

    virtual Bool  isFileRecord() { return True; };
    int           GetStatus();
    void          SetStatus( int );
};

/*-------------------------------------------------------------------------*/
/*  SerialRecord class                                                     */
/*-------------------------------------------------------------------------*/
class SerialRecord : public FileRecord
{
  protected:
    SerialRecord(long l, char* n);
    SerialRecord(long l, char* n, char* ft, char* rn);
    virtual ~SerialRecord();

  public:

    void Add();
    void Scan();
    void Setup();
    void Setup(void* r);

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  VarLenSerialRecord class                                               */
/*-------------------------------------------------------------------------*/
class VarLenSerialRecord : public SerialRecord
{
  protected:
    VarLenSerialRecord(long l, char* n);
    VarLenSerialRecord(long l, char* n, char* ft, char* rn);
    virtual ~VarLenSerialRecord();

  public:
    void Add();
    void Scan();
    void Setup(void* r);
    void Setup(NumItem*, NumItem*, long, long);

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  IndexedRecord class                                                    */
/*-------------------------------------------------------------------------*/
class IndexedRecord : public FileRecord
{
  protected:
    IndexedRecord(long l, char* n, long ko, long kl);
    IndexedRecord(long l, char* n, long ko, long kl, char* ft, char* rn);
    virtual ~IndexedRecord();

    long keyLength;
    long keyOffSet;

  public:

    void Add();
    void Delete();
    void Inquiry();
    void Replace();
    void Scan();
    void ScanBack();
    void SetScan();
    void Update();
    void Setup();
    void Setup(void* r);

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  VarLenIndexedRecord class                                              */
/*-------------------------------------------------------------------------*/
class VarLenIndexedRecord : public IndexedRecord
{
  protected:
    VarLenIndexedRecord(long l, char* n, long ko, long kl);
    VarLenIndexedRecord(long l, char* n, long ko, long kl, char* ft, char* rn);
    virtual ~VarLenIndexedRecord();

  public:
    void Add();
    void Inquiry();
    void Replace();
    void Scan();
    void ScanBack();
    void Update();

    void Setup(void* r);
    void Setup(NumItem*, NumItem*, long, long);

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  RelativeRecord class                                                   */
/*-------------------------------------------------------------------------*/
class RelativeRecord : public FileRecord
{
  protected:
    RelativeRecord(long l, char* n);
    RelativeRecord(long l, char* n, char* ft, char* rn);
    virtual ~RelativeRecord();

    NumItem* pRII;                  /* Record Id Item (relative record num)*/
    long relRecNum;

  public:

    void Add();
    void Delete();
    void Inquiry();
    void Replace();
    void Scan();
    void Update();
    void Setup(void* r);
    void Setup(NumItem*);

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  Working Storage record class                                           */
/*-------------------------------------------------------------------------*/
class WSRecord : public Record
{
  protected:
    WSRecord (long l);
    virtual ~WSRecord();

  public:
    void Retrieve();

  private:
    void*    pData;
};


/*-------------------------------------------------------------------------*/
/*  Redefined Record class                                                 */
/*-------------------------------------------------------------------------*/
class RedefinedRecord : public WSRecord
{
  protected:
    RedefinedRecord (long l);
    virtual ~RedefinedRecord();

  public:
    void Setup( Record& );
    void Setup( void* );

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  Class definition for application and SQL EZEwords                      */
/*-------------------------------------------------------------------------*/
struct recEZEWORDS : public WSRecord
{
  public:
    recEZEWORDS(int);
    virtual ~recEZEWORDS();

  private:
    void*    pData;
};

struct  recEZESQL : public WSRecord
{
  public:
    recEZESQL(int);
    virtual ~recEZESQL();

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  Class definition for application and SQL EZEwords                      */
/*-------------------------------------------------------------------------*/
#define LENGTH_EZEDLPSB_NAME      8
#define LENGTH_EZEDLPSB_ADDRESS   4
#define LENGTH_EZEDLPSB_RECORD   LENGTH_EZEDLPSB_NAME + LENGTH_EZEDLPSB_ADDRESS

class  recEZEDLPSB : public WSRecord
{
  public:
     recEZEDLPSB(long l);
     virtual ~recEZEDLPSB();
     void Setup( void* p = NULL );
     void SetupRpc();
     virtual ItemType  itemType() const { return tEZEDLPSB; };

  private:
    void*    pData;
};

#endif
