package com.ibm.vap.ViewParts;

import java.rmi.RemoteException;
import com.ibm.vap.common.VapTransactionRequiredException;
import com.ibm.vap.Transactions.*;
import java.beans.*;
import com.ibm.vap.common.*;
/**
 * This type was created in VisualAge.
 */
public class BusinessTransaction implements VapActionListener {
	private static java.util.ResourceBundle resobjectExtender = java.util.ResourceBundle.getBundle("objectExtender");
	private Transaction transaction ;
	private Transaction parentTransaction ;
	public String name = null;
	protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
	private boolean generateReadOnlyParent = true ;
	private boolean rollbackTransactionWhenParentChanges = true ;
	private Transaction selfGeneratedReadOnlyTransaction ;
	private boolean isDestroyed = false;
/**
 * BusinessTransaction null constructor
 */
public BusinessTransaction() {
	super();
}
/**
 * This is the callback that one of our dependents has signalled an event
 * If it is our transaction and it is the rootCommittedOrRolledback event
 * then we should regenerate our transaction, attach ourself as a dependent of the new one
 * and also fire the change event.  For the old value we can use the one in the event source
 */
public void actionPerformed(VapEvent event) {
	if ( event.getSource() == transaction && event.getEventName() == "rootCommittedOrRolledback" ) {
		generateTransaction() ; }
}
/**
 * The addPropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void addPropertyChangeListener(java.beans.PropertyChangeListener arg1) {
	propertyChange.addPropertyChangeListener(arg1);
}
/**
 * Attach ourself as a dependent of our transaction
 * If it signals the rootCommittedOrRolledback event we wish to be informed of this
 */
private void attachAsDependentOfTransaction() {
	getTransaction().addActionListener(this) ;
}
/**
 * Commit our transaction.
 */
public void commit() throws java.rmi.RemoteException
{	if ( transaction != null ) {
		transaction.commitOrRollback() ; }
}
/**
 * Commit our transaction and do not generate a new transaction.
 */
public void commitAndDestroy() throws java.rmi.RemoteException
{	
	if ( transaction != null ) 
		transaction.removeActionListener(this) ;
	this.hasBeenDestroyed();
	this.commit();
}
/*	Create a readOnly shared transaction to use as our parent
 *	Do this only if our generateReadOnlyParent flag is true
 *	The purpose of this readOnly parent is so that when our transaction is committed or
 *	rolledback the transaction that is resumed ( our transaction's parent ) is a readOnly
 *	transaction rather than the SharedTransaction.  This way objects can still be read into
 *	the readOnly transaction
 */
public void createReadOnlyParentIfRequired() {
	if ( parentTransaction == null && transaction == null && getGenerateReadOnlyParent() == true )
		{ parentTransaction = getSelfGeneratedReadOnlyTransaction() ; }
}
/* 
 * This method is to be called when you want this business transaction
 * to stop generating transactions (i.e., the business transaction
 * is no longer being used).
 */
public void destroy() {
	
	if ( transaction != null ) {
		transaction.removeActionListener(this) ;
		try {
			transaction.rollback();
		} catch (RemoteException e1) { }
	
	}
	this.hasBeenDestroyed();

}
/**
 * The firePropertyChange method was generated to support the propertyChange field.
 */
public void firePropertyChange(String eventName, Object oldValue, Object newValue) {
	propertyChange.firePropertyChange(eventName, oldValue , newValue);
}
/* Generate a new transaction as a child of our current parent
 * If we have a parent use this as our parent,
 * If we do not have a parent check to see whether we should default to using the shared transaction,
 * or our own self generated read only shared ( which may have been previously generated )
 * If we have a name use this else use the default methods without name */

private Transaction generateFreshTransaction() {

	Transaction methodParent ;

	if ( isDestroyed == true ) return null ;

	if ( parentTransaction != null ) { methodParent = parentTransaction ; }
	else {
		if ( getGenerateReadOnlyParent() == true )
			{ methodParent = getSelfGeneratedReadOnlyTransaction() ; }
		else
			{ methodParent = Transaction.getShared() ; }
	}
	return methodParent.beginChild(getName()) ;
}
/* Generate a new transaction as a child of our current parent */

private void generateTransaction() {
	setTransaction(generateFreshTransaction());
	}
/* 	Return whether or not we should generate a read only parent
	If this is true when when we surface our transaction IF we do not
	have a parent specified we will generate a readOnly sub transaction of the
	Shared transaction to be our parent, otherwise we will create a new TopLevelTransaction
	of the shared transaction itself.
	The advantage of this being true is that after we have committed the resumed current transactin
	is the read only shared into which objects can be read.
	The disadvantages is that the readOnly shared will hang onto its versions indefinitely
	( until weakness is available in Java ) and these must therefore be managed by hand 
	to avoid memory problems ) */
public boolean getGenerateReadOnlyParent() {
	return generateReadOnlyParent ;
}
/**
 * Return the string that is used to name our transaction
 */
public String getName(){

	if ( name == null ) { name = resobjectExtender.getString("VapUnknown"); } //$NON-NLS-1$ 
	return name ;
}
/**
 * Getter
 */
public boolean getRollbackTransactionWhenParentChanges() {
	return rollbackTransactionWhenParentChanges ;
}
/* Return the self generated read only transaction.
   If we do not have one then generate one */

private Transaction getSelfGeneratedReadOnlyTransaction() {
	if ( selfGeneratedReadOnlyTransaction == null ) {
		selfGeneratedReadOnlyTransaction = Transaction.beginReadOnly() ; }
	return selfGeneratedReadOnlyTransaction ;
}
/**
 * Return the transaction.  Lazy initialize this
 * to be a new top level transaction
 */
public Transaction getTransaction() {
	if ( transaction == null ) 
		generateTransaction() ;
	return transaction ;
}
/* This BusinessTransaction has been destroyed, so set the
 * boolean isDestroyed to true to prevent another transaction
 * being generated if the parentTransaction changes.
 */

private void hasBeenDestroyed() {
	isDestroyed = true;
}
/**
 * The removePropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void removePropertyChangeListener(java.beans.PropertyChangeListener arg1) {
	propertyChange.removePropertyChangeListener(arg1);
}
/**
 * Rollback our transaction.
 */
public void rollback() throws RemoteException, VapTransactionRequiredException
{	if ( transaction != null ) {
		transaction.rollback() ; }
}
/* If we have the boolean rollbackTransactionWhenParentChanges true
 * then rollback our transaction
 * This is switchable because it is possible that someone took the transaction
 * and is still working with it, whereas for Visual programming there are circumstantes
 * where the transaction is generated lazily ahead of the parent being set and the transaction
 * is effectively private to us and we should make sure it gets rolledback
 */
private void rollbackTransactionIfRequired(Transaction aTransaction) {
	try {
	if ( rollbackTransactionWhenParentChanges == true ) {
		aTransaction.rollback() ;
		/*If a transaction has already been generated, make sure we resume it after rolling
		back aTransaction; otherwise, the shared transaction will be resumed.*/
		if ((transaction != null) && (transaction.isActive()))
			transaction.resume();
		}
	}
	catch ( VapTransactionRequiredException e1 ) { }
	catch (RemoteException e2) { }
}
// Return whether or not we should generate a read only parent
public void setGenerateReadOnlyParent(boolean aBool) {
	generateReadOnlyParent = aBool ;
}
/**
 * Set the string that is used to name our transaction
 */
public void setName(String aName){
	name = aName ;
}
/* Set the parent transaction
 * If we previously had a transaction then we must regenerate it
 * If our parent was a readOnly one that we generated we should roll it back
 */
public void setParentTransaction(Transaction parent){

	if (( parentTransaction == parent ) || ( isDestroyed == true ) ) return ;
	if ( ( parentTransaction != null && getGenerateReadOnlyParent() 
		&& parentTransaction == selfGeneratedReadOnlyTransaction ) == true ) {
		Transaction currentTransaction = Transaction.getCurrent();
		try
		{	parentTransaction.rollback() ;
			currentTransaction.resume();}
		catch ( VapTransactionRequiredException e ) { }
		catch (RemoteException e) { }
	}
	parentTransaction = parent ;
	if ( transaction != null ) {
		Transaction oldTransaction = transaction ;
		setTransaction(null);
		rollbackTransactionIfRequired(oldTransaction);
		if (transaction == null)
			generateTransaction() ; 
	}
}
/**
 * Setter
 */
public void setRollbackTransactionWhenParentChanges(boolean aBoolean) {
	rollbackTransactionWhenParentChanges = aBoolean;
}
/* Set the transaction ivar
 * Make sure the correct dependencies are hooked up so
 * we are informed when it is committed or rolledback */
private void setTransaction(Transaction aTransaction){
	if ( transaction != null ) 
		transaction.removeActionListener(this) ;
	transaction = aTransaction ;
	firePropertyChange("transaction" , null , transaction ) ;
	if ( aTransaction != null ) {
		attachAsDependentOfTransaction() ; }
}
}