package com.ibm.vap.Isolation;

/**
 * ExternalIsolationImplementor
 */

import java.rmi.RemoteException;
import java.util.Vector; 
import com.ibm.vap.Transactions.Version;
import com.ibm.vap.Transactions.Key;
import com.ibm.vap.Transactions.VapEJBObject;
import com.ibm.vap.Transactions.VapEJBHome;
import com.ibm.vap.common.VapReadFailureException;

public interface ExternalIsolationImplementor extends IsolationImplementor
{
/**
 * Read all instances from a home
 */
public Vector allInstancesWithLockFrom(VapEJBHome aHome) throws RemoteException, VapReadFailureException;
/**
 * Execute aQueryName from a home
 */
public Vector customQueryWithLockFrom(VapEJBHome aHome, String aQueryName, Object[] args) throws RemoteException, VapReadFailureException;
/**
 * Read an instance from a home
 */
public VapEJBObject findByPrimaryKeyWithLock(Key aKey, VapEJBHome aHome) throws RemoteException, VapReadFailureException;
/**
 * Mark the versiont externally locked after a db read.
 */
public void markExternallyLocked(Version aVersion);
}